/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2FishermanInstance
extends L2MerchantInstance {
    public L2FishermanInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/fisherman/", npcId, val);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("FishSkillList")) {
            player.setSkillLearningClassId(player.getClassId());
            this.showSkillList(player);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public void showSkillList(L2PcInstance player) {
        L2SkillLearn[] skills = SkillTreeTable.getInstance().getAvailableSkills(player);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.Fishing);
        int counts = 0;
        for (L2SkillLearn s : skills) {
            L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
            if (sk == null) continue;
            ++counts;
            asl.addSkill(s.getId(), s.getLevel(), s.getLevel(), s.getSpCost(), 1);
        }
        if (counts == 0) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            int minlevel = SkillTreeTable.getInstance().getMinLevelForNewSkill(player);
            if (minlevel > 0) {
                SystemMessage sm = new SystemMessage(SystemMessageId.DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN);
                sm.addNumber(minlevel);
                player.sendPacket(sm);
            } else {
                html.setHtml("<html><head><body>You've learned all skills.<br></body></html>");
                player.sendPacket(html);
            }
        } else {
            player.sendPacket(asl);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

