/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public class L2FortLogisticsInstance
extends L2MerchantInstance {
    private static final int BLOOD_OATH = 9910;

    public L2FortLogisticsInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        String par = "";
        if (st.countTokens() >= 1) {
            par = st.nextToken();
        }
        if (actualCommand.equalsIgnoreCase("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(par);
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showMessageWindow(player, val);
        } else {
            if (actualCommand.equalsIgnoreCase("rewards")) {
                if (player.getClan() != null && this.getFort().getOwnerClan() != null && player.getClan() == this.getFort().getOwnerClan() && player.isClanLeader()) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile("data/html/fortress/logistics-rewards.htm");
                    int blood = this.getFort().getBloodOathReward();
                    html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                    html.replace((CharSequence)"%bloodoath%", String.valueOf(blood));
                    player.sendPacket(html);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile("data/html/fortress/logistics-noprivs.htm");
                html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("blood")) {
                if (player.getClan() != null && this.getFort().getOwnerClan() != null && player.getClan() == this.getFort().getOwnerClan() && player.isClanLeader()) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    int blood = this.getFort().getBloodOathReward();
                    if (blood > 0) {
                        html.setFile("data/html/fortress/logistics-blood.htm");
                        player.addItem("Quest", 9910, blood, this, true);
                        this.getFort().setBloodOathReward(0);
                    } else {
                        html.setFile("data/html/fortress/logistics-noblood.htm");
                    }
                    html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(html);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile("data/html/fortress/logistics-noprivs.htm");
                html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                player.sendPacket(html);
                return;
            }
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        this.showMessageWindow(player, 0);
    }

    private void showMessageWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = val == 0 ? "data/html/fortress/logistics.htm" : "data/html/fortress/logistics-" + val + ".htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        html.replace((CharSequence)"%npcId%", String.valueOf(this.getNpcId()));
        if (this.getFort().getOwnerClan() != null) {
            html.replace((CharSequence)"%clanname%", this.getFort().getOwnerClan().getName());
        } else {
            html.replace((CharSequence)"%clanname%", "NPC");
        }
        player.sendPacket(html);
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }
}

