/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public final class L2ObservationInstance
extends L2Npc {
    public L2ObservationInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showChatWindow(player, val);
        } else if (command.startsWith("observeSiege")) {
            String val = command.substring(13);
            StringTokenizer st = new StringTokenizer(val);
            st.nextToken();
            if (SiegeManager.getInstance().getSiege(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())) != null) {
                this.doObserve(player, val);
            } else {
                player.sendPacket(new SystemMessage(SystemMessageId.ONLY_VIEW_SIEGE));
            }
        } else if (command.startsWith("observeOracle")) {
            String val = command.substring(13);
            StringTokenizer st = new StringTokenizer(val);
            st.nextToken();
            this.doObserve(player, val);
        } else if (command.startsWith("observe")) {
            this.doObserve(player, command.substring(8));
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    private void doObserve(L2PcInstance player, String val) {
        StringTokenizer st = new StringTokenizer(val);
        long cost = Long.parseLong(st.nextToken());
        int x = Integer.parseInt(st.nextToken());
        int y = Integer.parseInt(st.nextToken());
        int z = Integer.parseInt(st.nextToken());
        if (player.reduceAdena("Broadcast", cost, this, true)) {
            player.enterObserverMode(x, y, z);
            player.sendPacket(new ItemList(player, false));
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        String filename = null;
        filename = this.isInsideRadius(-79884, 86529, 50, true) || this.isInsideRadius(-78858, 111358, 50, true) || this.isInsideRadius(-76973, 87136, 50, true) || this.isInsideRadius(-75850, 111968, 50, true) ? (val == 0 ? "data/html/observation/" + this.getNpcId() + "-Oracle.htm" : "data/html/observation/" + this.getNpcId() + "-Oracle-" + val + ".htm") : (val == 0 ? "data/html/observation/" + this.getNpcId() + ".htm" : "data/html/observation/" + this.getNpcId() + "-" + val + ".htm");
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
    }
}

