/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.AttackableKnownList;

public class MonsterKnownList
extends AttackableKnownList {
    public MonsterKnownList(L2MonsterInstance activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object instanceof L2PcInstance && this.getActiveChar().getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
        }
        return true;
    }

    @Override
    public boolean removeKnownObject(L2Object object) {
        if (!super.removeKnownObject(object)) {
            return false;
        }
        if (!(object instanceof L2Character)) {
            return true;
        }
        if (this.getActiveChar().hasAI()) {
            this.getActiveChar().getAI().notifyEvent(CtrlEvent.EVT_FORGET_OBJECT, object);
        }
        if (this.getActiveChar().isVisible() && this.getKnownPlayers().isEmpty() && this.getKnownSummons().isEmpty()) {
            this.getActiveChar().clearAggroList();
        }
        return true;
    }

    @Override
    public final L2MonsterInstance getActiveChar() {
        return (L2MonsterInstance)super.getActiveChar();
    }
}

