/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.serverpackets.AgitDecoInfo;

public class L2ClanHallZone
extends L2ZoneType {
    private int _clanHallId;
    private int[] _spawnLoc = new int[3];

    public L2ClanHallZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("clanHallId")) {
            this._clanHallId = Integer.parseInt(value);
            ClanHallManager.getInstance().getClanHallById(this._clanHallId).setZone(this);
        } else if (name.equals("spawnX")) {
            this._spawnLoc[0] = Integer.parseInt(value);
        } else if (name.equals("spawnY")) {
            this._spawnLoc[1] = Integer.parseInt(value);
        } else if (name.equals("spawnZ")) {
            this._spawnLoc[2] = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)4, true);
            ClanHall clanHall = ClanHallManager.getInstance().getClanHallById(this._clanHallId);
            if (clanHall == null) {
                return;
            }
            AgitDecoInfo deco = new AgitDecoInfo(clanHall);
            ((L2PcInstance)character).sendPacket(deco);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)4, false);
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public void banishForeigners(int owningClanId) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance) || ((L2PcInstance)temp).getClanId() == owningClanId) continue;
            ((L2PcInstance)temp).teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
    }

    public Location getSpawn() {
        return new Location(this._spawnLoc[0], this._spawnLoc[1], this._spawnLoc[2]);
    }

    public int getClanHallId() {
        return this._clanHallId;
    }
}

