/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharDeleteFail;
import com.l2jserver.gameserver.network.serverpackets.CharDeleteSuccess;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CharacterDelete
extends L2GameClientPacket {
    private static final String _C__0C_CHARACTERDELETE = "[C] 0C CharacterDelete";
    private static Logger _log = Logger.getLogger(CharacterDelete.class.getName());
    private int _charSlot;

    @Override
    protected void readImpl() {
        this._charSlot = this.readD();
    }

    @Override
    protected void runImpl() {
        if (Config.DEBUG) {
            _log.fine("deleting slot:" + this._charSlot);
        }
        try {
            byte answer = ((L2GameClient)this.getClient()).markToDeleteChar(this._charSlot);
            switch (answer) {
                default: {
                    break;
                }
                case 0: {
                    this.sendPacket(new CharDeleteSuccess());
                    break;
                }
                case 1: {
                    this.sendPacket(new CharDeleteFail(2));
                    break;
                }
                case 2: {
                    this.sendPacket(new CharDeleteFail(3));
                    break;
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error:", e);
        }
        CharSelectionInfo cl = new CharSelectionInfo(((L2GameClient)this.getClient()).getAccountName(), ((L2GameClient)this.getClient()).getSessionId().playOkID1, 0);
        this.sendPacket(cl);
        ((L2GameClient)this.getClient()).setCharSelection(cl.getCharInfo());
    }

    @Override
    public String getType() {
        return _C__0C_CHARACTERDELETE;
    }
}

