/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.GMHennaInfo;
import com.l2jserver.gameserver.network.serverpackets.GMViewCharacterInfo;
import com.l2jserver.gameserver.network.serverpackets.GMViewItemList;
import com.l2jserver.gameserver.network.serverpackets.GMViewPledgeInfo;
import com.l2jserver.gameserver.network.serverpackets.GMViewSkillInfo;
import com.l2jserver.gameserver.network.serverpackets.GMViewWarehouseWithdrawList;
import com.l2jserver.gameserver.network.serverpackets.GmViewQuestInfo;
import java.util.logging.Logger;

public final class RequestGMCommand
extends L2GameClientPacket {
    private static final String _C__6E_REQUESTGMCOMMAND = "[C] 6e RequestGMCommand";
    static Logger _log = Logger.getLogger(RequestGMCommand.class.getName());
    private String _targetName;
    private int _command;

    @Override
    protected void readImpl() {
        this._targetName = this.readS();
        this._command = this.readD();
    }

    @Override
    protected void runImpl() {
        if (!((L2GameClient)this.getClient()).getActiveChar().isGM() || !((L2GameClient)this.getClient()).getActiveChar().getAccessLevel().allowAltG()) {
            return;
        }
        L2PcInstance player = L2World.getInstance().getPlayer(this._targetName);
        if (player == null) {
            return;
        }
        switch (this._command) {
            case 1: {
                this.sendPacket(new GMViewCharacterInfo(player));
                this.sendPacket(new GMHennaInfo(player));
                break;
            }
            case 2: {
                if (player.getClan() == null) break;
                this.sendPacket(new GMViewPledgeInfo(player.getClan(), player));
                break;
            }
            case 3: {
                this.sendPacket(new GMViewSkillInfo(player));
                break;
            }
            case 4: {
                this.sendPacket(new GmViewQuestInfo(player));
                break;
            }
            case 5: {
                this.sendPacket(new GMViewItemList(player));
                break;
            }
            case 6: {
                this.sendPacket(new GMViewWarehouseWithdrawList(player));
            }
        }
    }

    @Override
    public String getType() {
        return _C__6E_REQUESTGMCOMMAND;
    }
}

