/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.ItemInfo;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;

public class PetInventoryUpdate
extends L2GameServerPacket {
    private static Logger _log = Logger.getLogger(InventoryUpdate.class.getName());
    private static final String _S__37_INVENTORYUPDATE = "[S] b4 InventoryUpdate";
    private List<ItemInfo> _items;

    public PetInventoryUpdate(List<ItemInfo> items) {
        this._items = items;
        if (Config.DEBUG) {
            this.showDebug();
        }
    }

    public PetInventoryUpdate() {
        this((List<ItemInfo>)new FastList());
    }

    public void addItem(L2ItemInstance item) {
        this._items.add(new ItemInfo(item));
    }

    public void addNewItem(L2ItemInstance item) {
        this._items.add(new ItemInfo(item, 1));
    }

    public void addModifiedItem(L2ItemInstance item) {
        this._items.add(new ItemInfo(item, 2));
    }

    public void addRemovedItem(L2ItemInstance item) {
        this._items.add(new ItemInfo(item, 3));
    }

    public void addItems(List<L2ItemInstance> items) {
        for (L2ItemInstance item : items) {
            this._items.add(new ItemInfo(item));
        }
    }

    private void showDebug() {
        for (ItemInfo item : this._items) {
            _log.fine("oid:" + Integer.toHexString(item.getObjectId()) + " item:" + item.getItem().getName() + " last change:" + item.getChange());
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(180);
        int count = this._items.size();
        this.writeH(count);
        for (ItemInfo item : this._items) {
            this.writeH(item.getChange());
            this.writeH(item.getItem().getType1());
            this.writeD(item.getObjectId());
            this.writeD(item.getItem().getItemId());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(0);
            this.writeH(item.getEquipped());
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchant());
            this.writeH(0);
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__37_INVENTORYUPDATE;
    }
}

