/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.conditions;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.conditions.Condition;

public final class ConditionSiegeZone
extends Condition {
    public static final int COND_NOT_ZONE = 1;
    public static final int COND_CAST_ATTACK = 2;
    public static final int COND_CAST_DEFEND = 4;
    public static final int COND_CAST_NEUTRAL = 8;
    public static final int COND_FORT_ATTACK = 16;
    public static final int COND_FORT_DEFEND = 32;
    public static final int COND_FORT_NEUTRAL = 64;
    private final int _value;
    private final boolean _self;

    public ConditionSiegeZone(int value, boolean self) {
        this._value = value;
        this._self = self;
    }

    @Override
    public boolean testImpl(Env env) {
        L2Character target = this._self ? env.player : env.target;
        Castle castle = CastleManager.getInstance().getCastle(target);
        Fort fort = FortManager.getInstance().getFort(target);
        if (castle == null && fort == null) {
            return (this._value & 1) != 0;
        }
        if (castle != null) {
            return ConditionSiegeZone.checkIfOk(target, castle, this._value);
        }
        return ConditionSiegeZone.checkIfOk(target, fort, this._value);
    }

    public static boolean checkIfOk(L2Character activeChar, Castle castle, int value) {
        if (activeChar == null || !(activeChar instanceof L2PcInstance)) {
            return false;
        }
        L2PcInstance player = (L2PcInstance)activeChar;
        if (castle == null || castle.getCastleId() <= 0) {
            if ((value & 1) != 0) {
                return true;
            }
        } else if (!castle.getSiege().getIsInProgress()) {
            if ((value & 1) != 0) {
                return true;
            }
        } else {
            if (castle.getSiege().getAttackerClan(player.getClan()) != null && (value & 2) != 0) {
                return true;
            }
            if (castle.getSiege().getDefenderClan(player.getClan()) != null && (value & 4) != 0) {
                return true;
            }
            if (castle.getSiege().getAttackerClan(player.getClan()) == null && castle.getSiege().getDefenderClan(player.getClan()) == null && (value & 8) != 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIfOk(L2Character activeChar, Fort fort, int value) {
        if (activeChar == null || !(activeChar instanceof L2PcInstance)) {
            return false;
        }
        L2PcInstance player = (L2PcInstance)activeChar;
        if (fort == null || fort.getFortId() <= 0) {
            if ((value & 1) != 0) {
                return true;
            }
        } else if (!fort.getSiege().getIsInProgress()) {
            if ((value & 1) != 0) {
                return true;
            }
        } else {
            if (fort.getSiege().getAttackerClan(player.getClan()) != null && (value & 0x10) != 0) {
                return true;
            }
            if (fort.getOwnerClan() == player.getClan() && (value & 0x20) != 0) {
                return true;
            }
            if (fort.getSiege().getAttackerClan(player.getClan()) == null && fort.getOwnerClan() != player.getClan() && (value & 0x40) != 0) {
                return true;
            }
        }
        return false;
    }
}

