DROP TABLE IF EXISTS `zone_vertices`;
CREATE TABLE `zone_vertices` (
  `id` int(11) NOT NULL,
  `order` int(11) NOT NULL,
  `x` int(11) NOT NULL,
  `y` int(11) NOT NULL,
  PRIMARY KEY (`id`,`order`)
);

-- NOTE: Cuboid shapes only need 2 points in order to be defined.
-- That is their NorthWest and SouthEast corners suffice to descript a cuboid.
-- All other shapes require 3 or more vertices.
-- NOTE 2: The order is outmost important for many shapes and thus special
-- care is recommended.  Order doesn't really matter much for cuboids and prisms
-- (triangular base) but it is best to pay attention to the order there, too,
-- keeping the definitions as much as possible in a loop from NW to SE.

-- Arena Zones
INSERT INTO `zone_vertices` VALUES
-- Monster Race Track
-- dion_monster_race1
(10000,0,11714,181568),
(10000,1,14406,181571),
(10000,2,14405,182673),
(10000,3,11714,182673),
-- dion_monster_race2
(10001,0,13309,181324),
(10001,1,14061,181324),
(10001,2,14061,181610),
(10001,3,13309,181610),
-- dion_monster_race3
(10002,0,13559,182641),
(10002,1,14073,182640),
(10002,2,14073,182919),
(10002,3,13560,182918),
-- dion_monster_race4
(10003,0,12196,182662),
(10003,1,12447,182663),
(10003,2,12447,182766),
(10003,3,12197,182766),
-- dion_monster_race5
(10004,0,11706,182774),
(10004,1,13194,182769),
(10004,2,13194,183006),
(10004,3,11701,183017),
-- dion_monster_race6
(10005,0,11701,184017),
(10005,1,13188,184011),
(10005,2,13194,184265),
(10005,3,11701,184260),
-- dion_monster_race7
(10006,0,11697,183013),
(10006,1,11945,183019),
(10006,2,11940,184015),
(10006,3,11697,184015),
-- dion_monster_race8
(10007,0,12945,183013),
(10007,1,13193,183008),
(10007,2,13193,184009),
(10007,3,12945,184009),
-- dion_monster_pvp
(10008,0,11947,183019),
(10008,1,12937,183019),
(10008,2,12943,184010),
(10008,3,11941,184010),

-- Gludin Arena
-- gludin_pvp
(10009,0,-88411,141732),
(10009,1,-87429,141733),
(10009,2,-87429,142708),
(10009,3,-88408,142708),
-- gludin_pvp_peace_1
(10010,0,-88445,141473),
(10010,1,-87166,141474),
(10010,2,-87166,141726),
(10010,3,-88441,141726),
-- gludin_pvp_peace_2
(10011,0,-88666,141473),
(10011,1,-88417,141474),
(10011,2,-88414,142740),
(10011,3,-88666,142746),
-- gludin_pvp_peace_3
(10012,0,-88665,142716),
(10012,1,-87165,142716),
(10012,2,-87165,142973),
(10012,3,-88667,142973),
-- gludin_pvp_peace_4
(10013,0,-87418,141681),
(10013,1,-87165,141680),
(10013,2,-87166,142779),
(10013,3,-87416,142779),

-- Giran Arena
-- giran_pvp_battle
(10014,0,72493,142263),
(10014,1,73493,142264),
(10014,2,73493,143261),
(10014,3,72495,143258),
-- giran_pvp_peace1
(10015,0,73490,142231),
(10015,1,73743,142232),
(10015,2,73741,143316),
(10015,3,73494,143312),
-- giran_pvp_peace2
(10016,0,72462,142013),
(10016,1,73744,142013),
(10016,2,73743,142268),
(10016,3,72461,142268),
-- giran_pvp_peace3
(10017,0,72244,142015),
(10017,1,72497,142012),
(10017,2,72497,143285),
(10017,3,72242,143280),
-- giran_pvp_peace4
(10018,0,72242,143255),
(10018,1,73743,143257),
(10018,2,73743,143513),
(10018,3,72243,143514),

-- Coliseum
-- colosseum_battle1
(10019,0,151252,45918),
(10019,1,151219,46182),
(10019,2,150677,46786),
(10019,3,148334,46788),
(10019,4,147748,46166),
(10019,5,147744,45916),
(10019,6,148238,45301),
(10019,7,150781,45307),
-- colosseum_battle2
(10020,0,151236,47268),
(10020,1,151255,47520),
(10020,2,150785,48132),
(10020,3,148258,48126),
(10020,4,147712,47532),
(10020,5,147728,47294),
(10020,6,148278,46707),
(10020,7,150697,46709),
-- colosseum_battle3
(10021,0,148047,46276),
(10021,1,150955,46276),
(10021,2,150956,47052),
(10021,3,148049,47053),
-- colosseum_peace1
(10022,0,147779,46196),
(10022,1,148045,46481),
(10022,2,148047,46958),
(10022,3,147772,47256),
(10022,4,147078,47258),
(10022,5,147095,46203),
-- colosseum_peace2
(10023,0,151221,46184),
(10023,1,151928,46183),
(10023,2,151925,47248),
(10023,3,151222,47262),
(10023,4,150952,46956),
(10023,5,150954,46486),

-- GM Consultation Service
-- gm_prison
(10024,0,-116390,-251581),
(10024,1,-112756,-251617),
(10024,2,-112720,-248199),
(10024,3,-116354,-248217),
-- gm_room
(10025,0,-115727,-251652),
(10025,1,-113365,-251655),
(10025,2,-113365,-248191),
(10025,3,-115727,-248194),
-- gm_room_solo1
(10026,0,-116299,-251426),
(10026,1,-115745,-251426),
(10026,2,-115745,-250840),
(10026,3,-116296,-250840),
-- gm_room_solo2
(10027,0,-113350,-251408),
(10027,1,-112797,-251407),
(10027,2,-112798,-250855),
(10027,3,-113353,-250857);

-- Clan Hall Zones
INSERT INTO `zone_vertices` VALUES
(11020,0,77170,147420),
(11020,1,79200,147420),
(11020,2,79200,144780),
(11020,3,80310,144780),
(11020,4,80310,143630),
(11020,5,83120,143630),
(11020,6,83120,143505),
(11020,7,83700,143505),
(11020,8,83700,141500),
(11020,9,84070,141500),
(11020,10,84070,143505),
(11020,11,85040,143505),
(11020,12,85040,145760),
(11020,13,86115,145760),
(11020,14,86115,146910),
(11020,15,88425,146910),
(11020,16,88425,147175),
(11020,17,90430,147175),
(11020,18,90430,147540),
(11020,19,88425,147540),
(11020,20,88425,150050),
(11020,21,86495,150050),
(11020,22,86495,150250),
(11020,23,85995,150250),
(11020,24,85995,152250),
(11020,25,86780,152250),
(11020,26,86780,153600),
(11020,27,84850,153600),
(11020,28,84850,152250),
(11020,29,85625,152250),
(11020,30,85265,150250),
(11020,31,85085,150250),
(11020,32,85085,149875),
(11020,33,83680,149875),
(11020,34,83680,149920),
(11020,35,83500,149920),
(11020,36,83500,151270),
(11020,37,82705,151270),
(11020,38,82705,152820),
(11020,39,79195,152820),
(11020,40,79195,149805),
(11020,41,77170,149805),
(11021,0,15704,15397),
(11021,1,15765,15878),
(11021,2,15801,16332),
(11021,3,14098,19672),
(11021,4,10278,20689),
(11021,5,8852,20421),
(11021,6,7484,18628),
(11021,7,7236,18042),
(11021,8,7141,17507),
(11021,9,7045,16819),
(11021,10,7382,14486),
(11021,11,13891,13025),
(11021,12,15542,15230),
(11022,0,-83739,245733),
(11022,1,-84049,246087),
(11022,2,-84289,246258),
(11022,3,-84556,246243),
(11022,4,-84984,245820),
(11022,5,-85336,245426),
(11022,6,-85684,245099),
(11022,7,-85969,244770),
(11022,8,-86400,244292),
(11022,9,-86664,243997),
(11022,10,-86940,243631),
(11022,11,-87517,243034),
(11022,12,-87650,242799),
(11022,13,-87613,242572),
(11022,14,-87348,242246),
(11022,15,-86956,241942),
(11022,16,-86656,241684),
(11022,17,-86343,241365),
(11022,18,-85829,240966),
(11022,19,-85544,240765),
(11022,20,-85193,240440),
(11022,21,-84865,240185),
(11022,22,-84594,239866),
(11022,23,-84284,239666),
(11022,24,-84002,239734),
(11022,25,-83822,239922),
(11022,26,-83640,240190),
(11022,27,-83295,240492),
(11022,28,-82990,240878),
(11022,29,-82635,241208),
(11022,30,-82234,241698),
(11022,31,-82027,241985),
(11022,32,-81684,242328),
(11022,33,-81421,242741),
(11022,34,-81113,243073),
(11022,35,-81011,243228),
(11022,36,-81029,243496),
(11022,37,-81340,243797),
(11022,38,-81691,244028),
(11022,39,-82292,244585),
(11022,40,-82787,244999),
(11022,41,-83726,245721),
(11023,0,45364,46535),
(11023,1,45895,46578),
(11023,2,46388,46713),
(11023,3,46861,46934),
(11023,4,47290,47232),
(11023,5,47659,47598),
(11023,6,47959,48024),
(11023,7,48182,48499),
(11023,8,48318,49006),
(11023,9,48364,49523),
(11023,10,48319,50048),
(11023,11,48186,50548),
(11023,12,47963,51022),
(11023,13,47661,51450),
(11023,14,47286,51836),
(11023,15,46864,52126),
(11023,16,46398,52345),
(11023,17,46313,52598),
(11023,18,45768,52597),
(11023,19,45735,52665),
(11023,20,45651,52791),
(11023,21,45520,52878),
(11023,22,45363,52912),
(11023,23,45210,52882),
(11023,24,45077,52794),
(11023,25,44993,52667),
(11023,26,44961,52600),
(11023,27,44422,52600),
(11023,28,44342,52347),
(11023,29,43867,52131),
(11023,30,43438,51827),
(11023,31,43075,51458),
(11023,32,42766,51019),
(11023,33,42546,50557),
(11023,34,42412,50051),
(11023,35,42367,49530),
(11023,36,42410,49012),
(11023,37,42547,48509),
(11023,38,42769,48034),
(11023,39,43065,47602),
(11023,40,43437,47232),
(11023,41,43859,46937),
(11023,42,44336,46713),
(11023,43,44843,46575),
(11023,44,45395,46530),
(11024,0,-45528,-110079),
(11024,1,-45711,-110075),
(11024,2,-45704,-110164),
(11024,3,-46633,-110080),
(11024,4,-46625,-109992),
(11024,5,-46803,-109993),
(11024,6,-47345,-109973),
(11024,7,-47388,-110012),
(11024,8,-47388,-113001),
(11024,9,-47351,-113039),
(11024,10,-47102,-113038),
(11024,11,-47107,-113382),
(11024,12,-47326,-113379),
(11024,13,-47326,-113829),
(11024,14,-47114,-113826),
(11024,15,-47102,-114171),
(11024,16,-47350,-114170),
(11024,17,-47388,-114199),
(11024,18,-47391,-117182),
(11024,19,-47339,-117239),
(11024,20,-46791,-117240),
(11024,21,-46607,-117240),
(11024,22,-46619,-117151),
(11024,23,-45701,-117000),
(11024,24,-45705,-117085),
(11024,25,-45523,-117088),
(11024,26,-44169,-116722),
(11024,27,-44147,-116804),
(11024,28,-43838,-116717),
(11024,29,-43855,-116638),
(11024,30,-43779,-116620),
(11024,31,-42581,-115424),
(11024,32,-42472,-115258),
(11024,33,-42051,-113671),
(11024,34,-42050,-113502),
(11024,35,-42474,-111925),
(11024,36,-42554,-111775),
(11024,37,-43843,-110456),
(11024,38,-44147,-110375),
(11024,39,-45529,-110078),
(11025,0,-84867,149371),
(11025,1,-82581,149364),
(11025,2,-82499,149139),
(11025,3,-81593,149177),
(11025,4,-81551,149410),
(11025,5,-79270,149392),
(11025,6,-79275,150365),
(11025,7,-79055,150368),
(11025,8,-78820,150429),
(11025,9,-78644,150595),
(11025,10,-78558,150837),
(11025,11,-78567,152410),
(11025,12,-78796,152420),
(11025,13,-78803,154319),
(11025,14,-77131,155437),
(11025,15,-78190,156459),
(11025,16,-79978,156104),
(11025,17,-84876,156106),
(11025,18,-84875,149371),
(11026,0,115499,-176771),
(11026,1,115301,-176769),
(11026,2,114877,-176811),
(11026,3,113385,-177602),
(11026,4,112934,-178507),
(11026,5,113954,-183578),
(11026,6,115493,-183698),
(11026,7,115748,-184078),
(11026,8,115936,-184197),
(11026,9,116268,-184243),
(11026,10,116716,-184246),
(11026,11,117023,-184162),
(11026,12,117211,-184022),
(11026,13,117325,-183825),
(11026,14,117490,-183411),
(11026,15,117629,-182930),
(11026,16,117762,-182686),
(11026,17,117762,-182260),
(11026,18,117734,-182090),
(11026,19,117531,-181747),
(11026,20,117452,-180534),
(11026,21,117492,-180010),
(11026,22,117466,-179559),
(11026,23,117327,-179170),
(11026,24,117328,-178966),
(11026,25,117303,-178695),
(11026,26,116860,-177230),
(11026,27,116806,-177131),
(11026,28,116650,-176975),
(11026,29,116418,-176887),
(11026,30,115929,-176804),
(11026,31,115490,-176767),
(11027,0,-14960,121148),
(11027,1,-14875,121120),
(11027,2,-14717,121106),
(11027,3,-14394,121109),
(11027,4,-14242,121104),
(11027,5,-12659,121098),
(11027,6,-12025,121767),
(11027,7,-12024,123944),
(11027,8,-12277,124668),
(11027,9,-12648,125573),
(11027,10,-12879,126199),
(11027,11,-13855,126470),
(11027,12,-14484,126463),
(11027,13,-15236,126178),
(11027,14,-16126,125356),
(11027,15,-16531,124493),
(11027,16,-16537,123850),
(11027,17,-16492,123330),
(11027,18,-16194,123160),
(11027,19,-16057,123101),
(11027,20,-15327,122741),
(11027,21,-14958,121150),
(11028,0,15264,141764),
(11028,1,15434,143574),
(11028,2,15760,144707),
(11028,3,15846,145302),
(11028,4,16134,146850),
(11028,5,16715,147153),
(11028,6,17844,147640),
(11028,7,18139,147138),
(11028,8,18541,146758),
(11028,9,18782,146598),
(11028,10,19069,146521),
(11028,11,19430,146485),
(11028,12,20363,146421),
(11028,13,20722,146319),
(11028,14,21415,146319),
(11028,15,21402,145011),
(11028,16,21381,143675),
(11028,17,20696,142841),
(11028,18,20380,142492),
(11028,19,19060,142463),
(11028,20,18821,142512),
(11028,21,17885,143046),
(11028,22,17447,143348),
(11028,23,17019,144028),
(11028,24,16780,142908),
(11028,25,17344,142847),
(11028,26,17327,142650),
(11028,27,17483,142634),
(11028,28,17396,141776),
(11028,29,17238,141792),
(11028,30,17218,141574),
(11028,31,15265,141765),
(11029,0,84014,52245),
(11029,1,84138,54683),
(11029,2,84143,55029),
(11029,3,84001,57029),
(11029,4,81773,57023),
(11029,5,81795,56237),
(11029,6,81239,56236),
(11029,7,81282,56892),
(11029,8,81187,56904),
(11029,9,81105,57179),
(11029,10,79195,57167),
(11029,11,78986,57076),
(11029,12,78844,55218),
(11029,13,78843,54882),
(11029,14,79148,54560),
(11029,15,79660,54556),
(11029,16,79662,53994),
(11029,17,79002,53990),
(11029,18,78963,53359),
(11029,19,78959,53070),
(11029,20,79027,52125),
(11029,21,79628,52070),
(11029,22,80547,52068),
(11029,23,80835,52116),
(11029,24,80733,53068),
(11029,25,81306,53070),
(11029,26,81369,52310),
(11029,27,82605,52244),
(11029,28,84010,52250),
(11030,0,115318,74260),
(11030,1,115019,74495),
(11030,2,113919,75365),
(11030,3,114386,77505),
(11030,4,114653,78197),
(11030,5,115063,80068),
(11030,6,117015,81804),
(11030,7,120527,81006),
(11030,8,121485,79049),
(11030,9,121631,74718),
(11030,10,119999,74209),
(11030,11,118499,74097),
(11030,12,117946,74068),
(11030,13,117404,73671),
(11030,14,115622,74026),
(11030,15,115328,74252),
(11031,0,143209,25727),
(11031,1,143209,26975),
(11031,2,143463,27286),
(11031,3,143473,30074),
(11031,4,144386,30947),
(11031,5,146209,30946),
(11031,6,146649,31179),
(11031,7,146830,31508),
(11031,8,148081,31511),
(11031,9,148275,31176),
(11031,10,148696,30937),
(11031,11,150367,30942),
(11031,12,151289,30008),
(11031,13,151233,25914),
(11031,14,151399,25719),
(11031,15,151403,24470),
(11031,16,151205,24271),
(11031,17,151198,21168),
(11031,18,150233,20225),
(11031,19,148287,20227),
(11031,20,148086,19992),
(11031,21,146836,19992),
(11031,22,146642,20199),
(11031,23,144429,20204),
(11031,24,143459,21124),
(11031,25,143446,25542),
(11031,26,143198,25731),
(11032,0,144345,-53353),
(11032,1,145283,-52411),
(11032,2,146840,-51665),
(11032,3,148575,-51659),
(11032,4,150128,-52405),
(11032,5,151075,-53362),
(11032,6,152091,-54735),
(11032,7,151974,-55898),
(11032,8,151852,-56567),
(11032,9,151737,-57217),
(11032,10,151608,-57387),
(11032,11,151239,-57131),
(11032,12,150447,-58201),
(11032,13,150832,-58488),
(11032,14,150551,-58851),
(11032,15,148717,-59764),
(11032,16,148590,-59759),
(11032,17,148590,-59291),
(11032,18,146839,-59291),
(11032,19,146842,-59768),
(11032,20,146700,-59766),
(11032,21,144860,-58848),
(11032,22,144589,-58489),
(11032,23,144967,-58193),
(11032,24,144179,-57141),
(11032,25,143807,-57392),
(11032,26,143685,-57210),
(11032,27,143335,-55225),
(11032,28,143679,-53917),
(11032,29,143887,-53081),
(11033,0,47150,-44815),
(11033,1,32531,-52045),
(11034,0,111391,216329),
(11034,1,106872,216579),
(11034,2,106693,217371),
(11034,3,106612,217923),
(11034,4,106612,218409),
(11034,5,106435,221617),
(11034,6,106435,222250),
(11034,7,106563,222851),
(11034,8,108183,223150),
(11034,9,108916,223150),
(11034,10,110264,222975),
(11034,11,110253,223651),
(11034,12,110185,223669),
(11034,13,110095,223756),
(11034,14,110056,223864),
(11034,15,109790,223883),
(11034,16,109703,223966),
(11034,17,109705,224197),
(11034,18,109882,224363),
(11034,19,109884,225522),
(11034,20,110764,225507),
(11034,21,110767,225985),
(11034,22,112002,225992),
(11034,23,112005,225510),
(11034,24,112891,225520),
(11034,25,112886,224389),
(11034,26,113068,224198),
(11034,27,113072,223967),
(11034,28,112983,223887),
(11034,29,112704,223864),
(11034,30,112676,223758),
(11034,31,112592,223669),
(11034,32,112520,223654),
(11034,33,112506,222975),
(11034,34,113745,223440),
(11034,35,115249,223440),
(11034,36,115249,223653),
(11034,37,115356,223653),
(11034,38,115356,223322),
(11034,39,115392,222838),
(11034,40,115393,221433),
(11034,41,115980,220372),
(11034,42,116055,219529),
(11034,43,116055,219029),
(11034,44,116220,218649),
(11034,45,116219,218388),
(11034,46,116041,218380),
(11034,47,116043,217586),
(11034,48,115310,217610),
(11034,49,114755,217086),
(11034,50,114434,217051),
(11034,51,114417,216838),
(11034,52,114182,216838),
(11034,53,114161,216957),
(11034,54,113280,216962),
(11034,55,111885,216801),
(11034,56,111808,216566),
(11034,57,111631,216386),
(11034,58,111393,216322),
(11035,0,91098,-144458),
(11035,1,91477,-143218),
(11035,2,91170,-141327),
(11035,3,90797,-140803),
(11035,4,90404,-141058),
(11035,5,90077,-140615),
(11035,6,90424,-140324),
(11035,7,89997,-139845),
(11035,8,88300,-138977),
(11035,9,87659,-138913),
(11035,10,87656,-139375),
(11035,11,87044,-139383),
(11035,12,87039,-138938),
(11035,13,86427,-138981),
(11035,14,84717,-139826),
(11035,15,84295,-140324),
(11035,16,84648,-140602),
(11035,17,84286,-141095),
(11035,18,83959,-140825),
(11035,19,83562,-141356),
(11035,20,83229,-143217),
(11035,21,83821,-145580),
(11035,22,84373,-148184),
(11035,23,89454,-148688),
(11035,24,91280,-145403),
(11035,25,91084,-144472),
(11036,0,16529,170516),
(11036,1,16645,170141),
(11036,2,16747,169833),
(11036,3,16770,169677),
(11036,4,16822,169464),
(11036,5,16858,169431),
(11036,6,17457,169398),
(11036,7,17939,169475),
(11036,8,18109,169528),
(11036,9,18435,169666),
(11036,10,18628,169781),
(11036,11,18641,169828),
(11036,12,18531,170204),
(11036,13,18473,170530),
(11036,14,18452,170686),
(11036,15,18394,170900),
(11036,16,18361,170937),
(11036,17,17771,170962),
(11036,18,17220,170888),
(11036,19,16897,170757),
(11036,20,16543,170561),
(11038,0,-121743,44424),
(11038,1,-121032,43295),
(11038,2,-120886,42480),
(11038,3,-120203,41012),
(11038,4,-118418,40332),
(11038,5,-112554,40643),
(11038,6,-111161,40894),
(11038,7,-110912,41569),
(11038,8,-110910,41908),
(11038,9,-111011,42108),
(11038,10,-111186,42197),
(11038,11,-111601,42194),
(11038,12,-111736,42102),
(11038,13,-111827,41951),
(11038,14,-113240,41951),
(11038,15,-113330,42107),
(11038,16,-113477,42193),
(11038,17,-113905,42190),
(11038,18,-114072,42096),
(11038,19,-114146,41940),
(11038,20,-114602,41944),
(11038,21,-114536,43719),
(11038,22,-114513,46154),
(11038,23,-114275,46912),
(11038,24,-114275,47297),
(11038,25,-114665,48163),
(11038,26,-115473,48310),
(11038,27,-118971,48310),
(11038,28,-119259,47970),
(11038,29,-120430,47970),
(11038,30,-120654,47199),
(11038,31,-120917,46429),
(11039,0,-88871,-77664),
(11039,1,-43060,-43491),
(11040,0,-187342,238059),
(11040,1,-181849,247548),
(11060,0,109448,10233),
(11060,1,118547,21446),
(11070,0,-18670,-20294),
(11070,1,-22913,-21917),
(11071,0,-73769,-251411),
(11071,1,-77579,-253831),
(11072,0,-77712,-251411),
(11072,1,-81511,-253831),
(11073,0,-81889,-251411),
(11073,1,-85696,-253831),
(11074,0,-86097,-251411),
(11074,1,-89927,-253831),
(11075,0,-73769,-248546),
(11075,1,-77579,-250987),
(11076,0,-77712,-248546),
(11076,1,-81511,-250987),
(11077,0,-81889,-248546),
(11077,1,-85696,-250987),
(11078,0,-86097,-248546),
(11078,1,-89927,-250987),
(11079,0,-73769,-245741),
(11079,1,-77579,-248185),
(11080,0,-77712,-245741),
(11080,1,-81511,-248185),
(11081,0,-81889,-245741),
(11081,1,-85696,-248185),
(11082,0,-86097,-245741),
(11082,1,-89927,-248185),
(11083,0,-73769,-243055),
(11083,1,-77579,-245505),
(11084,0,-77712,-243055),
(11084,1,-81511,-245505),
(11085,0,-81889,-243055),
(11085,1,-85696,-245505),
(11086,0,-86097,-243055),
(11086,1,-89927,-245505),
(11087,0,-73769,-240271),
(11087,1,-77579,-242742),
(11088,0,-77712,-240271),
(11088,1,-81511,-242742),
(11089,0,-81889,-240271),
(11089,1,-85696,-242742),
(11090,0,-86097,-240271),
(11090,1,-89927,-242742),
(11091,0,-86097,-237576),
(11091,1,-89927,-240094),
(11092,0,-81992,-237633),
(11092,1,-85468,-240144),
(11100,0,43151,108377),
(11100,1,43648,109399),
(11101,0,-16400,123275),
(11101,1,-15551,123850),
(11102,0,-15100,125350),
(11102,1,-14800,125800),
(11103,0,-14050,125050),
(11103,1,-13700,125700),
(11104,0,-12950,123900),
(11104,1,-12300,124250),
(11105,0,-84700,151550),
(11105,1,-84250,152350),
(11106,0,-84200,153050),
(11106,1,-83550,153600),
(11107,0,-84100,155300),
(11107,1,-83500,155700),
(11108,0,-80100,149400),
(11108,1,-79500,149850),
(11109,0,-79700,151350),
(11109,1,-79300,152250),
(11110,0,17400,144800),
(11110,1,18000,145350),
(11111,0,18850,143600),
(11111,1,18600,143100),
(11112,0,19950,146000),
(11112,1,20400,146300),
(11113,0,0,0),
(11113,1,0,0),
(11114,0,80738,-15914),
(11114,1,79627,-15054),
(11115,0,148844,22709),
(11115,1,149424,23569),
(11116,0,150343,23193),
(11116,1,150943,24113),
(11117,0,145362,24890),
(11117,1,145972,25820),
(11118,0,150460,26108),
(11118,1,151036,26972),
(11119,0,143701,26661),
(11119,1,144281,27521),
(11120,0,143704,27734),
(11120,1,144324,28670),
(11121,0,78059,147906),
(11121,1,79122,148296),
(11122,0,81859,144802),
(11122,1,82254,145870),
(11123,0,83195,144779),
(11123,1,83591,145847),
(11124,0,80773,151053),
(11124,1,81169,152121),
(11125,0,81903,151377),
(11125,1,82299,152445),
(11126,0,145643,-55883),
(11126,1,146439,-55714),
(11126,2,146390,-55288),
(11126,3,145606,-55367),
(11127,0,146486,-57148),
(11127,1,146984,-57388),
(11127,2,147299,-56613),
(11127,3,146919,-56438),
(11128,0,148469,-57355),
(11128,1,148958,-57115),
(11128,2,148502,-56409),
(11128,3,148120,-56627),
(11129,0,148970,-55727),
(11129,1,149773,-55874),
(11129,2,149852,-55302),
(11129,3,149022,-55291),
(11130,0,37435,-51012),
(11130,1,38030,-51012),
(11130,2,38030,-50568),
(11130,3,37766,-50568),
(11130,4,37766,-50425),
(11130,5,37683,-50425),
(11130,6,37683,-50568),
(11130,7,37435,-50568),
(11131,0,38562,-50786),
(11131,1,39100,-50532),
(11131,2,38943,-50151),
(11131,3,38676,-50237),
(11131,4,38603,-50111),
(11131,5,38530,-50149),
(11131,6,38586,-50282),
(11131,7,38397,-50365),
(11132,0,39714,-50109),
(11132,1,39976,-49630),
(11132,2,39401,-49276),
(11132,3,39300,-49537),
(11132,4,39166,-49467),
(11132,5,39123,-49539),
(11132,6,39244,-49615),
(11132,7,39125,-49837),
(11133,0,39339,-48297),
(11133,1,39396,-48297),
(11133,2,39396,-48634),
(11133,3,39839,-48634),
(11133,4,39839,-47841),
(11133,5,39396,-47841),
(11133,6,39396,-48199),
(11133,7,39339,-48199),
(11134,0,39174,-47020),
(11134,1,39308,-46954),
(11134,2,39422,-47176),
(11134,3,39995,-46846),
(11134,4,39716,-46347),
(11134,5,39109,-46647),
(11134,6,39256,-46867),
(11134,7,39133,-46949),
(11135,0,38370,-46087),
(11135,1,38606,-46205),
(11135,2,38549,-46331),
(11135,3,38622,-46369),
(11135,4,38692,-46249),
(11135,5,38931,-46373),
(11135,6,39134,-45839),
(11135,7,38693,-45538),
(11136,0,37692,-46044),
(11136,1,37796,-46044),
(11136,2,37796,-45905),
(11136,3,38032,-45905),
(11136,4,38032,-45460),
(11136,5,37436,-45460),
(11136,6,37436,-45905),
(11136,7,37692,-45905),
(11137,0,85207,-143382),
(11137,1,86068,-143417),
(11137,2,86118,-142951),
(11137,3,85295,-142837),
(11138,0,86556,-142317),
(11138,1,86997,-142090),
(11138,2,86595,-141349),
(11138,3,86097,-141615),
(11139,0,87746,-142099),
(11139,1,88173,-142322),
(11139,2,88570,-141586),
(11139,3,88110,-141285),
(11140,0,88664,-143440),
(11140,1,89485,-143344),
(11140,2,89438,-142800),
(11140,3,88603,-142968),
(11141,0,138896,-124384),
(11141,1,140048,-125120),
(11141,2,140352,-124752),
(11141,3,141344,-125440),
(11141,4,141536,-125504),
(11141,5,141680,-125472),
(11141,6,141888,-125280),
(11141,7,141936,-125168),
(11141,8,141920,-124992),
(11141,9,141920,-124160),
(11141,10,141840,-123952),
(11141,11,141664,-123776),
(11141,12,141504,-123664),
(11141,13,141264,-123600),
(11141,14,140944,-123632),
(11141,15,140672,-123760),
(11141,16,140544,-123744),
(11141,17,139728,-123200),
(11142,0,55456,-91840),
(11142,1,55568,-91936),
(11142,2,55520,-92032),
(11142,3,55568,-92064),
(11142,4,55584,-92752),
(11142,5,55232,-93024),
(11142,6,55344,-93296),
(11142,7,55776,-93296),
(11142,8,55936,-93728),
(11142,9,55936,-93872),
(11142,10,55824,-94000),
(11142,11,55920,-94096),
(11142,12,55824,-94208),
(11142,13,55336,-94720),
(11142,14,56448,-94640),
(11142,15,56544,-94720),
(11142,16,56704,-94576),
(11142,17,57072,-94576),
(11142,18,57200,-94512),
(11142,19,57856,-94592),
(11142,20,58128,-94816),
(11142,21,58384,-94928),
(11142,22,58480,-95040),
(11142,23,58576,-94992),
(11142,24,58688,-95120),
(11142,25,59184,-94896),
(11142,26,59552,-94896),
(11142,27,59968,-94784),
(11142,28,60560,-95024),
(11142,29,60672,-95024),
(11142,30,60736,-94960),
(11142,31,60736,-94784),
(11142,32,60912,-94496),
(11142,33,60960,-94320),
(11142,34,61312,-93696),
(11142,36,60976,-93504),
(11142,37,61120,-93280),
(11142,38,60736,-92832),
(11142,39,60464,-92416),
(11142,40,60352,-92000),
(11142,41,60208,-92000),
(11142,42,60176,-91872),
(11142,43,59968,-91888),
(11142,44,59728,-91520),
(11142,45,59648,-91264),
(11142,46,58816,-90496),
(11142,47,58816,-90400),
(11142,48,58688,-90368),
(11142,49,58672,-90240),
(11142,50,57968,-90112),
(11142,51,57936,-90240),
(11142,52,57808,-90224),
(11142,53,57744,-90416),
(11142,54,56640,-91008),
(11142,55,56320,-91136),
(11142,56,56080,-91184),
(11142,57,55968,-91136),
(11142,58,55904,-91248),
(11142,59,55776,-91200),
(11143,0,57264,-30176),
(11143,1,57600,-29472),
(11143,2,58224,-29472),
(11143,3,58672,-30176),
(11143,4,59440,-29312),
(11143,5,59440,-25648),
(11143,6,56448,-25648),
(11143,7,56448,-29312);

-- Castle Zones
INSERT INTO `zone_vertices` VALUES
(11200,0,-22615,104510),
(11200,1,-13290,104564),
(11200,2,-13313,116950),
(11200,3,-22638,116896),
(11201,0,26575,165240),
(11201,1,17250,165186),
(11201,2,17273,152800),
(11201,3,26598,152854),
(11202,0,121412,140594),
(11202,1,121358,149919),
(11202,2,108972,149896),
(11202,3,109026,140571),
(11203,0,87488,32689),
(11203,1,87434,42014),
(11203,2,75048,41991),
(11203,3,75102,32666),
(11204,0,142431,362),
(11204,1,152319,344),
(11204,2,152282,15197),
(11204,3,142393,15215),
(11205,0,120526,254019),
(11205,1,111201,253965),
(11205,2,111224,241579),
(11205,3,120549,241633),
(11206,0,141457,-51510),
(11206,1,151949,-51510),
(11206,2,151949,-39107),
(11206,3,145899,-39107),
(11206,4,141457,-44407),
(11207,0,7000,-55500),
(11207,1,27250,-41716),
(11208,0,73000,-156600),
(11208,1,82560,-144750),
-- Castle Teleport Zones
(11209,0,-16287,109204),
(11209,1,-17178,109518),
(11210,0,20249,160228),
(11210,1,21132,160547),
(11211,0,116400,146030),
(11211,1,116718,146924),
(11212,0,82478,38125),
(11212,1,82794,39020),
(11213,0,146944,4097),
(11213,1,147967,5112),
(11214,0,114195,249007),
(11214,1,115081,249326),
(11215,0,147293,-46267),
(11215,1,147644,-47188),
(11216,0,9337,-49734),
(11216,1,11423,-49297),
(11216,2,11423,-49006),
(11216,3,9337,-48587),
(11217,0,77381,-150335),
(11217,1,77735,-151256);

-- Fishing Zones
INSERT INTO `zone_vertices` VALUES
-- fishing_place_1 (Not Verified)
(11400,0,83327,143509),
(11400,1,83031,143121),
(11400,2,82475,142974),
(11400,3,82174,142486),
(11400,4,82333,141833),
(11400,5,82955,141507),
(11400,6,83288,141763),
(11400,7,83683,141814),
(11400,8,83680,143500),
-- fishing_place_2
(11401,0,141249,-109636),
(11401,1,141473,-109798),
(11401,2,141739,-109821),
(11401,3,141924,-109669),
(11401,4,142038,-109397),
(11401,5,141852,-109130),
(11401,6,141604,-109051),
(11401,7,141321,-109091),
(11401,8,141213,-109266),
-- fishing_place_3
(11402,0,140174,-105832),
(11402,1,140490,-105875),
(11402,2,140962,-105738),
(11402,3,141039,-105378),
(11402,4,140872,-105119),
(11402,5,140081,-105295),
-- fishing_place_4
(11403,0,144927,-105193),
(11403,1,145226,-105412),
(11403,2,145576,-105344),
(11403,3,145819,-104976),
(11403,4,145575,-104555),
(11403,5,145217,-104490),
(11403,6,144935,-104684),
(11403,7,144832,-104959),
-- fishing_place_5
(11404,0,152081,-108262),
(11404,1,152455,-108588),
(11404,2,152835,-108448),
(11404,3,152992,-108120),
(11404,4,152817,-107670),
(11404,5,152310,-107632),
(11404,6,152069,-107905),
-- fishing_place_6
(11405,0,155279,-105735),
(11405,1,155448,-105880),
(11405,2,155992,-105963),
(11405,3,156201,-105790),
(11405,4,156133,-105320),
(11405,5,155896,-105229),
(11405,6,155459,-105254),
(11405,7,155283,-105478),
-- fishing_place_7
(11406,0,156838,-109948),
(11406,1,157133,-110046),
(11406,2,157436,-109918),
(11406,3,157491,-109405),
(11406,4,157197,-109197),
(11406,5,156843,-109261),
(11406,6,156683,-109569),
-- fishing_place_8
(11407,0,152063,-116732),
(11407,1,152505,-116982),
(11407,2,152904,-116927),
(11407,3,153020,-116469),
(11407,4,152881,-116221),
(11407,5,152555,-116100),
(11407,6,152285,-116160),
(11407,7,152099,-116415),
-- fishing_place_9
(11408,0,152683,-112829),
(11408,1,152796,-113129),
(11408,2,153125,-113339),
(11408,3,153557,-113190),
(11408,4,153649,-112721),
(11408,5,153344,-112385),
(11408,6,152937,-112409),
-- fishing_place_10
(11409,0,157444,-115790),
(11409,1,157774,-115907),
(11409,2,158174,-115759),
(11409,3,158017,-114971),
(11409,4,157625,-114984),
(11409,5,157439,-115101),
-- fishing_place_11
(11410,0,147182,-113255),
(11410,1,147194,-113430),
(11410,2,147312,-113584),
(11410,3,147467,-113630),
(11410,4,147748,-113523),
(11410,5,147816,-113273),
(11410,6,147723,-113074),
(11410,7,147512,-112956),
(11410,8,147258,-113048),
-- fishing_place_12
(11411,0,35360,70052),
(11411,1,54640,70780),
(11411,2,58104,89528),
(11411,3,38900,91644),
-- fishing_place_13
(11412,0,-99139,207208),
(11412,1,-65905,254858),
(11412,2,-65905,261841),
(11412,3,-124577,261607),
(11412,4,-128220,215665),
-- fishing_place_14
(11413,0,134452,66180),
(11413,1,170228,67184),
(11413,2,172464,97052),
(11413,3,136188,94940),
-- fishing_place_15
(11414,0,135800,35476),
(11414,1,162960,35364),
(11414,2,161056,64920),
(11414,3,136496,65092),
-- fishing_place_16
(11415,0,97311,-229576),
(11415,1,201955,-229291),
(11415,2,201926,-163450),
(11415,3,97636,-164202),
-- fishing_place_17
(11416,0,89909,158343),
(11416,1,130731,153447),
(11416,2,130741,261840),
(11416,3,65549,262183),
(11416,4,65612,189166),
-- fishing_place_18
(11417,0,81328,136658),
(11417,1,139003,123356),
(11417,2,138584,145204),
(11417,3,121150,155944),
(11417,4,80807,160436),
-- fishing_place_19
(11418,0,67326,160359),
(11418,1,86813,160109),
(11418,2,64159,189723),
(11418,3,42375,183029),
-- fishing_place_20
(11419,0,30606,184275),
(11419,1,40957,182824),
(11419,2,62226,189792),
(11419,3,62509,228946),
(11419,4,30706,228846),
-- fishing_place_21
(11420,0,65472,71452),
(11420,1,86420,82248),
(11420,2,97656,93300),
(11420,3,97692,98032),
(11420,4,64528,97660),
-- fishing_place_22
(11421,0,66204,3448),
(11421,1,121052,30384),
(11421,2,87064,56664),
(11421,3,69484,31724),
-- fishing_place_23
(11422,0,4721,99932),
(11422,1,60654,99812),
(11422,2,60606,158582),
(11422,3,40546,154557),
(11422,4,3147,123027),
-- fishing_place_24
(11423,0,36902,-98025),
(11423,1,9543,-42544),
(11423,2,54988,-7732),
(11423,3,96957,-65614),
-- fishing_place_25
(11424,0,436,128216),
(11424,1,10168,128584),
(11424,2,42184,182056),
(11424,3,31996,197312),
(11424,4,680,197804),
-- fishing_place_26
(11425,0,35960,34780),
(11425,1,61228,52232),
(11425,2,61704,77128),
(11425,3,43360,66444),
(11425,4,32924,37972),
-- fishing_place_27
(11426,0,11764,36204),
(11426,1,42092,63036),
(11426,2,44408,69824),
(11426,3,444,75320),
(11426,4,2780,51824),
-- fishing_place_28
(11427,0,148,77464),
(11427,1,4116,80668),
(11427,2,4816,95352),
(11427,3,460,94180),
-- fishing_place_29
(11428,0,-37560,16423),
(11428,1,-8388,126),
(11428,2,50773,98),
(11428,3,35243,16780),
(11428,4,-76016,81087),
(11428,5,-75777,65779),
-- fishing_place_30
(11429,0,-27548,90040),
(11429,1,3188,95180),
(11429,2,1816,117348),
(11429,3,-1732,130032),
(11429,4,-25952,130540),
-- fishing_place_31
(11430,0,-13628,57148),
(11430,1,-428,57856),
(11430,2,3668,90204),
(11430,3,-21376,89884),
(11430,4,-26808,87940),
-- fishing_place_32
(11431,0,-64990,-109438),
(11431,1,32369,-96091),
(11431,2,31964,-83063),
(11431,3,4840,-60901),
(11431,4,-30730,-68637),
-- fishing_place_33
(11432,0,-65739,186145),
(11432,1,-188,193188),
(11432,2,-470,213105),
(11432,3,-22923,225218),
(11432,4,-58597,224836),
-- fishing_place_34
(11433,0,-62980,111764),
(11433,1,-50756,126392),
(11433,2,-63940,140572),
(11433,3,-71220,133792),
(11433,4,-69448,120784),
-- fishing_place_35
(11434,0,-111370,100078),
(11434,1,-77020,67100),
(11434,2,-65711,190964),
(11434,3,-99937,150239),
-- fishing_place_36 (Not Verified)
(11435,0,-22345,249596),
(11435,1,-22362,249348),
(11435,2,-22091,248888),
(11435,3,-20643,248660),
(11435,4,-20140,249091),
(11435,5,-20118,249225),
(11435,6,-20030,249344),
(11435,7,-20026,249545),
(11435,8,-20362,249912),
(11435,9,-20825,250116),
(11435,10,-20887,249977),
(11435,11,-21108,250055),
(11435,12,-21202,250152),
(11435,13,-21423,250197),
(11435,14,-21773,250154),
(11435,15,-21899,250065);

-- Fortress Zones
INSERT INTO `zone_vertices` VALUES
-- Shanty Fortress
(11501,0,-56256,153728),
(11501,1,-49536,159424),
-- Southern Fortress
(11502,0,-26304,216576),
(11502,1,-19584,222912),
-- Hive Fortress
(11503,0,12544,185856),
(11503,1,19456,190272),
-- Valley Fortress
(11504,0,122432,120192),
(11504,1,129600,126656),
-- Ivory Fortress
(11505,0,70080,1984),
(11505,1,74944,6656),
-- Narsell Fortress
(11506,0,151936,52736),
(11506,1,157760,58304),
-- Bayou Fortress
(11507,0,186368,36288),
(11507,1,192640,42240),
-- White Sands Fortress
(11508,0,114432,201664),
(11508,1,122176,208704),
-- Borderland Fortress
(11509,0,156548,-73943),
(11509,1,162368,-67776),
-- Swamp Fortress
(11510,0,65007,-64441),
(11510,1,72832,-58688),
-- Archaic Fortress
(11511,0,106176,-143616),
(11511,1,112704,-138752),
-- Floran Fortress
(11512,0,1472,145216),
(11512,1,9728,155136),
-- Cloud Mountain Fortress
(11513,0,-57408,88704),
(11513,1,-49408,93824),
-- Tanor Fortress
(11514,0,56256,136768),
(11514,1,64256,142016),
-- Dragonspine Fortress
(11515,0,8000,92928),
(11515,1,14976,97408),
-- Antharas Fortress
(11516,0,78968,86064),
(11516,1,83594,88561),
(11516,2,79890,95265),
(11516,3,73880,93384),
-- Western Fortress
(11517,0,107264,-17664),
(11517,1,115392,-12544),
-- Hunters Fortress
(11518,0,121472,92992),
(11518,1,129088,97792),
-- Aaru Fortress
(11519,0,69120,182400),
(11519,1,76672,190784),
-- Demon Fortress
(11520,0,98626,-58080),
(11520,1,102912,-52288),
-- Monastic Fortress
(11521,0,68480,-97536),
(11521,1,75520,-92224);

-- Boss Zones
INSERT INTO `zone_vertices` VALUES
(12001,0,181241,-86443),
(12001,1,192134,-84575),
(12002,0,179551,-89844),
(12002,1,190342,-88042),
(12003,0,172354,-86630),
(12003,1,174073,-75565),
(12004,0,174697,-82707),
(12004,1,176500,-71885),

(12005,0,172176,-74106),	-- +[JOJO:l2jfree boss.xml rev.4469] "Last Imperial Tomb" (Cuboid)
(12005,1,175984,-90033),
(12805,0,172176,-86081),	-- +[JOJO] "Lair of Scarlet van Halisha" (Cuboid)
(12805,1,175984,-90033),

(12006,0,173439,110176),
(12006,1,187346,119469),
(12007,0,112987,14312),
(12007,1,112507,14623),
(12007,2,112129,15551),
(12007,3,111890,16230),
(12007,4,112067,16965),
(12007,5,112496,17482),
(12007,6,112863,18120),
(12007,7,113453,18561),
(12007,8,114135,18590),
(12007,9,114815,18811),
(12007,10,115549,18648),
(12007,11,116074,18205),
(12007,12,116776,17506),
(12007,13,117255,17013),
(12007,14,117371,16298),
(12007,15,117405,15925),
(12007,16,117236,15199),
(12007,17,117158,14895),
(12007,18,116784,14260),
(12007,19,116096,13902),
(12007,20,115159,13507),
(12007,21,114135,13518),
(12007,22,113203,13898),
(12008,0,196866,-130845),
(12008,1,229289,-130860),
(12008,2,229176,-98508),
(12008,3,196880,-98498),
(12009,0,183986,-13716),
(12009,1,186097,-11532),
(12010,0,184008,-10681),
(12010,1,186107,-8589),
(12011,0,50797,213515),
(12011,1,57617,213510),
(12011,2,57669,221683),
(12011,3,50773,221632),
(12012,0,-21490,178613),
(12012,1,-22258,178961),
(12012,2,-22890,182205),
(12012,3,-22770,183129),
(12012,4,-21594,183945),
(12012,5,-20570,183381),
(12012,6,-20310,182673),
(12012,7,-20762,179129),
(12013,0,43976,24664),
(12013,1,43284,18952),
(12013,2,42476,18164),
(12013,3,42480,16448),
(12013,4,43084,15944),
(12013,5,45140,15816),
(12013,6,48800,15112),
(12013,7,56556,12040),
(12013,8,59068,14288),
(12013,9,61064,18492),
(12013,10,60380,23672),
(12013,11,58724,27412),
(12013,12,55696,28496),
(12013,13,43976,24664),
(12014,0,-18176,-54972),
(12014,1,-14614,-51620),
(12015,0,101744,-130016),
(12015,1,111376,-130096),
(12015,2,114416,-126128),
(12015,3,115246,-125857),
(12015,4,115209,-125669),
(12015,5,113920,-125669),
(12015,6,102400,-121920),
(12015,7,99456,-126208),

(12807,0,26095,-8084),		-- +[JOJO:l2jfree boss.xml rev.4469] "Lair of Sailren" (Cuboid)
(12807,1,28987,-5295);

-- Landing Zones
INSERT INTO `zone_vertices` VALUES
(14000,0,-186945,244064),
(14000,1,-186503,244183),
(14000,2,-186526,244273),
(14000,3,-186998,244149),
(14001,0,-186707,243348),
(14001,1,-186098,243499),
(14001,2,-186209,243886),
(14001,3,-186836,243713),
(14002,0,-186388,241751),
(14002,1,-185747,241972),
(14002,2,-186026,243171),
(14002,3,-186755,242965),
(14003,0,-186067,241090),
(14003,1,-185469,241336),
(14003,2,-185541,241652),
(14003,3,-186173,241496),
(14004,0,-186158,240243),
(14004,1,-185440,240450),
(14004,2,-185461,240566),
(14004,3,-186182,240351),
(14005,0,-185611,240192),
(14005,1,-183498,240759),
(14005,2,-183834,241948),
(14005,3,-185906,241253),
(14006,0,-186102,241831),
(14006,1,-185039,242209),
(14006,2,-185356,243326),
(14006,3,-186447,243020),
(14007,0,-184942,242302),
(14007,1,-183775,242671),
(14007,2,-184015,243618),
(14007,3,-185256,243318),
(14008,0,-186637,243638),
(14008,1,-184503,244189),
(14008,2,-184878,245409),
(14008,3,-187009,244723),
(14009,0,-203218,241627),
(14009,1,-203218,242642),
(14009,2,-203355,242648),
(14009,3,-203376,242219),
(14009,4,-204119,242289),
(14009,5,-204108,242617),
(14009,6,-204305,242631),
(14009,7,-204315,242913),
(14009,8,-204613,242930),
(14009,9,-204624,241399),
(14009,10,-204312,241374),
(14009,11,-204132,241677),
(14009,12,-204114,242019),
(14009,13,-203349,241982),
(14009,14,-203345,241646),
(14010,0,-212856,209893),
(14010,1,-212808,209894),
(14010,2,-212764,209852),
(14010,3,-212765,209798),
(14010,4,-212812,209756),
(14010,5,-212858,209757),
(14010,6,-212897,209802),
(14010,7,-212896,209850);

-- Water Zones
INSERT INTO `zone_vertices` VALUES
-- 16_21_water1
(15000,0,-131071,98303),
(15000,1,-98303,131071),

-- 16_22_water1
(15001,0,-131071,131072),
(15001,1,-98303,163840),

-- 16_23_water1
(15002,0,-131071,163840),
(15002,1,-98303,196608),

-- 16_24_water1
(15003,0,-131072,196607),
(15003,1,-98304,229375),

-- 16_25_water1
(15004,0,-131072,237205),
(15004,1,-98304,262144),

-- 17_20_water1
(15005,0,-98303,65536),
(15005,1,-85503,98304),
-- 17_20_water2
(15006,0,-85503,65536),
(15006,1,-65535,80384),
-- 17_20_water3
(15007,0,-85056,86208),
(15007,1,-84416,86848),
-- 17_20_water4
(15008,0,-84416,86208),
(15008,1,-82944,86848),

-- 17_21_water1
(15009,0,-98304,121072),
(15009,1,-88304,131072),
-- 17_21_water2
(15010,0,-98304,98304),
(15010,1,-96804,99804),
-- 17_21_water3
(15011,0,-68536,128072),
(15011,1,-65536,131072),
-- 17_21_water4
(15012,0,-84032,111040),
(15012,1,-83392,111680),
-- 17_21_water5
(15013,0,-83392,111040),
(15013,1,-81920,111680),

-- 17_22_water1
(15014,0,-98304,131072),
(15014,1,-78304,163840),
-- 17_22_water2
(15015,0,-69836,131072),
(15015,1,-65536,140072),

-- 17_23_water1
(15016,0,-98304,163840),
(15016,1,-65536,196608),

-- 17_24_water1
(15017,0,-98303,196608),
(15017,1,-65535,229376),

-- 17_25_water1
(15018,0,-98303,229375),
(15018,1,-65535,262143),

-- 18_14_water1
(15019,0,-65536,-103304),
(15019,1,-32768,-98304),

-- 18_19_water1
(15020,0,-65536,32767),
(15020,1,-52036,65535),
-- 18_19_water2
(15021,0,-52036,32768),
(15021,1,-32768,40768),

-- 18_20_water1
(15022,0,-65536,65536),
(15022,1,-55536,75536),
-- 18_20_water2
(15023,0,-55360,78784),
(15023,1,-53888,79424),
-- 18_20_water3
(15024,0,-56000,78784),
(15024,1,-55360,79424),

-- 18_21_water1
(15025,0,-65536,122368),
(15025,1,-52480,131072),
-- 18_21_water2
(15026,0,-65536,113088),
(15026,1,-57664,121856),

-- 18_22_water1
(15027,0,-65536,131072),
(15027,1,-62464,141056),
-- 18_22_water2
(15028,0,-61764,131072),
(15028,1,-55748,132608),

-- 18_23_water1
(15029,0,-65536,191350),
(15029,1,-53536,196608),
-- 18_23_water2
(15030,0,-65535,179446),
(15030,1,-62962,191446),
-- 18_23_water3
(15031,0,-54681,180233),
(15031,1,-53049,183017),
-- 18_23_water4
(15032,0,-53616,183018),
(15032,1,-52368,184394),

-- 18_24_water1
(15033,0,-41888,206688),
(15033,1,-41248,208160),
-- 18_24_water2
(15034,0,-65536,196608),
(15034,1,-53536,229376),
-- 18_24_water3
(15035,0,-53536,220976),
(15035,1,-32768,229376),
-- 18_24_water4
(15036,0,-41024,212576),
(15036,1,-32768,220976),
-- 18_24_water5
(15037,0,-53536,212576),
(15037,1,-45280,220976),
-- 18_24_water6
(15038,0,-53536,202208),
(15038,1,-47584,209584),
-- 18_24_water7
(15039,0,-45280,212576),
(15039,1,-41024,220976),
-- 18_24_water8
(15040,0,-41888,206048),
(15040,1,-41248,206688),

-- 18_25_water1
(15041,0,-65536,229375),
(15041,1,-32768,262143),

-- 19_14_water1
(15042,0,-32767,-101304),
(15042,1,-29767,-98304),

-- 19_15_water1
(15043,0,-32768,-98304),
(15043,1,-0,-65536),

-- 19_18_water1
(15044,0,-32768,0),
(15044,1,-23424,32768),
-- 18_24_water2
(15045,0,-23168,13184),
(15045,1,-22528,13824),
-- 18_24_water3
(15046,0,-22528,13184),
(15046,1,-21056,13824),
-- 18_24_water4
(15047,0,-23424,0),
(15047,1,0,12928),

-- 19_19_water1
(15048,0,-12972,57536),
(15048,1,-5972,65536),
-- 19_19_water2
(15049,0,-5840,60645),
(15049,1,-3840,62645),

-- 19_20_water1
(15050,0,-24488,65536),
(15050,1,0,98304),
-- 19_20_water2
(15051,0,-25472,77056),
(15051,1,-24832,77696),
-- 19_20_water3
(15052,0,-24832,77056),
(15052,1,-23360,77696),

-- 19_21_water1
(15053,0,-25816,98304),
(15053,1,0,131072),

-- 19_24_water1
(15054,0,-32768,209376),
(15054,1,-10000,229376),
-- 19_24_water2
(15055,0,-10000,196608),
(15055,1,0,229376),

-- 19_25_water1
(15056,0,-32768,229376),
(15056,1,0,262144),

-- 20_15_water1
(15057,0,0,-73536),
(15057,1,8000,-65536),

-- 20_18_water1
(15058,0,0,0),
(15058,1,32768,5500),

-- 20_19_water1
(15059,0,0,32768),
(15059,1,32768,65536),

-- 20_20_water1
(15060,0,0,76174),
(15060,1,4000,98304),
-- 20_20_water2
(15061,0,4608,65479),
(15061,1,32768,70343),
-- 20_20_water3
(15062,0,0,66791),
(15062,1,4624,72935),

-- 20_21_water1
(15063,0,0,98304),
(15063,1,4300,131072),

-- 20_22_water1
(15064,0,0,131072),
(15064,1,7168,163840),

-- 20_23_water1
(15065,0,0,163840),
(15065,1,32768,196608),

-- 20_24_water1
(15066,0,-0,196608),
(15066,1,32767,229376),

-- 21_18_water1
(15067,0,32768,0),
(15067,1,65536,10000),

-- 21_19_water1
(15068,0,32768,32767),
(15068,1,60672,65535),

-- 21_20_water1
(15069,0,32767,65535),
(15069,1,63567,90535),
-- 21_20_water2
(15070,0,63236,73140),
(15070,1,65536,75440),

-- 21_21_water1
(15071,0,43516,116836),
(15071,1,52516,126092),
-- 21_21_water2
(15072,0,48773,115910),
(15072,1,50237,116708),
-- 21_21_water3
(15073,0,46597,111628),
(15073,1,49597,115128),
-- 21_21_water4
(15074,0,49172,115128),
(15074,1,50136,116868),
-- 21_21_water5
(15075,0,48000,115128),
(15075,1,49172,116356),
-- 21_21_water6
(15076,0,44928,126976),
(15076,1,45568,127616),
-- 21_21_water7
(15077,0,44928,125504),
(15077,1,45568,126976),

-- 21_22_water1
(15078,0,41916,139479),
(15078,1,51916,152769),
-- 21_22_water2
(15079,0,39296,143616),
(15079,1,39936,144256),
-- 21_22_water3
(15080,0,39936,143616),
(15080,1,41408,144256),

-- 21_23_water1
(15081,0,32768,181239),
(15081,1,65536,196607),
-- 21_23_water2
(15082,0,32768,175599),
(15082,1,44032,181239),
-- 21_23_water3
(15083,0,57472,175599),
(15083,1,65536,181239),
-- 21_23_water4
(15084,0,42496,169984),
(15084,1,43136,170624),
-- 21_23_water5
(15085,0,43136,169984),
(15085,1,44608,170624),

-- 21_24_water1
(15086,0,32768,196608),
(15086,1,65536,229376),

-- 22_18_water1
(15087,0,65536,4768),
(15087,1,75536,32768),
-- 22_18_water2
(15088,0,75536,27768),
(15088,1,98304,32768),

-- 22_19_water1
(15089,0,84727,32768),
(15089,1,91727,53768),

-- 22_20_water1
(15090,0,65536,91304),
(15090,1,98304,98304),
-- 22_20_water2
(15091,0,65536,71304),
(15091,1,70536,91304),
-- 22_20_water3
(15092,0,73984,78080),
(15092,1,74624,78720),
-- 22_20_water4
(15093,0,74624,78080),
(15093,1,76096,78720),

-- 22_22_water1
(15094,0,78304,139840),
(15094,1,98304,163840),

-- 22_23_water1
(15095,0,65536,163840),
(15095,1,74752,196608),
-- 22_23_water2
(15096,0,74752,163840),
(15096,1,85215,173976),
-- 22_23_water3
(15097,0,74752,173976),
(15097,1,83244,178267),
-- 22_23_water4
(15098,0,74752,178267),
(15098,1,78031,180291),
-- 22_23_water5
(15099,0,91149,163840),
(15099,1,98304,166737),
-- 22_23_water6
(15100,0,95485,166737),
(15100,1,98304,193105),
-- 22_23_water7
(15101,0,92290,173976),
(15101,1,95485,185103),
-- 22_23_water8
(15102,0,92290,193105),
(15102,1,98304,196608),

-- 22_24_water1
(15103,0,93696,224128),
(15103,1,98304,229376),
-- 22_24_water2
(15104,0,93056,196608),
(15104,1,98304,201216),
-- 22_24_water3
(15105,0,65536,196608),
(15105,1,76032,200320),
-- 22_24_water4
(15106,0,70024,222217),
(15106,1,77862,229376),
-- 22_24_water5
(15107,0,65536,200320),
(15107,1,70024,229376),
-- 22_24_water6
(15108,0,70024,200320),
(15108,1,79174,222217),
-- 22_24_water7
(15109,0,77862,224128),
(15109,1,93696,229376),
-- 22_24_water8
(15110,0,80192,201216),
(15110,1,98304,224128),
-- 22_24_water9
(15111,0,81856,196608),
(15111,1,93056,201216),
-- 22_24_water10
(15112,0,79360,208897),
(15112,1,80000,209537),
-- 22_24_water11
(15113,0,80000,208897),
(15113,1,81472,209537),
-- 22_24_water12
(15114,0,79174,209727),
(15114,1,80192,224128),
-- 22_24_water13
(15115,0,79174,201216),
(15115,1,80192,208704),

-- 22_25_water1
(15116,0,79010,246660),
(15116,1,86498,254710),
-- 22_25_water2
(15117,0,84195,239659),
(15117,1,86179,242731),
-- 22_25_water3
(15118,0,82979,241471),
(15118,1,84195,241919),
-- 22_25_water4
(15119,0,80356,245012),
(15119,1,84644,245844),
-- 22_25_water5
(15120,0,80303,258156),
(15120,1,84591,258988),
-- 22_25_water6
(15121,0,65536,229376),
(15121,1,98304,262144),
-- 22_25_water7
(15122,0,78624,254710),
(15122,1,82336,255593),
-- 22_25_water8
(15123,0,82785,254710),
(15123,1,86497,255593),
-- 22_25_water9
(15124,0,82336,255350),
(15124,1,82785,255593),

-- 23_11_water1
(15125,0,98304,-229376),
(15125,1,131072,-196608),

-- 23_12_water1
(15126,0,119040,-196608),
(15126,1,131072,-178624),

-- 23_18_water1
(15127,0,98304,27767),
(15127,1,120320,32767),

-- 23_19_water1
(15128,0,103091,37760),
(15128,1,128091,62760),

-- 23_20_water1
(15129,0,110208,84224),
(15129,1,110848,84864),
-- 23_20_water2
(15130,0,110848,84224),
(15130,1,112320,84864),

-- 23_22_water1
(15131,0,98304,138239),
(15131,1,131072,163839),
-- 23_22_water2
(15132,0,112096,142623),
(15132,1,119232,147603),
-- 23_22_water3
(15133,0,117509,136740),
(15133,1,122009,138240),
-- 23_22_water4
(15134,0,117509,136740),
(15134,1,122009,138240),
-- 23_22_water5
(15135,0,117509,136740),
(15135,1,122009,138240),
-- 23_22_water6
(15136,0,114560,132480),
(15136,1,115200,133120),
-- 23_22_water7
(15137,0,115200,132480),
(15137,1,116672,133120),

-- 23_23_water1
(15138,0,98304,163840),
(15138,1,131072,167840),
-- 23_23_water2
(15139,0,98304,167840),
(15139,1,102304,196608),
-- 23_23_water3
(15140,0,124072,167840),
(15140,1,131072,196608),
-- 23_23_water4
(15141,0,102304,191608),
(15141,1,124072,196608),
-- 23_23_water5
(15142,0,121672,186199),
(15142,1,124072,189151),
-- 23_23_water6
(15143,0,102304,184170),
(15143,1,105652,187250),
-- 23_23_water7
(15144,0,102304,168567),
(15144,1,106804,173567),
-- 23_23_water8
(15145,0,107520,173696),
(15145,1,108160,174336),
-- 23_23_water9
(15146,0,108160,173696),
(15146,1,109632,174336),

-- 23_24_water1
(15147,0,98304,196608),
(15147,1,131072,229376),

-- 23_25_water1
(15148,0,98304,229376),
(15148,1,131072,262144),

-- 24_11_water1
(15149,0,131072,-229376),
(15149,1,163840,-196608),

-- 24_12_water1
(15150,0,131072,-196608),
(15150,1,163840,-178608),

-- 24_18_water1
(15151,0,145081,25139),
(15151,1,149881,29939),

-- 24_19_water1
(15152,0,131059,32768),
(15152,1,163827,65536),

-- 24_20_water1
(15153,0,136648,79304),
(15153,1,137400,80056),
-- 24_20_water2
(15154,0,137400,79360),
(15154,1,138816,80000),
-- 24_20_water3
(15155,0,137472,65536),
(15155,1,163840,98304),

-- 24_21_water1
(15156,0,131072,126072),
(15156,1,136072,131072),

-- 25_11_water1
(15157,0,163840,-229376),
(15157,1,196608,-196608),

-- 25_12_water1
(15158,0,163840,-196608),
(15158,1,168840,-186608),
-- 25_12_water2
(15159,0,173411,-187756),
(15159,1,186042,-182534),
-- 25_12_water3
(15160,0,174206,-182687),
(15160,1,176749,-179167),

-- 25_14_water1
(15161,0,170908,-116845),
(15161,1,173748,-113952),
-- 25_14_water2
(15162,0,170926,-113935),
(15162,1,173766,-111042),

-- 25_20_water1
(15163,0,163840,65760),
(15163,1,173840,95072),

-- 25_17_water1
(15164,0,168576,-17920),
(15164,1,169216,-17280),
-- 25_17_water2
(15165,0,169216,-17920),
(15165,1,170688,-17280),

-- 20_15_water1
(15166,0,0,-73536),
(15166,1,8000,-65536),

-- 20_16_water1
(15167,0,0,-65536),
(15167,1,32768,-32768),

-- 21_15_water1
(15168,0,32768,-98304),
(15168,1,65536,-65536),

-- 21_16_water1
(15169,0,32768,-65535),
(15169,1,65536,-32767),

-- 21_17_water1
(15170,0,32768,-32767),
(15170,1,65536,0),

-- 22_16_water1
(15171,0,65536,-40960),
(15171,1,98304,-32768),
-- 22_16_water2
(15172,0,91829,-55930),
(15172,1,95637,-50266),
-- 22_16_water3
(15173,0,87765,-54554),
(15173,1,91829,-50266),
-- 22_16_water4
(15174,0,84947,-50234),
(15174,1,90133,-46202),
-- 22_16_water5
(15175,0,76003,-46368),
(15175,1,84947,-39968),
-- 22_16_water6
(15176,0,68852,-62008),
(15176,1,74036,-56192),
-- 22_16_water7
(15177,0,69480,-56192),
(15177,1,77032,-53203),
-- 22_16_water8
(15178,0,71311,-53203),
(15178,1,76175,-50292),
-- 22_16_water9
(15179,0,75059,-63591),
(15179,1,78355,-57517),
-- 22_16_water10
(15180,0,78355,-65184),
(15180,1,83859,-51872),
-- 22_16_water11
(15181,0,83859,-64826),
(15181,1,87187,-55418),
-- 22_16_water12
(15182,0,87187,-62909),
(15182,1,90963,-58301),
-- 22_16_water13
(15183,0,77283,-51872),
(15183,1,83747,-49440),
-- 22_16_water14
(15184,0,83859,-55418),
(15184,1,86227,-52602),
-- 22_16_water15
(15185,0,69635,-47328),
(15185,1,76003,-39776),
-- 22_16_water16
(15186,0,87187,-58301),
(15186,1,89235,-56541),

-- 22_17_water1
(15187,0,65536,-32768),
(15187,1,76800,0),
-- 22_17_water2
(15188,0,76800,-32768),
(15188,1,98304,-18432),

-- Additional Water Zones
-- 24_22_water1
(15189,0,131072,131072),
(15189,1,163840,163840),
-- 24_23_water1
(15190,0,131072,163840),
(15190,1,163840,196608),
-- 20_17_water1
(15191,0,0,-32768),
(15191,1,32678,0);

-- Elves Mother Trees Zones
INSERT INTO `zone_vertices` VALUES
-- mother_tree_start_zone
(15200,0,45889,41890),
(15200,1,45277,41672),
(15200,2,45028,41478),
(15200,3,44809,41230),
(15200,4,44522,40689),
(15200,5,44501,39970),
(15200,6,44725,39407),
(15200,7,44930,39145),
(15200,8,45447,38764),
(15200,9,46073,38618),
(15200,10,46710,38716),
(15200,11,47255,39049),
(15200,12,47743,39834),
(15200,13,47772,40568),
(15200,14,47545,41125),
(15200,15,47108,41599),
(15200,16,46531,41868),
-- mother_tree_town
(15201,0,45234,49892),
(15201,1,45117,49826),
(15201,2,45031,49722),
(15201,3,44986,49597),
(15201,4,44985,49462),
(15201,5,45032,49336),
(15201,6,45116,49233),
(15201,7,45233,49165),
(15201,8,45365,49143),
(15201,9,45498,49166),
(15201,10,45614,49235),
(15201,11,45700,49336),
(15201,12,45746,49462),
(15201,13,45747,49596),
(15201,14,45699,49723),
(15201,15,45614,49825),
(15201,16,45498,49893),
(15201,17,45366,49914),
-- 20_19_worldtree
(15300,0,21101,50538),
(15300,1,21511,50683),
(15300,2,21642,51005),
(15300,3,21583,51349),
(15300,4,21255,51581),
(15300,5,20852,51473),
(15300,6,20627,51121),
(15300,7,20728,50743),
-- 20_20_worldtree
(15301,0,25084,81616),
(15301,1,25073,81892),
(15301,2,24948,81895),
(15301,3,24826,81866),
(15301,4,24716,81788),
(15301,5,24637,81623),
(15301,6,24637,81428),
(15301,7,25076,81428),
-- 21_20_worldtree
(15302,0,57755,85802),
(15302,1,57974,86079),
(15302,2,57953,86404),
(15302,3,57711,86683),
(15302,4,57324,86686),
(15302,5,57105,86436),
(15302,6,57088,86061),
(15302,7,57404,85785);

-- Starts (Peace Zones)
INSERT INTO `zone_vertices` VALUES
-- mage_start_peace_1
(15380,0,-90034,248143),
(15380,1,-89960,248698),
(15380,2,-90520,248847),
(15380,3,-91136,248445),
(15380,4,-91270,248296),
(15380,5,-91328,248092),
(15380,6,-91250,247867),
(15380,7,-91063,247704),
(15380,8,-90863,247676),
(15380,9,-90638,247748),
-- mage_start_peace_2
(15381,0,-90165,247096),
(15381,1,-88576,248162),
(15381,2,-89962,250239),
(15381,3,-91512,249150),
-- mage_start_peace_3
(15382,0,-88457,248867),
(15382,1,-88611,249099),
(15382,2,-89054,249756),
(15382,3,-89279,250048),
(15382,4,-89684,250143),
(15382,5,-90008,249970),
(15382,6,-88864,248209),
(15382,7,-88542,248446),
-- mage_start_peace_4
(15383,0,-88732,248912),
(15383,1,-88418,249116),
(15383,2,-89005,249980),
(15383,3,-89311,249787),
-- mage_start_peace_5
(15384,0,-88612,249461),
(15384,1,-88559,249539),
(15384,2,-88581,249649),
(15384,3,-88680,249708),
(15384,4,-88761,249704),
(15384,5,-89050,249513),
(15384,6,-89073,249332),
(15384,7,-88895,249273),
-- fighter_start_peace_1
(15385,0,-73436,257725),
(15385,1,-71668,256229),
(15385,2,-69952,258077),
(15385,3,-71896,259701),
-- fighter_start_peace_2
(15386,0,-73180,257663),
(15386,1,-72460,258619),
(15386,2,-72720,258831),
(15386,3,-73284,258115),
(15386,4,-73260,257855),
-- fighter_start_peace_3
(15387,0,-71279,256408),
(15387,1,-70679,257116),
(15387,2,-70939,257328),
(15387,3,-71575,256612),
(15387,4,-71634,256392),
-- fighter_start_peace_4
(15388,0,-72596,259181),
(15388,1,-70363,257272),
(15388,2,-70041,257631),
(15388,3,-72303,259545),
-- darkelf_start_peace_1
(15389,0,28422,8936),
(15389,1,30282,10670),
(15389,2,29952,11744),
(15389,3,28457,13117),
(15389,4,27730,13126),
(15389,5,26435,11893),
(15389,6,26450,10146),
(15389,7,27792,8929),
-- darkelf_start_peace_2
(15390,0,29434,10233),
(15390,1,31273,10233),
(15390,2,31273,11827),
(15390,3,29431,11830),
-- elf_start_peace1
(15391,0,47987,40688),
(15391,1,47644,41254),
(15391,2,47139,41756),
(15391,3,46576,42051),
(15391,4,45590,42006),
(15391,5,44823,41489),
(15391,6,44355,40860),
(15391,7,44168,40397),
(15391,8,44319,39900),
(15391,9,44723,39030),
(15391,10,45366,38626),
(15391,11,46511,38446),
(15391,12,47292,38808),
(15391,13,47736,39330),
(15391,14,48079,39911),
-- elf_start_peace2
(15392,0,44215,39803),
(15392,1,44497,40504),
(15392,2,43643,41416),
(15392,3,43398,41419),
(15392,4,42884,41191),
(15392,5,42475,40529),
(15392,6,42466,40285),
(15392,7,42762,39658),
(15392,8,43311,39336),
(15392,9,43546,39327),
-- elf_start_peace3
(15393,0,49799,39991),
(15393,1,49812,40226),
(15393,2,48958,41201),
(15393,3,48724,41204),
(15393,4,48096,40759),
(15393,5,47883,40159),
(15393,6,48123,39481),
(15393,7,48636,39123),
(15393,8,48885,39121),
(15393,9,49368,39360),
-- orc_start_peace
(15394,0,-58952,-115543),
(15394,1,-52769,-115553),
(15394,2,-52758,-111736),
(15394,3,-58952,-111749),
-- dwarf_start
(15395,0,110063,-175794),
(15395,1,110565,-173944),
(15395,2,110518,-173426),
(15395,3,109153,-171575),
(15395,4,106345,-171905),
(15395,5,104853,-174391),
(15395,6,105481,-176144),
(15395,7,106031,-177035),
(15395,8,107660,-177623),
(15395,9,109208,-177140),
-- Cave of Souls (vertices, min Z & Max Z are estimated)
(13396,0,-126000,37168),
(13396,1,-122944,39024);

-- Harbors (Peace Zones)
INSERT INTO `zone_vertices` VALUES
-- speaking_port_peace1
(15400,0,-96610,258814),
(15400,1,-96389,258748),
(15400,2,-96369,258787),
(15400,3,-96374,259051),
(15400,4,-96640,259059),
-- speaking_port_peace2
(15401,0,-96561,258759),
(15401,1,-96411,258764),
(15401,2,-96553,259066),
(15401,3,-97256,259068),
(15401,4,-97245,258787),
-- speaking_port_peace3
(15402,0,-96969,259036),
(15402,1,-96649,259036),
(15402,2,-96648,261414),
(15402,3,-96968,261414),
-- speaking_port_peace4
(15403,0,-97161,259866),
(15403,1,-96961,259866),
(15403,2,-96961,260203),
(15403,3,-97161,260203),
-- speaking_port_peace5
(15404,0,-96750,259679),
(15404,1,-96326,259679),
(15404,2,-96326,260400),
(15404,3,-96750,260400),
-- speaking_port_peace6
(15405,0,-97290,261068),
(15405,1,-95888,261068),
(15405,2,-95888,261419),
(15405,3,-97290,261418),
-- speaking_port_peace7
(15406,0,-97476,260763),
(15406,1,-97167,260763),
(15406,2,-97167,261419),
(15406,3,-97476,261419),
-- speaking_port_peace8
(15407,0,-97237,259333),
(15407,1,-96923,259333),
(15407,2,-96923,259637),
(15407,3,-97237,259637),
-- gludin_port1
(15408,0,-92600,148457),
(15408,1,-90416,148372),
(15408,2,-90412,151666),
(15408,3,-92508,151678),
(15408,4,-93497,149244),
-- gludin_port2
(15409,0,-94294,148251),
(15409,1,-92763,148869),
(15409,2,-92437,152317),
(15409,3,-93461,153244),
(15409,4,-95444,151462),
(15409,5,-95446,149881),
(15409,6,-94588,148248),
-- giran_port1
(15410,0,47189,185982),
(15410,1,49284,183651),
(15410,2,52767,186787),
(15410,3,49719,190044),
-- giran_port2
(15411,0,45288,186705),
(15411,1,47947,185316),
(15411,2,50535,189487),
(15411,3,47639,191052),
-- giran_port3
(15412,0,43935,187891),
(15412,1,45949,186815),
(15412,2,46215,187346),
(15412,3,44226,188420),
-- giran_port4
(15413,0,41861,188551),
(15413,1,44221,187269),
(15413,2,46275,191156),
(15413,3,44031,192413),
-- heiness_peace1
(15414,0,106085,216119),
(15414,1,116559,216118),
(15414,2,116533,229030),
(15414,3,106085,229015),
-- rune_peace2
(15415,0,43099,-38911),
(15415,1,40028,-35494),
(15415,2,37429,-35357),
(15415,3,32846,-38149),
(15415,4,32804,-50466),
(15415,5,36348,-52427),
(15415,6,39429,-52058),
(15415,7,46334,-46534),
-- Gludio Airship Field (Peace Zone) (vertices, min Z & Max Z are estimated)
(15420,0,-150094,256954),
(15420,1,-151509,255455),
(15420,2,-151509,255170),
(15420,3,-149454,252862),
(15420,4,-149262,252862),
(15420,5,-147210,255170),
(15420,6,-147210,255455),
(15420,7,-148624,256954);

-- Cruma (Damage Zone)
INSERT INTO `zone_vertices` VALUES
-- cruma_boss_damage_zone
(16000,0,17869,108566),
(16000,1,18071,108774),
(16000,2,18072,109060),
(16000,3,17865,109265),
(16000,4,17580,109264),
(16000,5,17379,109062),
(16000,6,17379,108774),
(16000,7,17584,108569);

-- Sea of Spores (Swamp/Poison Zones)
INSERT INTO `zone_vertices` VALUES
-- spore_boss_swamp_zone
(16001,0,43084,15944),
(16001,1,45140,15816),
(16001,2,45748,17200),
(16001,3,44504,18780),
(16001,4,43284,18952),
(16001,5,42476,18164),
(16001,6,42480,16448),
-- spore_boss_poison_zone
(16002,0,43084,15944),
(16002,1,45140,15816),
(16002,2,45748,17200),
(16002,3,44504,18780),
(16002,4,43284,18952),
(16002,5,42476,18164),
(16002,6,42480,16448);

-- Aden Castle (Swamp/Damage Zones)
INSERT INTO `zone_vertices` VALUES
-- aden_slow_8
(17000,0,149084,7070),
(17000,1,149349,7069),
(17000,2,149349,7203),
(17000,3,149084,7204),
-- aden_slow_7
(17001,0,149084,6942),
(17001,1,149349,6941),
(17001,2,149349,7075),
(17001,3,149084,7076),
-- aden_slow_6
(17002,0,149084,6814),
(17002,1,149349,6813),
(17002,2,149349,6947),
(17002,3,149084,6948),
-- aden_slow_5
(17003,0,149084,6686),
(17003,1,149349,6685),
(17003,2,149349,6819),
(17003,3,149084,6820),
-- aden_slow_4
(17004,0,145548,7054),
(17004,1,145813,7053),
(17004,2,145813,7187),
(17004,3,145548,7188),
-- aden_slow_3
(17005,0,145548,6926),
(17005,1,145813,6925),
(17005,2,145813,7059),
(17005,3,145548,7060),
-- aden_slow_2
(17006,0,145548,6798),
(17006,1,145813,6797),
(17006,2,145813,6931),
(17006,3,145548,6932),
-- aden_slow_1
(17007,0,145548,6670),
(17007,1,145813,6669),
(17007,2,145813,6803),
(17007,3,145548,6804),
-- aden_damage_8
(17008,0,149084,7070),
(17008,1,149349,7069),
(17008,2,149349,7203),
(17008,3,149084,7204),
-- aden_damage_7
(17009,0,149084,6942),
(17009,1,149349,6941),
(17009,2,149349,7075),
(17009,3,149084,7076),
-- aden_damage_6
(17010,0,149084,6814),
(17010,1,149349,6813),
(17010,2,149349,6947),
(17010,3,149084,6948),
-- aden_damage_5
(17011,0,149084,6686),
(17011,1,149349,6685),
(17011,2,149349,6819),
(17011,3,149084,6820),
-- aden_damage_4
(17012,0,145548,7054),
(17012,1,145813,7053),
(17012,2,145813,7187),
(17012,3,145548,7188),
-- aden_damage_3
(17013,0,145548,6926),
(17013,1,145813,6925),
(17013,2,145813,7059),
(17013,3,145548,7060),
-- aden_damage_2
(17014,0,145548,6798),
(17014,1,145813,6797),
(17014,2,145813,6931),
(17014,3,145548,6932),
-- aden_damage_1
(17015,0,145548,6670),
(17015,1,145813,6669),
(17015,2,145813,6803),
(17015,3,145548,6804);

-- Gludio Castle (Swamp/Damage Zones)
INSERT INTO `zone_vertices` VALUES
-- gludio_slow_1
(17016,0,-18255,110790),
(17016,1,-17971,110790),
(17016,2,-17972,111174),
(17016,3,-18256,111174),
-- gludio_slow_2
(17017,0,-19213,107137),
(17017,1,-18827,107137),
(17017,2,-18827,107404),
(17017,3,-19213,107404),
-- gludio_damage_1
(17018,0,-18255,110790),
(17018,1,-17971,110790),
(17018,2,-17972,111174),
(17018,3,-18256,111174),
-- gludio_damage_2
(17019,0,-19213,107137),
(17019,1,-18827,107137),
(17019,2,-18827,107404),
(17019,3,-19213,107404);

-- Dion Castle (Swamp/Damage Zones)
INSERT INTO `zone_vertices` VALUES
-- dion_slow_1
(17020,0,22215,158960),
(17020,1,21931,158960),
(17020,2,21932,158576),
(17020,3,22216,158576),
-- dion_slow_2
(17021,0,23173,162613),
(17021,1,22787,162613),
(17021,2,22787,162346),
(17021,3,23173,162346),
-- dion_damage_1
(17022,0,22215,158960),
(17022,1,21931,158960),
(17022,2,21932,158576),
(17022,3,22216,158576),
-- dion_damage_2
(17023,0,23173,162613),
(17023,1,22787,162613),
(17023,2,22787,162346),
(17023,3,23173,162346);

-- Giran Castle (Swamp/Damage Zones)
INSERT INTO `zone_vertices` VALUES
-- giran_slow_1
(17024,0,115132,144954),
(17024,1,115132,145238),
(17024,2,114748,145237),
(17024,3,114748,144953),
-- giran_slow_2
(17025,0,118785,143996),
(17025,1,118785,144382),
(17025,2,118518,144382),
(17025,3,118518,143996),
-- giran_damage_1
(17026,0,115132,144954),
(17026,1,115132,145238),
(17026,2,114748,145237),
(17026,3,114748,144953),
-- giran_damage_2
(17027,0,118785,143996),
(17027,1,118785,144382),
(17027,2,118518,144382),
(17027,3,118518,143996);

-- Oren Castle (Swamp/Damage Zones)
INSERT INTO `zone_vertices` VALUES
-- oren_slow_1
(17028,0,81208,37049),
(17028,1,81208,37333),
(17028,2,80824,37332),
(17028,3,80824,37048),
-- oren_slow_2
(17029,0,84861,36091),
(17029,1,84861,36477),
(17029,2,84594,36477),
(17029,3,84594,36091),
-- oren_damage_1
(17030,0,81208,37049),
(17030,1,81208,37333),
(17030,2,80824,37332),
(17030,3,80824,37048),
-- oren_damage_2
(17031,0,84861,36091),
(17031,1,84861,36477),
(17031,2,84594,36477),
(17031,3,84594,36091);

-- Innadril Castle (Swamp/Damage Zones)
INSERT INTO `zone_vertices` VALUES
-- innadrile_slow_1
(17032,0,116166,247739),
(17032,1,115882,247739),
(17032,2,115883,247355),
(17032,3,116167,247355),
-- innadrile_slow_2
(17033,0,117124,251392),
(17033,1,116738,251392),
(17033,2,116738,251125),
(17033,3,117124,251125),
-- innadrile_damage_1
(17034,0,116166,247739),
(17034,1,115882,247739),
(17034,2,115883,247355),
(17034,3,116167,247355),
-- innadrile_damage_2
(17035,0,117124,251392),
(17035,1,116738,251392),
(17035,2,116738,251125),
(17035,3,117124,251125);

-- Goddard Castle (Swamp/Damage Zones)
INSERT INTO `zone_vertices` VALUES
-- godad_slow_1
(17036,0,149235,-47768),
(17036,1,149579,-47608),
(17036,2,149515,-47472),
(17036,3,149169,-47634),
-- godad_slow_2
(17037,0,145352,-47607),
(17037,1,145696,-47768),
(17037,2,145760,-47633),
(17037,3,145415,-47471),
-- godad_damage_1
(17038,0,149235,-47768),
(17038,1,149579,-47608),
(17038,2,149515,-47472),
(17038,3,149169,-47634),
-- godad_damage_2
(17039,0,145352,-47607),
(17039,1,145696,-47768),
(17039,2,145760,-47633),
(17039,3,145415,-47471);

-- Rune Castle (Swamp/Damage Zones) (vertices, min Z & Max Z are estimated)
INSERT INTO `zone_vertices` VALUES
-- slow_1
(17040,0,14215,-47664),
(17040,1,14046,-47853),
(17040,2,13796,-47667),
(17040,3,13924,-47440),
-- slow_2
(17041,0,14047,-50451),
(17041,1,14222,-50636),
(17041,2,13926,-50856),
(17041,3,13788,-50640),
-- damage_1
(17042,0,14215,-47664),
(17042,1,14046,-47853),
(17042,2,13796,-47667),
(17042,3,13924,-47440),
-- damage_2
(17043,0,14047,-50451),
(17043,1,14222,-50636),
(17043,2,13926,-50856),
(17043,3,13788,-50640);

-- Schuttgart Castle (Swamp/Damage Zones) (vertices, min Z & Max Z are estimated)
INSERT INTO `zone_vertices` VALUES
-- slow_1
(17044,0,75433,-151671),
(17044,1,75500,-151529),
(17044,2,75855,-151694),
(17044,3,75788,-151837),
-- slow_2
(17045,0,79607,-151531),
(17045,1,79676,-151670),
(17045,2,79320,-151836),
(17045,3,79254,-151696),
-- damage_1
(17046,0,75433,-151671),
(17046,1,75500,-151529),
(17046,2,75855,-151694),
(17046,3,75788,-151837),
-- damage_2
(17047,0,79607,-151531),
(17047,1,79676,-151670),
(17047,2,79320,-151836),
(17047,3,79254,-151696);

-- Blazing Swamp (Burn Damage Zones)
INSERT INTO `zone_vertices` VALUES
-- fireswamp_1
(20020,0,141408,-9676),
(20020,1,142248,-9284),
(20020,2,142428,-8732),
(20020,3,142344,-8256),
(20020,4,142096,-8136),
(20020,5,141600,-8444),
(20020,6,141264,-9352),
-- fireswamp_2
(20021,0,143780,-8144),
(20021,1,144504,-8484),
(20021,2,145000,-8064),
(20021,3,144948,-7372),
(20021,4,144552,-6872),
(20021,5,144120,-7076),
(20021,6,143716,-7672),
-- fireswamp_3
(20022,0,144144,-7020),
(20022,1,144552,-6836),
(20022,2,144564,-6324),
(20022,3,144072,-6280),
-- fireswamp_4
(20023,0,144060,-6240),
(20023,1,144548,-6276),
(20023,2,145416,-5772),
(20023,3,145292,-4940),
(20023,4,144208,-5076),
(20023,5,143920,-5540),
-- fireswamp_5
(20024,0,148616,-9208),
(20024,1,149200,-9492),
(20024,2,149992,-9472),
(20024,3,149880,-8348),
(20024,4,148452,-8308),
(20024,5,148340,-8600),
-- fireswamp_6
(20025,0,151636,-8512),
(20025,1,151592,-8196),
(20025,2,150644,-7904),
(20025,3,149912,-8420),
(20025,4,150040,-9404),
-- fireswamp_7
(20026,0,150728,-10176),
(20026,1,151352,-10536),
(20026,2,150404,-9264),
(20026,3,150072,-9444),
-- fireswamp_8
(20027,0,151192,-12588),
(20027,1,151612,-11884),
(20027,2,151772,-11248),
(20027,3,151572,-10860),
-- fireswamp_9
(20028,0,150456,-15148),
(20028,1,151760,-15072),
(20028,2,151556,-13400),
(20028,3,151148,-12856),
(20028,4,150384,-13904),
-- fireswamp_10
(20029,0,145032,-15132),
(20029,1,146108,-15008),
(20029,2,148212,-11784),
(20029,3,147528,-10992),
(20029,4,146000,-11072),
-- fireswamp_11
(20030,0,148288,-14420),
(20030,1,148432,-14428),
(20030,2,147984,-12448),
(20030,3,147228,-13572),
-- fireswamp_12
(20031,0,146120,-18720),
(20031,1,146276,-18884),
(20031,2,145976,-15072),
(20031,3,145056,-15200),
-- fireswamp_13
(20032,0,140616,-16808),
(20032,1,143708,-17160),
(20032,2,143152,-16000),
(20032,3,141268,-15872),
-- fireswamp_14
(20033,0,148892,-23044),
(20033,1,149160,-22280),
(20033,2,148292,-21148),
(20033,3,148080,-21508),
(20033,4,147584,-24204),
(20033,5,147948,-24056),
-- fireswamp_15
(20034,0,143804,-27456),
(20034,1,147168,-25768),
(20034,2,147164,-25372),
(20034,3,143308,-26812);

-- Devil Isle Zones
INSERT INTO `zone_vertices` VALUES
-- Physical Damage
-- devil_damage_001
(20035,0,51296,205421),
(20035,1,51788,205266),
(20035,2,51496,205621),
(20035,3,51072,205896),
-- devil_damage_002
(20036,0,51820,205340),
(20036,1,52535,205305),
(20036,2,52535,205436),
(20036,3,51705,205528),
-- devil_damage_003
(20037,0,43439,213259),
(20037,1,43589,213249),
(20037,2,43750,213760),
(20037,3,43680,214092),
-- devil_damage_004
(20038,0,42805,214266),
(20038,1,43627,214195),
(20038,2,43386,214355),
(20038,3,42805,214405),
-- devil_damage_005
(20039,0,43511,218426),
(20039,1,43711,218426),
(20039,2,43711,218759),
(20039,3,43511,218759),
-- devil_damage_006
(20040,0,43012,218850),
(20040,1,43708,218850),
(20040,2,43719,219260),
(20040,3,43001,219260),
-- devil_damage_007
(20041,0,50630,211383),
(20041,1,51129,211383),
(20041,2,51129,211858),
(20041,3,50642,211858),
-- devil_damage_008
(20042,0,51820,206520),
(20042,1,52792,206500),
(20042,2,52812,207128),
(20042,3,51844,207060),
-- devil_damage_009
(20043,0,50673,210566),
(20043,1,51054,210572),
(20043,2,51054,211317),
(20043,3,50667,211311),
-- devil_damage_010
(20044,0,50608,209718),
(20044,1,51145,209718),
(20044,2,51150,210201),
(20044,3,50614,210201),
-- Poison
-- devil_poison_001
(20045,0,41707,211982),
(20045,1,42025,211917),
(20045,2,42463,212012),
(20045,3,42702,212346),
(20045,4,42593,212977),
(20045,5,42301,213144),
(20045,6,41821,213081),
(20045,7,41600,212602),
-- devil_poison_002
(20046,0,45296,213219),
(20046,1,46136,213081),
(20046,2,46289,213374),
(20046,3,46158,213669),
(20046,4,45105,213668),
-- devil_poison_003
(20047,0,47790,220792),
(20047,1,48632,220818),
(20047,2,48683,220992),
(20047,3,47828,220980),
-- Swamp
-- devil_slow_8
(20048,0,55250,210873),
(20048,1,55762,211217),
(20048,2,55934,212274),
(20048,3,55686,212533),
(20048,4,54639,212740),
(20048,5,54276,212407),
(20048,6,54160,211696),
(20048,7,54332,211108),
-- Recovery
-- devil_healing_zone
(20049,0,41520,205163),
(20049,1,44448,205623),
(20049,2,44352,208957),
(20049,3,42813,208983),
(20049,4,41473,207893);

-- Imperial Tomb/4 Sepulchers Zones
INSERT INTO `zone_vertices` VALUES
-- conquerors_weakness
(20051,0,186739,-86322),
(20051,1,190108,-86335),
(20051,2,190110,-84794),
(20051,3,186736,-84786),
-- conquerors_pddown
(20052,0,186739,-86322),
(20052,1,190108,-86335),
(20052,2,190110,-84794),
(20052,3,186736,-84786),
-- conquerors_poison
(20053,0,186739,-86322),
(20053,1,190108,-86335),
(20053,2,190110,-84794),
(20053,3,186736,-84786),
-- conquerors_nonheal
(20054,0,186739,-86322),
(20054,1,190108,-86335),
(20054,2,190110,-84794),
(20054,3,186736,-84786),
-- lords_weakness
(20055,0,185028,-89729),
(20055,1,188398,-89741),
(20055,2,188400,-88200),
(20055,3,185026,-88192),
-- lords_pddown
(20056,0,185028,-89729),
(20056,1,188398,-89741),
(20056,2,188400,-88200),
(20056,3,185026,-88192),
-- lords_poison
(20057,0,185028,-89729),
(20057,1,188398,-89741),
(20057,2,188400,-88200),
(20057,3,185026,-88192),
-- lords_nonheal
(20058,0,185028,-89729),
(20058,1,188398,-89741),
(20058,2,188400,-88200),
(20058,3,185026,-88192),
-- savants_weakness
(20059,0,172411,-81083),
(20059,1,173942,-81073),
(20059,2,173931,-77639),
(20059,3,172418,-77644),
-- savants_pddown
(20060,0,172411,-81083),
(20060,1,173942,-81073),
(20060,2,173931,-77639),
(20060,3,172418,-77644),
-- savants_poison
(20061,0,172411,-81083),
(20061,1,173942,-81073),
(20061,2,173931,-77639),
(20061,3,172418,-77644),
-- savants_nonheal
(20062,0,172411,-81083),
(20062,1,173942,-81073),
(20062,2,173931,-77639),
(20062,3,172418,-77644),
-- magistrates_weakness
(20063,0,174822,-77261),
(20063,1,176354,-77251),
(20063,2,176342,-73817),
(20063,3,174829,-73822),
-- magistrates_pddown
(20064,0,174822,-77261),
(20064,1,176354,-77251),
(20064,2,176342,-73817),
(20064,3,174829,-73822),
-- magistrates_poison
(20065,0,174822,-77261),
(20065,1,176354,-77251),
(20065,2,176342,-73817),
(20065,3,174829,-73822),
-- magistrates_nonheal
(20066,0,174822,-77261),
(20066,1,176354,-77251),
(20066,2,176342,-73817),
(20066,3,174829,-73822);

-- Hot Springs Zones
INSERT INTO `zone_vertices` VALUES
-- Hot Springs Illusion
-- spa_11
(20200,0,141249,-109636),
(20200,1,141473,-109798),
(20200,2,141739,-109821),
(20200,3,141924,-109669),
(20200,4,142038,-109397),
(20200,5,141852,-109130),
(20200,6,141604,-109051),
(20200,7,141321,-109091),
(20200,8,141213,-109266),
-- spa_21
(20201,0,140174,-105832),
(20201,1,140490,-105875),
(20201,2,140962,-105738),
(20201,3,141039,-105378),
(20201,4,140872,-105119),
(20201,5,140081,-105295),
-- spa_31
(20202,0,144927,-105193),
(20202,1,145226,-105412),
(20202,2,145576,-105344),
(20202,3,145819,-104976),
(20202,4,145575,-104555),
(20202,5,145217,-104490),
(20202,6,144935,-104684),
(20202,7,144832,-104959),
-- spa_41
(20203,0,152081,-108262),
(20203,1,152455,-108588),
(20203,2,152835,-108448),
(20203,3,152992,-108120),
(20203,4,152817,-107670),
(20203,5,152310,-107632),
(20203,6,152069,-107905),
-- spa_51
(20204,0,155279,-105735),
(20204,1,155448,-105880),
(20204,2,155992,-105963),
(20204,3,156201,-105790),
(20204,4,156133,-105320),
(20204,5,155896,-105229),
(20204,6,155459,-105254),
(20204,7,155283,-105478),
-- spa_61
(20205,0,156838,-109948),
(20205,1,157133,-110046),
(20205,2,157436,-109918),
(20205,3,157491,-109405),
(20205,4,157197,-109197),
(20205,5,156843,-109261),
(20205,6,156683,-109569),
-- spa_71
(20206,0,152063,-116732),
(20206,1,152505,-116982),
(20206,2,152904,-116927),
(20206,3,153020,-116469),
(20206,4,152881,-116221),
(20206,5,152555,-116100),
(20206,6,152285,-116160),
(20206,7,152099,-116415),
-- spa_81
(20207,0,152683,-112829),
(20207,1,152796,-113129),
(20207,2,153125,-113339),
(20207,3,153557,-113190),
(20207,4,153649,-112721),
(20207,5,153344,-112385),
(20207,6,152937,-112409),
-- spa_91
(20208,0,157444,-115790),
(20208,1,157774,-115907),
(20208,2,158174,-115759),
(20208,3,158017,-114971),
(20208,4,157625,-114984),
(20208,5,157439,-115101),
-- Disease treatment
-- spa_12
(20209,0,141249,-109636),
(20209,1,141473,-109798),
(20209,2,141739,-109821),
(20209,3,141924,-109669),
(20209,4,142038,-109397),
(20209,5,141852,-109130),
(20209,6,141604,-109051),
(20209,7,141321,-109091),
(20209,8,141213,-109266),
-- spa_22
(20210,0,140174,-105832),
(20210,1,140490,-105875),
(20210,2,140962,-105738),
(20210,3,141039,-105378),
(20210,4,140872,-105119),
(20210,5,140081,-105295),
-- spa_32
(20211,0,144927,-105193),
(20211,1,145226,-105412),
(20211,2,145576,-105344),
(20211,3,145819,-104976),
(20211,4,145575,-104555),
(20211,5,145217,-104490),
(20211,6,144935,-104684),
(20211,7,144832,-104959),
-- spa_42
(20212,0,152081,-108262),
(20212,1,152455,-108588),
(20212,2,152835,-108448),
(20212,3,152992,-108120),
(20212,4,152817,-107670),
(20212,5,152310,-107632),
(20212,6,152069,-107905),
-- spa_52
(20213,0,155279,-105735),
(20213,1,155448,-105880),
(20213,2,155992,-105963),
(20213,3,156201,-105790),
(20213,4,156133,-105320),
(20213,5,155896,-105229),
(20213,6,155459,-105254),
(20213,7,155283,-105478),
-- spa_62
(20214,0,156838,-109948),
(20214,1,157133,-110046),
(20214,2,157436,-109918),
(20214,3,157491,-109405),
(20214,4,157197,-109197),
(20214,5,156843,-109261),
(20214,6,156683,-109569),
-- spa_72
(20215,0,152063,-116732),
(20215,1,152505,-116982),
(20215,2,152904,-116927),
(20215,3,153020,-116469),
(20215,4,152881,-116221),
(20215,5,152555,-116100),
(20215,6,152285,-116160),
(20215,7,152099,-116415),
-- spa_82
(20216,0,152683,-112829),
(20216,1,152796,-113129),
(20216,2,153125,-113339),
(20216,3,153557,-113190),
(20216,4,153649,-112721),
(20216,5,153344,-112385),
(20216,6,152937,-112409),
-- spa_92
(20217,0,157444,-115790),
(20217,1,157774,-115907),
(20217,2,158174,-115759),
(20217,3,158017,-114971),
(20217,4,157625,-114984),
(20217,5,157439,-115101),
-- spa_102
(20218,0,147182,-113255),
(20218,1,147194,-113430),
(20218,2,147312,-113584),
(20218,3,147467,-113630),
(20218,4,147748,-113523),
(20218,5,147816,-113273),
(20218,6,147723,-113074),
(20218,7,147512,-112956),
(20218,8,147258,-113048);

-- Forge of the Gods/Hall of Flames (Fire Zones)
INSERT INTO `zone_vertices` VALUES
-- godad_fire_zone1
(20220,0,192073,-118243),
(20220,1,192185,-116883),
(20220,2,191921,-116651),
(20220,3,191330,-116793),
(20220,4,190997,-118195),
-- godad_fire_zone2
(20221,0,183700,-114976),
(20221,1,183996,-115008),
(20221,2,183988,-114940),
(20221,3,183892,-114896),
(20221,4,183768,-114912),
-- godad_fire_zone3
(20222,0,170882,-116919),
(20222,1,173775,-116885),
(20222,2,173761,-113989),
(20222,3,170896,-113924),
-- godad_fire_zone4
(20223,0,170947,-113900),
(20223,1,173759,-113954),
(20223,2,173776,-111044),
(20223,3,170920,-111048);

-- Forge of the Gods/Hall of Flames (Npc HP Regeneration Zones)
INSERT INTO `zone_vertices` VALUES
-- fire_pot_god_hp_regen1
(20240,0,185241,-118610),
(20240,1,185966,-119586),
(20240,2,187638,-117286),
(20240,3,186478,-116565),
-- fire_pot_god_hp_regen2
(20241,0,182713,-119880),
(20241,1,183822,-120471),
(20241,2,184986,-118671),
(20241,3,183254,-118355),
-- fire_pot_god_hp_regen3
(20242,0,184021,-121547),
(20242,1,185825,-121596),
(20242,2,185937,-119732),
(20242,3,184633,-119645),
-- fire_pot_god_hp_regen4
(20243,0,186868,-121700),
(20243,1,188500,-121604),
(20243,2,188608,-119980),
(20243,3,187088,-120020),
-- fire_pot_god_hp_regen5
(20244,0,189116,-121636),
(20244,1,190732,-121116),
(20244,2,190108,-119288),
(20244,3,188672,-119984),
-- fire_pot_god_hp_regen6
(20245,0,187636,-120012),
(20245,1,189680,-119284),
(20245,2,188696,-117896),
(20245,3,187504,-118572),
-- fire_pot_god_hp_regen7
(20246,0,188888,-118252),
(20246,1,191124,-118348),
(20246,2,190324,-115548),
(20246,3,188992,-116344);

-- Swamp of Screams (Buffs/Debuffs Zones)
INSERT INTO `zone_vertices` VALUES
-- Monsters Buffs Zones
-- godad_swamp_monster1
(20260,0,71030,-60113),
(20260,1,70966,-59549),
(20260,2,70250,-59173),
(20260,3,69622,-59597),
(20260,4,69634,-60261),
(20260,5,70026,-60593),
(20260,6,70566,-60601),
-- godad_swamp_monster2
(20261,0,73522,-59473),
(20261,1,73454,-58861),
(20261,2,73194,-58629),
(20261,3,72642,-58433),
(20261,4,72110,-58501),
(20261,5,71782,-59013),
(20261,6,71922,-59817),
(20261,7,72482,-60149),
(20261,8,72986,-60085),
-- godad_swamp_monster3
(20262,0,72376,-55558),
(20262,1,72036,-54506),
(20262,2,71188,-54130),
(20262,3,70264,-54442),
(20262,4,69748,-55206),
(20262,5,69860,-56066),
(20262,6,70708,-56830),
(20262,7,71632,-56706),
(20262,8,72132,-56258),
-- godad_swamp_monster4
(20263,0,76091,-53873),
(20263,1,75447,-53721),
(20263,2,75135,-54069),
(20263,3,75047,-54749),
(20263,4,75491,-55125),
(20263,5,76171,-54993),
(20263,6,76323,-54677),
(20263,7,76339,-54281),
-- godad_swamp_monster5
(20264,0,74415,-51769),
(20264,1,74351,-51081),
(20264,2,74075,-50837),
(20264,3,74007,-50597),
(20264,4,73335,-50669),
(20264,5,72983,-51393),
(20264,6,73167,-51845),
(20264,7,73995,-52025),
-- godad_swamp_monster6
(20265,0,73198,-44860),
(20265,1,72682,-44392),
(20265,2,71766,-44416),
(20265,3,71314,-44836),
(20265,4,71378,-45248),
(20265,5,71430,-45960),
(20265,6,71850,-46264),
(20265,7,72594,-46236),
(20265,8,73034,-45800),
-- godad_swamp_monster7
(20266,0,74049,-42558),
(20266,1,73997,-41998),
(20266,2,73513,-41622),
(20266,3,73093,-41610),
(20266,4,72537,-42338),
(20266,5,72661,-42830),
(20266,6,73325,-43018),
(20266,7,73641,-42942),
-- godad_swamp_monster8
(20267,0,77309,-42410),
(20267,1,76629,-41878),
(20267,2,75557,-41990),
(20267,3,74781,-42802),
(20267,4,74745,-43802),
(20267,5,75581,-44790),
(20267,6,76761,-44770),
(20267,7,77597,-44062),
(20267,8,77641,-43006),
-- godad_swamp_monster9
(20268,0,80214,-42670),
(20268,1,80438,-42094),
(20268,2,80314,-41546),
(20268,3,79614,-41342),
(20268,4,78754,-41710),
(20268,5,78662,-42230),
(20268,6,79062,-42894),
(20268,7,79758,-43070),
(20268,8,79930,-42834),
-- godad_swamp_monster10
(20269,0,83118,-41483),
(20269,1,82686,-40931),
(20269,2,82046,-40887),
(20269,3,82050,-41079),
(20269,4,81734,-41263),
(20269,5,81610,-41879),
(20269,6,82366,-42299),
(20269,7,82758,-42155),
(20269,8,82910,-41879),
(20269,9,83086,-41823),
-- godad_swamp_monster11
(20270,0,81654,-45503),
(20270,1,81886,-45267),
(20270,2,82222,-44899),
(20270,3,82266,-44547),
(20270,4,82098,-44207),
(20270,5,81506,-44063),
(20270,6,80846,-44375),
(20270,7,80786,-44795),
(20270,8,81094,-45271),
-- godad_swamp_monster12
(20271,0,79526,-51746),
(20271,1,79638,-51098),
(20271,2,79190,-50458),
(20271,3,78398,-50694),
(20271,4,78158,-51298),
(20271,5,78570,-51934),
(20271,6,79214,-51898),
-- godad_swamp_monster13
(20272,0,83615,-50828),
(20272,1,83507,-50428),
(20272,2,83115,-50032),
(20272,3,82447,-50180),
(20272,4,82231,-50752),
(20272,5,82535,-51328),
(20272,6,82855,-51444),
(20272,7,83535,-51204),
-- godad_swamp_monster14
(20273,0,81946,-53719),
(20273,1,81398,-53767),
(20273,2,80642,-53691),
(20273,3,79554,-54587),
(20273,4,79782,-55123),
(20273,5,79886,-56423),
(20273,6,81054,-57231),
(20273,7,81802,-57111),
(20273,8,82970,-56139),
(20273,9,82738,-54227),
-- godad_swamp_monster15
(20274,0,78226,-58454),
(20274,1,78206,-58026),
(20274,2,77858,-57766),
(20274,3,77370,-57814),
(20274,4,77058,-58266),
(20274,5,77374,-58806),
(20274,6,77966,-58870),
-- godad_swamp_monster16
(20275,0,77796,-61961),
(20275,1,77836,-61333),
(20275,2,77524,-60969),
(20275,3,77100,-61041),
(20275,4,76796,-61233),
(20275,5,76728,-61865),
(20275,6,77368,-62213),
-- godad_swamp_monster17
(20276,0,82052,-59979),
(20276,1,81588,-59123),
(20276,2,80692,-59059),
(20276,3,80152,-59707),
(20276,4,80172,-60535),
(20276,5,80824,-61043),
(20276,6,81552,-60955),
-- godad_swamp_monster18
(20277,0,85533,-63207),
(20277,1,85685,-62647),
(20277,2,85249,-62239),
(20277,3,84589,-62535),
(20277,4,84549,-63151),
(20277,5,85101,-63443),
-- godad_swamp_monster19
(20278,0,89512,-60985),
(20278,1,89712,-60141),
(20278,2,88888,-59441),
(20278,3,87948,-59557),
(20278,4,87620,-60545),
(20278,5,88136,-61165),
(20278,6,88544,-61437),
-- godad_swamp_monster20
(20279,0,86034,-54576),
(20279,1,85642,-54220),
(20279,2,85238,-54224),
(20279,3,84862,-54636),
(20279,4,85082,-55248),
(20279,5,85526,-55364),
(20279,6,85950,-55020),
-- godad_swamp_monster21
(20280,0,90080,-52443),
(20280,1,90212,-51947),
(20280,2,89700,-51239),
(20280,3,88928,-51583),
(20280,4,88764,-51991),
(20280,5,89008,-52687),
(20280,6,89688,-52723),
-- godad_swamp_monster22
(20281,0,92777,-52363),
(20281,1,91981,-51967),
(20281,2,91281,-52519),
(20281,3,91229,-53299),
(20281,4,91385,-53679),
(20281,5,92405,-53943),
(20281,6,93025,-53439),
-- godad_swamp_monster23
(20282,0,95179,-52286),
(20282,1,94747,-51982),
(20282,2,94303,-52062),
(20282,3,93927,-52458),
(20282,4,94187,-53042),
(20282,5,94707,-53150),
(20282,6,95043,-53058),
(20282,7,95211,-52546),
-- godad_swamp_monster24
(20283,0,85757,-59957),
(20283,1,86073,-59585),
(20283,2,86085,-59117),
(20283,3,85761,-58801),
(20283,4,85177,-58893),
(20283,5,84905,-59329),
(20283,6,85229,-59869),
-- godad_swamp_monster25
(20284,0,81382,-63921),
(20284,1,81826,-63537),
(20284,2,81834,-62985),
(20284,3,81298,-62773),
(20284,4,80870,-62985),
(20284,5,80798,-63309),
(20284,6,80946,-63769),
-- godad_swamp_monster26
(20285,0,93421,-55220),
(20285,1,94109,-55536),
(20285,2,94601,-55164),
(20285,3,94581,-54740),
(20285,4,94185,-54360),
(20285,5,93565,-54344),
(20285,6,93365,-54760),
-- Pc Debuffs Zones
-- godad_swamp_pc1
(20300,0,71030,-60113),
(20300,1,70966,-59549),
(20300,2,70250,-59173),
(20300,3,69622,-59597),
(20300,4,69634,-60261),
(20300,5,70026,-60593),
(20300,6,70566,-60601),
-- godad_swamp_pc2
(20301,0,73522,-59473),
(20301,1,73454,-58861),
(20301,2,73194,-58629),
(20301,3,72642,-58433),
(20301,4,72110,-58501),
(20301,5,71782,-59013),
(20301,6,71922,-59817),
(20301,7,72482,-60149),
(20301,8,72986,-60085),
-- godad_swamp_pc3
(20302,0,72376,-55558),
(20302,1,72036,-54506),
(20302,2,71188,-54130),
(20302,3,70264,-54442),
(20302,4,69748,-55206),
(20302,5,69860,-56066),
(20302,6,70708,-56830),
(20302,7,71632,-56706),
(20302,8,72132,-56258),
-- godad_swamp_pc4
(20303,0,76091,-53873),
(20303,1,75447,-53721),
(20303,2,75135,-54069),
(20303,3,75047,-54749),
(20303,4,75491,-55125),
(20303,5,76171,-54993),
(20303,6,76323,-54677),
(20303,7,76339,-54281),
-- godad_swamp_pc5
(20304,0,74415,-51769),
(20304,1,74351,-51081),
(20304,2,74075,-50837),
(20304,3,74007,-50597),
(20304,4,73335,-50669),
(20304,5,72983,-51393),
(20304,6,73167,-51845),
(20304,7,73995,-52025),
-- godad_swamp_pc6
(20305,0,73198,-44860),
(20305,1,72682,-44392),
(20305,2,71766,-44416),
(20305,3,71314,-44836),
(20305,4,71378,-45248),
(20305,5,71430,-45960),
(20305,6,71850,-46264),
(20305,7,72594,-46236),
(20305,8,73034,-45800),
-- godad_swamp_pc7
(20306,0,74049,-42558),
(20306,1,73997,-41998),
(20306,2,73513,-41622),
(20306,3,73093,-41610),
(20306,4,72537,-42338),
(20306,5,72661,-42830),
(20306,6,73325,-43018),
(20306,7,73641,-42942),
-- godad_swamp_pc8
(20307,0,77309,-42410),
(20307,1,76629,-41878),
(20307,2,75557,-41990),
(20307,3,74781,-42802),
(20307,4,74745,-43802),
(20307,5,75581,-44790),
(20307,6,76761,-44770),
(20307,7,77597,-44062),
(20307,8,77641,-43006),
-- godad_swamp_pc9
(20308,0,80214,-42670),
(20308,1,80438,-42094),
(20308,2,80314,-41546),
(20308,3,79614,-41342),
(20308,4,78754,-41710),
(20308,5,78662,-42230),
(20308,6,79062,-42894),
(20308,7,79758,-43070),
(20308,8,79930,-42834),
-- godad_swamp_pc10
(20309,0,83118,-41483),
(20309,1,82686,-40931),
(20309,2,82046,-40887),
(20309,3,82050,-41079),
(20309,4,81734,-41263),
(20309,5,81610,-41879),
(20309,6,82366,-42299),
(20309,7,82758,-42155),
(20309,8,82910,-41879),
(20309,9,83086,-41823),
-- godad_swamp_pc11
(20310,0,81654,-45503),
(20310,1,81886,-45267),
(20310,2,82222,-44899),
(20310,3,82266,-44547),
(20310,4,82098,-44207),
(20310,5,81506,-44063),
(20310,6,80846,-44375),
(20310,7,80786,-44795),
(20310,8,81094,-45271),
-- godad_swamp_pc12
(20311,0,79526,-51746),
(20311,1,79638,-51098),
(20311,2,79190,-50458),
(20311,3,78398,-50694),
(20311,4,78158,-51298),
(20311,5,78570,-51934),
(20311,6,79214,-51898),
-- godad_swamp_pc13
(20312,0,83615,-50828),
(20312,1,83507,-50428),
(20312,2,83115,-50032),
(20312,3,82447,-50180),
(20312,4,82231,-50752),
(20312,5,82535,-51328),
(20312,6,82855,-51444),
(20312,7,83535,-51204),
-- godad_swamp_pc14
(20313,0,81946,-53719),
(20313,1,81398,-53767),
(20313,2,80642,-53691),
(20313,3,79554,-54587),
(20313,4,79782,-55123),
(20313,5,79886,-56423),
(20313,6,81054,-57231),
(20313,7,81802,-57111),
(20313,8,82970,-56139),
(20313,9,82738,-54227),
-- godad_swamp_pc15
(20314,0,78226,-58454),
(20314,1,78206,-58026),
(20314,2,77858,-57766),
(20314,3,77370,-57814),
(20314,4,77058,-58266),
(20314,5,77374,-58806),
(20314,6,77966,-58870),
-- godad_swamp_pc16
(20315,0,77796,-61961),
(20315,1,77836,-61333),
(20315,2,77524,-60969),
(20315,3,77100,-61041),
(20315,4,76796,-61233),
(20315,5,76728,-61865),
(20315,6,77368,-62213),
-- godad_swamp_pc17
(20316,0,82052,-59979),
(20316,1,81588,-59123),
(20316,2,80692,-59059),
(20316,3,80152,-59707),
(20316,4,80172,-60535),
(20316,5,80824,-61043),
(20316,6,81552,-60955),
-- godad_swamp_pc18
(20317,0,85533,-63207),
(20317,1,85685,-62647),
(20317,2,85249,-62239),
(20317,3,84589,-62535),
(20317,4,84549,-63151),
(20317,5,85101,-63443),
-- godad_swamp_pc19
(20318,0,89512,-60985),
(20318,1,89712,-60141),
(20318,2,88888,-59441),
(20318,3,87948,-59557),
(20318,4,87620,-60545),
(20318,5,88136,-61165),
(20318,6,88544,-61437),
-- godad_swamp_pc20
(20319,0,86034,-54576),
(20319,1,85642,-54220),
(20319,2,85238,-54224),
(20319,3,84862,-54636),
(20319,4,85082,-55248),
(20319,5,85526,-55364),
(20319,6,85950,-55020),
-- godad_swamp_pc21
(20320,0,90080,-52443),
(20320,1,90212,-51947),
(20320,2,89700,-51239),
(20320,3,88928,-51583),
(20320,4,88764,-51991),
(20320,5,89008,-52687),
(20320,6,89688,-52723),
-- godad_swamp_pc22
(20321,0,92777,-52363),
(20321,1,91981,-51967),
(20321,2,91281,-52519),
(20321,3,91229,-53299),
(20321,4,91385,-53679),
(20321,5,92405,-53943),
(20321,6,93025,-53439),
-- godad_swamp_pc23
(20322,0,95179,-52286),
(20322,1,94747,-51982),
(20322,2,94303,-52062),
(20322,3,93927,-52458),
(20322,4,94187,-53042),
(20322,5,94707,-53150),
(20322,6,95043,-53058),
(20322,7,95211,-52546),
-- godad_swamp_pc24
(20323,0,85757,-59957),
(20323,1,86073,-59585),
(20323,2,86085,-59117),
(20323,3,85761,-58801),
(20323,4,85177,-58893),
(20323,5,84905,-59329),
(20323,6,85229,-59869),
-- godad_swamp_pc25
(20324,0,81382,-63921),
(20324,1,81826,-63537),
(20324,2,81834,-62985),
(20324,3,81298,-62773),
(20324,4,80870,-62985),
(20324,5,80798,-63309),
(20324,6,80946,-63769),
-- godad_swamp_pc26
(20325,0,93421,-55220),
(20325,1,94109,-55536),
(20325,2,94601,-55164),
(20325,3,94581,-54740),
(20325,4,94185,-54360),
(20325,5,93565,-54344),
(20325,6,93365,-54760);

-- Valakas Nest (Lava Zones)
INSERT INTO `zone_vertices` VALUES
-- balakas_lava_1
(20400,0,212916,-117204),
(20400,1,213404,-117248),
(20400,2,213444,-116584),
(20400,3,213012,-116444),
(20400,4,212828,-116928),
-- balakas_lava_2
(20401,0,212304,-116608),
(20401,1,212708,-116660),
(20401,2,212820,-116300),
(20401,3,212416,-116144),
(20401,4,212140,-116336),
-- balakas_lava_3
(20402,0,214032,-116748),
(20402,1,214488,-116652),
(20402,2,214548,-116352),
(20402,3,214064,-116232),
-- balakas_lava_4
(20403,0,214424,-115452),
(20403,1,214776,-115520),
(20403,2,214944,-115248),
(20403,3,214652,-114784),
(20403,4,214460,-114824),
(20403,5,214412,-115080),
-- balakas_lava_5
(20404,0,214668,-114276),
(20404,1,214948,-113876),
(20404,2,214612,-113588),
(20404,3,214228,-113884),
(20404,4,214340,-114148),
-- balakas_lava_6
(20405,0,213916,-115660),
(20405,1,214220,-114648),
(20405,2,213392,-113112),
(20405,3,212100,-113460),
(20405,4,211292,-115164),
(20405,5,211948,-115196),
(20405,6,211976,-115628),
(20405,7,212696,-116036),
(20405,8,213200,-116136),
-- balakas_lava_7
(20406,0,210524,-114376),
(20406,1,211144,-114604),
(20406,2,211148,-114340),
(20406,3,210764,-114116),
-- balakas_lava_8
(20407,0,212276,-113016),
(20407,1,212932,-112836),
(20407,2,212860,-112600),
(20407,3,212616,-112488),
(20407,4,212188,-112604),
(20407,5,212144,-112820),
-- balakas_lava_9
(20408,0,211608,-113560),
(20408,1,211944,-113408),
(20408,2,211880,-112888),
(20408,3,211220,-112780),
(20408,4,211204,-113400),
-- balakas_lava_10
(20409,0,210596,-116292),
(20409,1,210904,-116088),
(20409,2,210972,-115760),
(20409,3,210784,-115612),
(20409,4,210308,-115904),
-- balakas_lava_11
(20410,0,211272,-117352),
(20410,1,211660,-117220),
(20410,2,211552,-117000),
(20410,3,211792,-116936),
(20410,4,212072,-116412),
(20410,5,211916,-115952),
(20410,6,211600,-115956),
(20410,7,211356,-116588),
(20410,8,210928,-116296),
(20410,9,210872,-117028),
-- balakas_lava_12
(20411,0,211528,-117312),
(20411,1,212828,-117884),
(20411,2,212756,-117068),
(20411,3,212584,-116828),
(20411,4,212300,-116812),
(20411,5,211796,-117168),
-- balakas_lava_13
(20412,0,213224,-117956),
(20412,1,213204,-117548),
(20412,2,213016,-117412),
(20412,3,212792,-117456),
(20412,4,212836,-117916),
-- balakas_lava_14
(20413,0,213440,-118004),
(20413,1,213852,-118004),
(20413,2,213728,-117728),
(20413,3,213584,-117748),
-- balakas_lava_15
(20414,0,213988,-117184),
(20414,1,213808,-117232),
(20414,2,213952,-117772),
(20414,3,213636,-118036),
(20414,4,214660,-117924),
(20414,5,214232,-117560),
(20414,6,214224,-117412),
-- balakas_lava_16
(20415,0,214564,-117840),
(20415,1,214844,-117352),
(20415,2,214616,-117172),
(20415,3,214436,-117300),
(20415,4,214304,-117592),
-- balakas_lava_17
(20416,0,215148,-117144),
(20416,1,215300,-117208),
(20416,2,215516,-116568),
(20416,3,215296,-116592),
-- balakas_lava_18
(20417,0,215356,-116304),
(20417,1,215584,-116508),
(20417,2,216472,-114732),
(20417,3,215428,-114700),
(20417,4,215204,-114556),
(20417,5,214916,-114664),
(20417,6,214932,-114920),
(20417,7,215244,-115184),
(20417,8,215116,-115408),
(20417,9,215420,-115756),
(20417,10,215296,-115852),
-- balakas_lava_19
(20418,0,214888,-114200),
(20418,1,216164,-114560),
(20418,2,216120,-113212),
(20418,3,215380,-112272),
(20418,4,214240,-113388),
(20418,5,215420,-113568),
-- balakas_lava_20
(20419,0,213792,-112592),
(20419,1,214948,-111748),
(20419,2,213932,-111516),
(20419,3,213624,-112404),
-- balakas_lava_21
(20420,0,212408,-112372),
(20420,1,212800,-111924),
(20420,2,212656,-111156),
(20420,3,211096,-111788),
(20420,4,211460,-112196),
(20420,5,211904,-112736),
(20420,6,212280,-112092),
-- balakas_lava_22
(20421,0,211120,-112784),
(20421,1,211300,-112484),
(20421,2,211116,-112048),
(20421,3,209044,-113592),
(20421,4,209900,-113652),
(20421,5,210020,-113412),
(20421,6,210812,-113544),
(20421,7,211088,-113220),
(20421,8,210720,-112888),
-- balakas_lava_23
(20422,0,209504,-113076),
(20422,1,209808,-113412),
(20422,2,210004,-112864),
(20422,3,209596,-112916),
-- balakas_lava_24
(20423,0,210400,-112656),
(20423,1,210308,-112356),
(20423,2,210152,-112260),
(20423,3,209944,-112384),
(20423,4,209804,-112308),
(20423,5,209688,-112448),
(20423,6,209804,-112564),
(20423,7,209772,-112672),
(20423,8,209968,-112884),
-- balakas_lava_25
(20424,0,210032,-112148),
(20424,1,210392,-112060),
(20424,2,210104,-111444),
(20424,3,209496,-112008),
-- balakas_lava_26
(20425,0,211096,-112400),
(20425,1,211436,-111804),
(20425,2,210812,-111712),
(20425,3,210628,-111792),
(20425,4,210600,-112004),
-- balakas_lava_27
(20426,0,210552,-111368),
(20426,1,210904,-111412),
(20426,2,210864,-111236),
(20426,3,210492,-111100),
(20426,4,210100,-111432),
(20426,5,210408,-111488),
-- balakas_lava_28
(20427,0,212136,-110836),
(20427,1,212552,-110896),
(20427,2,212704,-110776),
(20427,3,212724,-110460),
(20427,4,212064,-110576),
-- balakas_lava_29
(20428,0,212620,-111604),
(20428,1,213060,-111604),
(20428,2,212740,-111304),
(20428,3,212436,-111620),
-- balakas_lava_30
(20429,0,213416,-110968),
(20429,1,213716,-110772),
(20429,2,213752,-110376),
(20429,3,213356,-110388),
(20429,4,213328,-110760),
-- balakas_lava_31
(20430,0,214228,-111556),
(20430,1,214196,-111120),
(20430,2,213972,-111020),
(20430,3,213624,-111248),
-- balakas_lava_32
(20431,0,215120,-112132),
(20431,1,215460,-112124),
(20431,2,215564,-111836),
(20431,3,215376,-111736),
(20431,4,214924,-111792),
-- balakas_lava_33
(20432,0,215564,-111380),
(20432,1,215764,-111380),
(20432,2,215764,-111180),
(20432,3,215564,-111180),
-- balakas_lava_34
(20433,0,215776,-112812),
(20433,1,216348,-112536),
(20433,2,216268,-112392),
(20433,3,215684,-112660),
-- balakas_lava_35
(20434,0,216040,-114340),
(20434,1,216868,-114436),
(20434,2,216648,-112948),
(20434,3,216148,-113132),
(20434,4,215996,-113324),
-- balakas_lava_36
(20435,0,216136,-115280),
(20435,1,216760,-115372),
(20435,2,216880,-114792),
(20435,3,216636,-114964),
(20435,4,216428,-114976),
(20435,5,216364,-114832),
(20435,6,216068,-114768),
-- balakas_lava_37
(20436,0,215964,-115796),
(20436,1,216592,-115892),
(20436,2,216592,-115580),
(20436,3,216032,-115452),
-- balakas_lava_38
(20437,0,216040,-117792),
(20437,1,216088,-117536),
(20437,2,215972,-117352),
(20437,3,215812,-117256),
(20437,4,215600,-117324),
(20437,5,215692,-117736),
-- balakas_lava_39
(20438,0,214896,-117908),
(20438,1,215156,-118020),
(20438,2,215396,-117668),
(20438,3,215204,-117084),
(20438,4,214744,-117508),
-- balakas_lava_40
(20439,0,214468,-118700),
(20439,1,214748,-118780),
(20439,2,214484,-117908),
(20439,3,214188,-118000),
-- balakas_lava_41
(20440,0,213396,-118452),
(20440,1,213652,-118588),
(20440,2,213832,-118492),
(20440,3,213776,-118092),
(20440,4,213312,-118056),
-- balakas_lava_42
(20441,0,212684,-118456),
(20441,1,213148,-118436),
(20441,2,213168,-118308),
(20441,3,213008,-118204),
(20441,4,212668,-118300),
-- balakas_lava_43
(20442,0,212156,-118020),
(20442,1,212424,-118208),
(20442,2,213256,-118080),
(20442,3,211416,-117244),
(20442,4,211676,-118104),
(20442,5,211880,-118132),
-- balakas_lava_44
(20443,0,210792,-117952),
(20443,1,211464,-117376),
(20443,2,210832,-116852),
(20443,3,210296,-117456),
-- balakas_lava_45
(20444,0,209932,-116124),
(20444,1,210112,-116340),
(20444,2,210756,-116432),
(20444,3,210080,-115704),
-- balakas_lava_46
(20445,0,209604,-115832),
(20445,1,209676,-115672),
(20445,2,209480,-115472),
(20445,3,209064,-115396),
(20445,4,209064,-116060),
-- balakas_lava_47
(20446,0,209596,-114804),
(20446,1,209880,-114812),
(20446,2,209852,-114156),
(20446,3,209528,-114576),
-- balakas_lava_48
(20447,0,209452,-113908),
(20447,1,209720,-114032),
(20447,2,209648,-113588),
(20447,3,209452,-113708),
-- balakas_lava_49
(20448,0,211652,-111708),
(20448,1,212000,-111640),
(20448,2,211652,-110812),
(20448,3,211420,-110828);

-- Emerald Square Zone
INSERT INTO `zone_vertices` VALUES
-- first secret room
(20105,0,144175,142396),
(20105,1,144251,142588),
-- second secret room
(20106,0,147400,143631),
(20106,1,147484,143828),
-- third secret room
(20107,0,149396,143473),
(20107,1,149559,143584);

-- Pailaka (Forgotten Temple)
INSERT INTO `zone_vertices` VALUES
(20108,0,-62840,178808),
(20108,1,-62840,184568),
(20108,2,-60792,184568),
(20108,3,-60792,188792),
(20108,4,-57976,191224),
(20108,5,-53000,190840),
(20108,6,-52360,190200),
(20108,7,-52360,178808);

-- Pagan's Mark Zone
INSERT INTO `zone_vertices` VALUES
(30100,0,-16100,-36620),
(30100,1,-16600,-36620),
(30100,2,-16600,-36925),
(30100,3,-16100,-36925);

-- Primeval Isle Zones (vertices, min Z & Max Z are estimated)
INSERT INTO `zone_vertices` VALUES
-- Primeval Isle (Peace Zone)
(40000,0,10395,-27125),
(40000,1,9596,-25086),
(40000,2,9244,-24324),
(40000,3,9664,-22826),
(40000,4,10505,-22112),
(40000,5,11044,-22266),
(40000,6,11188,-22438),
(40000,7,11472,-22602),
(40000,8,11905,-22790),
(40000,9,12584,-23520),
(40000,10,12604,-24094),
(40000,11,12298,-25084),
(40000,12,10530,-27125),
-- Primeval Isle (Town Zone)
(40001,0,0,-32768),
(40001,1,32678,0);

-- Hellbound Zones (vertices, min Z & Max Z are estimated)
INSERT INTO `zone_vertices` VALUES
-- Hellbound Desert
(40100,0,-22850,251314),
(40100,1,-23552,255186),
(40100,2,-24061,257536),
(40100,3,-20611,259200),
(40100,4,-15865,259320),
(40100,5,-6788,260092),
(40100,6,-1922,257918),
(40100,7,254,248450),
(40100,8,-14208,248580),
-- Hellbound (No Landing Zone)
(40101,0,-32768,229376),
(40101,1,32768,229376),
(40101,2,32768,262143),
(40101,3,-32768,262143),
-- Hellbound (No Summon Friend Zone)
(40102,0,-32768,229376),
(40102,1,32768,229376),
(40102,2,32768,262143),
(40102,3,-32768,262143),
-- Hellbound Lake 1
(40103,0,-22387,248748),
(40103,1,-22494,249598),
(40103,2,-21752,250328),
(40103,3,-20424,250188),
(40103,4,-19713,249439),
(40103,5,-20556,247955),
-- Hellbound Lake 2
(40104,0,9467,251396),
(40104,1,7166,247564),
(40104,2,4355,250111),
(40104,3,5931,253699),
(40104,4,8215,254069);
-- Hellbound (Town Zone)
-- (40105,0,-32768,229376),
-- (40105,1,32768,229376),
-- (40105,2,32768,262143),
-- (40105,3,-32768,262143);

-- Rune Castle (Water Zones) (vertices, min Z & Max Z are estimated)
INSERT INTO `zone_vertices` VALUES
(40500,0,17407,-48513),
(40500,1,17409,-47488),
(40500,2,16640,-46718),
(40500,3,15743,-46718),
(40500,4,15615,-46850),
(40500,5,15615,-47105),
(40500,6,15998,-48384),
(40500,7,16126,-48640),
(40500,8,16255,-48770),
(40500,9,17154,-48771),
(40501,0,17408,-49663),
(40501,1,17280,-49535),
(40501,2,16254,-49533),
(40501,3,16126,-49663),
(40501,4,15998,-49920),
(40501,5,15616,-51068),
(40501,6,15614,-51327),
(40501,7,15743,-51457),
(40501,8,16640,-51458),
(40501,9,17409,-50687);

-- SSQ Main Event
INSERT INTO `zone_vertices` VALUES
-- Oracle of Dusk
-- ssq_main_event_17_20_01
(50000,0,-79956,84556),
(50000,1,-79832,84620),
(50000,2,-79824,84772),
(50000,3,-79956,84844),
(50000,4,-80080,84772),
(50000,5,-80076,84620),
-- ssq_main_event_17_20_04
(50001,0,-76936,85164),
(50001,1,-76820,85232),
(50001,2,-76816,85380),
(50001,3,-76948,85444),
(50001,4,-77068,85376),
(50001,5,-77068,85236),
-- ssq_main_event_17_20_05
(50002,0,-74924,87012),
(50002,1,-74784,87008),
(50002,2,-74712,87132),
(50002,3,-74780,87256),
(50002,4,-74924,87260),
(50002,5,-75000,87140),
-- ssq_main_event_17_20_03
(50003,0,-77200,88820),
(50003,1,-77076,88896),
(50003,2,-77076,89040),
(50003,3,-77204,89108),
(50003,4,-77328,89044),
(50003,5,-77328,88892),
-- ssq_main_event_17_20_02
(50004,0,-80204,88220),
(50004,1,-80080,88288),
(50004,2,-80080,88428),
(50004,3,-80208,88504),
(50004,4,-80336,88428),
(50004,5,-80328,88292),
-- Oracle of Dawn
-- ssq_main_event_17_21_01
(50005,0,-78796,109452),
(50005,1,-78804,109608),
(50005,2,-78924,109672),
(50005,3,-79056,109600),
(50005,4,-79056,109456),
(50005,5,-78932,109380),
-- ssq_main_event_17_21_02
(50006,0,-75920,109992),
(50006,1,-75792,110068),
(50006,2,-75792,110220),
(50006,3,-75912,110288),
(50006,4,-76048,110212),
(50006,5,-76044,110068),
-- ssq_main_event_17_21_05
(50007,0,-73900,111844),
(50007,1,-73752,111840),
(50007,2,-73688,111976),
(50007,3,-73760,112092),
(50007,4,-73904,112092),
(50007,5,-73976,111968),
-- ssq_main_event_17_21_03
(50008,0,-76172,113656),
(50008,1,-76052,113728),
(50008,2,-76048,113872),
(50008,3,-76172,113944),
(50008,4,-76308,113876),
(50008,5,-76304,113728),
-- ssq_main_event_17_21_04
(50009,0,-79184,113040),
(50009,1,-79060,113116),
(50009,2,-79052,113268),
(50009,3,-79184,113336),
(50009,4,-79304,113260),
(50009,5,-79304,113116),
-- Oracle of Dusk (Peace Zone)
-- ssq_peace_1720_01
(50010,0,-78118,86296),
(50010,1,-75860,86294),
(50010,2,-75853,87965),
(50010,3,-78156,87967),
-- ssq_peace_1720_02
(50011,0,-81169,85693),
(50011,1,-78118,85690),
(50011,2,-78134,87364),
(50011,3,-81187,87364),
-- ssq_peace_1720_03
(50012,0,-81549,86361),
(50012,1,-80995,86367),
(50012,2,-80995,86688),
(50012,3,-81549,86688),
-- Oracle of Dawn (Peace Zone)
-- ssq_peace_1721_01
(50013,0,-77077,111140),
(50013,1,-74838,111140),
(50013,2,-74842,112806),
(50013,3,-77104,112779),
-- ssq_peace_1721_02
(50014,0,-80075,110530),
(50014,1,-77066,110552),
(50014,2,-77092,112188),
(50014,3,-80089,112184),
-- ssq_peace_1721_03
(50015,0,-80536,111192),
(50015,1,-79984,111196),
(50015,2,-79984,111517),
(50015,3,-80532,111517),
-- Oracle of Dusk (No Store Zone)
-- ssq_peace_1720_01
(50016,0,-78118,86296),
(50016,1,-75860,86294),
(50016,2,-75853,87965),
(50016,3,-78156,87967),
-- ssq_peace_1720_02
(50017,0,-81169,85693),
(50017,1,-78118,85690),
(50017,2,-78134,87364),
(50017,3,-81187,87364),
-- ssq_peace_1720_03
(50018,0,-81549,86361),
(50018,1,-80995,86367),
(50018,2,-80995,86688),
(50018,3,-81549,86688),
-- Oracle of Dawn (No Store Zone)
-- ssq_peace_1721_01
(50019,0,-77077,111140),
(50019,1,-74838,111140),
(50019,2,-74842,112806),
(50019,3,-77104,112779),
-- ssq_peace_1721_02
(50020,0,-80075,110530),
(50020,1,-77066,110552),
(50020,2,-77092,112188),
(50020,3,-80089,112184),
-- ssq_peace_1721_03
(50021,0,-80536,111192),
(50021,1,-79984,111196),
(50021,2,-79984,111517),
(50021,3,-80532,111517);

-- Ivory Tower (Peace Zone) -->
INSERT INTO `zone_vertices` VALUES
-- ivory_tower_peace1
(50400,0,86094,16382),
(50400,1,85888,16744),
(50400,2,85510,16968),
(50400,3,85139,16966),
(50400,4,84767,16736),
(50400,5,84576,16394),
(50400,6,84580,15977),
(50400,7,84783,15631),
(50400,8,85143,15417),
(50400,9,85499,15403),
(50400,10,85886,15642),
(50400,11,86049,15990);

-- Dimensional Rift (Peace Zone)
INSERT INTO `zone_vertices` VALUES
-- space_of_dimension_peace1
(50500,0,-115441,-182134),
(50500,1,-114106,-182134),
(50500,2,-114106,-178021),
(50500,3,-115476,-178021);

-- Castle NoHq Zones
-- Gludio Castle
INSERT INTO `zone_vertices` VALUES
(112000,0,-19576,106760),
(112000,1,-17288,106760),
(112000,2,-16520,107528),
(112000,3,-16520,108664),
(112000,4,-15752,108664),
(112000,5,-15752,110072),
(112000,6,-16264,110072),
(112000,7,-16264,112376),
(112000,8,-17800,113912),
(112000,9,-18824,113912),
(112000,10,-20232,112504),
(112000,11,-20232,108936),
(112000,12,-19576,108280),
(112000,13,-19576,106760);

-- Dion Castle
INSERT INTO `zone_vertices` VALUES
(112010,0,21240,162936),
(112010,1,23544,162936),
(112010,2,23544,161416),
(112010,3,24184,160776),
(112010,4,24184,157304),
(112010,6,22664,155784),
(112010,7,21752,155784),
(112010,8,20232,157304),
(112010,9,20232,159608),
(112010,10,19592,160248),
(112010,11,19592,160648),
(112010,12,20104,161160),
(112010,13,20472,161160),
(112010,14,20472,162168),
(112010,15,21240,162936);

-- Giran Castle
INSERT INTO `zone_vertices` VALUES
(112020,0,113544,142984),
(112020,1,116856,142984),
(112020,2,117496,143624),
(112020,3,119160,143624),
(112020,4,119160,145784),
(112020,5,118392,146552),
(112020,6,117240,146552),
(112020,7,117240,147448),
(112020,8,115976,147448),
(112020,9,115976,146824),
(112020,10,113672,146824),
(112020,11,112008,145672),
(112020,12,112008,144520),
(112020,13,113544,142984);

-- Oren Castle
INSERT INTO `zone_vertices` VALUES 
(112030,0,79608,35080),
(112030,1,83080,35080),
(112030,2,83592,35592),
(112030,3,85240,35592),
(112030,4,85240,37896),
(112030,5,84360,38776),
(112030,6,83336,38776),
(112030,7,83336,39544),
(112030,8,81928,39544),
(112030,9,81928,39048),
(112030,10,79496,39048),
(112030,11,77960,37512),
(112030,12,77960,36728),
(112030,13,79608,35080);

-- Aden Castle
INSERT INTO `zone_vertices` VALUES 
(112040,0,144200,9900),
(112040,1,144200,910),
(112040,2,150670,910),
(112040,3,150670,9900),
(112040,4,144200,9900);

-- Innadril Castle
INSERT INTO `zone_vertices` VALUES 
(112050,0,115832,244488),
(112050,1,116488,244488),
(112050,2,118136,246136),
(112050,3,118136,249480),
(112050,4,117496,250120),
(112050,5,117496,251768),
(112050,6,115192,251768),
(112050,7,114424,251000),
(112050,8,114424,249848),
(112050,9,113544,249848),
(112050,10,113544,248440),
(112050,11,114184,248440),
(112050,12,114184,246136),
(112050,13,115832,244488);

-- Goddard Castle
INSERT INTO `zone_vertices` VALUES 
(112060,0,151864,-48404),
(112060,1,150145,-45508),
(112060,2,147512,-44268),
(112060,3,144518,-45533),
(112060,4,143918,-49774),
(112060,5,144405,-52084),
(112060,6,147751,-52301),
(112060,7,150746,-52809),
(112060,8,151864,-48404);

-- Rune Castle
INSERT INTO `zone_vertices` VALUES 
(112070,0,18808,-49656),
(112070,1,18808,-48648),
(112070,2,16904,-45832),
(112070,3,4488,-45832),
(112070,4,4488,-52742),
(112070,5,17016,-52742),
(112070,6,18808,-49656);

-- Schuttgart Castle
INSERT INTO `zone_vertices` VALUES 
(112080,0,80995,-153334),
(112080,1,80808,-150137),
(112080,2,79228,-148694),
(112080,3,76451,-148399),
(112080,4,74703,-149543),
(112080,5,73718,-153342),
(112080,6,75632,-156376),
(112080,7,77635,-155680),
(112080,8,79985,-155849),
(112080,9,80995,-153334);