/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2ManufactureList;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OfflineTradersTable {
    private static Logger _log = Logger.getLogger(OfflineTradersTable.class.getName());
    private static final String SAVE_OFFLINE_STATUS = "INSERT INTO character_offline_trade (`charId`,`time`,`type`,`title`) VALUES (?,?,?,?)";
    private static final String SAVE_ITEMS = "INSERT INTO character_offline_trade_items (`charId`,`item`,`count`,`price`) VALUES (?,?,?,?)";
    private static final String CLEAR_OFFLINE_TABLE = "DELETE FROM character_offline_trade";
    private static final String CLEAR_OFFLINE_TABLE_ITEMS = "DELETE FROM character_offline_trade_items";
    private static final String LOAD_OFFLINE_STATUS = "SELECT * FROM character_offline_trade";
    private static final String LOAD_OFFLINE_ITEMS = "SELECT * FROM character_offline_trade_items WHERE charId = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeOffliners() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement stm = con.prepareStatement(CLEAR_OFFLINE_TABLE);
            stm.execute();
            stm.close();
            stm = con.prepareStatement(CLEAR_OFFLINE_TABLE_ITEMS);
            stm.execute();
            stm.close();
            con.setAutoCommit(false);
            stm = con.prepareStatement(SAVE_OFFLINE_STATUS);
            PreparedStatement stm_items = con.prepareStatement(SAVE_ITEMS);
            block12: for (L2PcInstance pc : L2World.getInstance().getAllPlayers().values()) {
                try {
                    if (pc.getPrivateStoreType() == 0 || pc.getClient() != null && !pc.getClient().isDetached()) continue;
                    stm.setInt(1, pc.getObjectId());
                    stm.setLong(2, pc.getOfflineStartTime());
                    stm.setInt(3, pc.getPrivateStoreType());
                    String title = null;
                    switch (pc.getPrivateStoreType()) {
                        case 3: {
                            if (!Config.OFFLINE_TRADE_ENABLE) continue block12;
                            title = pc.getBuyList().getTitle();
                            for (TradeList.TradeItem i : pc.getBuyList().getItems()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, i.getItem().getItemId());
                                stm_items.setLong(3, i.getCount());
                                stm_items.setLong(4, i.getPrice());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                        case 1: 
                        case 8: {
                            if (!Config.OFFLINE_TRADE_ENABLE) continue block12;
                            title = pc.getSellList().getTitle();
                            for (TradeList.TradeItem i : pc.getSellList().getItems()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, i.getObjectId());
                                stm_items.setLong(3, i.getCount());
                                stm_items.setLong(4, i.getPrice());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                        case 5: {
                            if (!Config.OFFLINE_CRAFT_ENABLE) continue block12;
                            title = pc.getCreateList().getStoreName();
                            for (L2ManufactureItem i : pc.getCreateList().getList()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, i.getRecipeId());
                                stm_items.setLong(3, 0L);
                                stm_items.setLong(4, i.getCost());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                    }
                    stm.setString(4, title);
                    stm.executeUpdate();
                    stm.clearParameters();
                    con.commit();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "OfflineTradersTable[storeTradeItems()]: Error while saving offline trader: " + pc.getObjectId() + " " + e, e);
                }
            }
            stm.close();
            stm_items.close();
            _log.info("Offline traders stored.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "OfflineTradersTable[storeTradeItems()]: Error while saving offline traders: " + e, e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreOfflineTraders() {
        _log.info("Loading offline traders...");
        Connection con = null;
        int nTraders = 0;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement stm = con.prepareStatement(LOAD_OFFLINE_STATUS);
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                int type;
                long time = rs.getLong("time");
                if (Config.OFFLINE_MAX_DAYS > 0) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(time);
                    cal.add(6, Config.OFFLINE_MAX_DAYS);
                    if (cal.getTimeInMillis() <= System.currentTimeMillis()) continue;
                }
                if ((type = rs.getInt("type")) == 0) continue;
                L2PcInstance player = null;
                try {
                    L2GameClient client = new L2GameClient(null);
                    client.setDetached(true);
                    player = L2PcInstance.load(rs.getInt("charId"));
                    client.setActiveChar(player);
                    client.setAccountName(player.getAccountNamePlayer());
                    client.setState(L2GameClient.GameClientState.IN_GAME);
                    player.setClient(client);
                    player.setOfflineStartTime(time);
                    player.spawnMe(player.getX(), player.getY(), player.getZ());
                    LoginServerThread.getInstance().addGameServerLogin(player.getAccountName(), client);
                    PreparedStatement stm_items = con.prepareStatement(LOAD_OFFLINE_ITEMS);
                    stm_items.setInt(1, player.getObjectId());
                    ResultSet items = stm_items.executeQuery();
                    switch (type) {
                        case 3: {
                            while (items.next()) {
                                if (player.getBuyList().addItemByItemId(items.getInt(2), items.getLong(3), items.getLong(4)) != null) continue;
                                throw new NullPointerException();
                            }
                            player.getBuyList().setTitle(rs.getString("title"));
                            break;
                        }
                        case 1: 
                        case 8: {
                            while (items.next()) {
                                if (player.getSellList().addItem(items.getInt(2), items.getLong(3), items.getLong(4)) != null) continue;
                                throw new NullPointerException();
                            }
                            player.getSellList().setTitle(rs.getString("title"));
                            player.getSellList().setPackaged(type == 8);
                            break;
                        }
                        case 5: {
                            L2ManufactureList createList = new L2ManufactureList();
                            while (items.next()) {
                                createList.add(new L2ManufactureItem(items.getInt(2), items.getLong(4)));
                            }
                            player.setCreateList(createList);
                            player.getCreateList().setStoreName(rs.getString("title"));
                        }
                    }
                    items.close();
                    stm_items.close();
                    player.sitDown();
                    if (Config.OFFLINE_SET_NAME_COLOR) {
                        player.getAppearance().setNameColor(Config.OFFLINE_NAME_COLOR);
                    }
                    player.setPrivateStoreType(type);
                    player.setOnlineStatus(true);
                    player.restoreEffects();
                    player.broadcastUserInfo();
                    ++nTraders;
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "OfflineTradersTable[loadOffliners()]: Error loading trader: " + player, e);
                    if (player == null) continue;
                    player.logout();
                }
            }
            rs.close();
            stm.close();
            _log.info("Loaded: " + nTraders + " offline trader(s)");
            stm = con.prepareStatement(CLEAR_OFFLINE_TABLE);
            stm.execute();
            stm.close();
            stm = con.prepareStatement(CLEAR_OFFLINE_TABLE_ITEMS);
            stm.execute();
            stm.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "OfflineTradersTable[loadOffliners()]: Error while loading offline traders: ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }
}

