/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.instance.L2FortBallistaInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class FortSiegeGuardManager {
    private static final Logger _log = Logger.getLogger(FortSiegeGuardManager.class.getName());
    private Fort _fort;
    protected FastMap<Integer, FastList<L2Spawn>> _siegeGuards = new FastMap();
    protected FastList<L2Spawn> _siegeGuardsSpawns;

    public FortSiegeGuardManager(Fort fort) {
        this._fort = fort;
    }

    public void spawnSiegeGuard() {
        try {
            FastList monsterList = (FastList)this.getSiegeGuardSpawn().get((Object)this.getFort().getFortId());
            if (monsterList != null) {
                for (L2Spawn spawnDat : monsterList) {
                    spawnDat.doSpawn();
                    if (spawnDat.getLastSpawn() instanceof L2FortBallistaInstance) {
                        spawnDat.stopRespawn();
                        continue;
                    }
                    spawnDat.startRespawn();
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error spawning siege guards for fort " + this.getFort().getName() + ":" + e.getMessage(), e);
        }
    }

    public void unspawnSiegeGuard() {
        try {
            FastList monsterList = (FastList)this.getSiegeGuardSpawn().get((Object)this.getFort().getFortId());
            if (monsterList != null) {
                for (L2Spawn spawnDat : monsterList) {
                    spawnDat.stopRespawn();
                    if (spawnDat.getLastSpawn() == null) continue;
                    spawnDat.getLastSpawn().doDie(spawnDat.getLastSpawn());
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error unspawning siege guards for fort " + this.getFort().getName() + ":" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSiegeGuard() {
        this._siegeGuards.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM fort_siege_guards Where fortId = ? ");
            statement.setInt(1, this.getFort().getFortId());
            ResultSet rs = statement.executeQuery();
            this._siegeGuardsSpawns = new FastList();
            while (rs.next()) {
                int fortId = rs.getInt("fortId");
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rs.getInt("npcId"));
                if (template1 != null) {
                    L2Spawn spawn1 = new L2Spawn(template1);
                    spawn1.setId(rs.getInt("id"));
                    spawn1.setAmount(1);
                    spawn1.setLocx(rs.getInt("x"));
                    spawn1.setLocy(rs.getInt("y"));
                    spawn1.setLocz(rs.getInt("z"));
                    spawn1.setHeading(rs.getInt("heading"));
                    spawn1.setRespawnDelay(rs.getInt("respawnDelay"));
                    spawn1.setLocation(0);
                    this._siegeGuardsSpawns.add((Object)spawn1);
                } else {
                    _log.warning("Missing npc data in npc table for id: " + rs.getInt("npcId"));
                }
                this._siegeGuards.put((Object)fortId, this._siegeGuardsSpawns);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error loading siege guard for fort " + this.getFort().getName() + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final Fort getFort() {
        return this._fort;
    }

    public final FastMap<Integer, FastList<L2Spawn>> getSiegeGuardSpawn() {
        return this._siegeGuards;
    }
}

