/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.network.serverpackets.FlyToLocation;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.util.Util;

public class EffectWarp
extends L2Effect {
    private int x;
    private int y;
    private int z;
    private L2Character _actor;

    public EffectWarp(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.WARP;
    }

    @Override
    public boolean onStart() {
        L2Character l2Character = this._actor = this.isSelfEffect() ? this.getEffector() : this.getEffected();
        if (this._actor.isMovementDisabled()) {
            return false;
        }
        int _radius = this.getSkill().getFlyRadius();
        double angle = Util.convertHeadingToDegree(this._actor.getHeading());
        double radian = Math.toRadians(angle);
        double course = Math.toRadians(this.getSkill().getFlyCourse());
        int x1 = (int)(Math.cos(Math.PI + radian + course) * (double)_radius);
        int y1 = (int)(Math.sin(Math.PI + radian + course) * (double)_radius);
        this.x = this._actor.getX() + x1;
        this.y = this._actor.getY() + y1;
        this.z = this._actor.getZ();
        if (Config.GEODATA > 0) {
            Location destiny = GeoData.getInstance().moveCheck(this._actor.getX(), this._actor.getY(), this._actor.getZ(), this.x, this.y, this.z, this._actor.getInstanceId());
            this.x = destiny.getX();
            this.y = destiny.getY();
            this.z = destiny.getZ();
        }
        this._actor.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this._actor.broadcastPacket(new FlyToLocation(this._actor, this.x, this.y, this.z, FlyToLocation.FlyType.DUMMY));
        this._actor.abortAttack();
        this._actor.abortCast();
        this._actor.setXYZ(this.x, this.y, this.z);
        this._actor.broadcastPacket(new ValidateLocation(this._actor));
        return true;
    }

    @Override
    public boolean onActionTime() {
        return false;
    }
}

