/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.AutoAttackStop;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class AttackStanceTaskManager {
    protected static final Logger _log = Logger.getLogger(AttackStanceTaskManager.class.getName());
    protected Map<L2Character, Long> _attackStanceTasks = new FastMap().shared();

    private AttackStanceTaskManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new FightModeScheduler(), 0L, 1000L);
    }

    public static AttackStanceTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    public void addAttackStanceTask(L2Character actor) {
        if (actor instanceof L2Summon) {
            L2Summon summon = (L2Summon)actor;
            actor = summon.getOwner();
        }
        if (actor instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)actor;
            for (L2CubicInstance cubic : player.getCubics().values()) {
                if (cubic.getId() == 3) continue;
                cubic.doAction();
            }
        }
        this._attackStanceTasks.put(actor, System.currentTimeMillis());
    }

    public void removeAttackStanceTask(L2Character actor) {
        if (actor instanceof L2Summon) {
            L2Summon summon = (L2Summon)actor;
            actor = summon.getOwner();
        }
        this._attackStanceTasks.remove(actor);
    }

    public boolean getAttackStanceTask(L2Character actor) {
        if (actor instanceof L2Summon) {
            L2Summon summon = (L2Summon)actor;
            actor = summon.getOwner();
        }
        return this._attackStanceTasks.containsKey(actor);
    }

    private static class SingletonHolder {
        protected static final AttackStanceTaskManager _instance = new AttackStanceTaskManager();

        private SingletonHolder() {
        }
    }

    private class FightModeScheduler
    implements Runnable {
        protected FightModeScheduler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                Long current = System.currentTimeMillis();
                try {
                    if (AttackStanceTaskManager.this._attackStanceTasks == null) break block7;
                    FightModeScheduler fightModeScheduler = this;
                    synchronized (fightModeScheduler) {
                        for (L2Character actor : AttackStanceTaskManager.this._attackStanceTasks.keySet()) {
                            if (current - AttackStanceTaskManager.this._attackStanceTasks.get(actor) <= 15000L) continue;
                            actor.broadcastPacket(new AutoAttackStop(actor.getObjectId()));
                            if (actor instanceof L2PcInstance && ((L2PcInstance)actor).getPet() != null) {
                                ((L2PcInstance)actor).getPet().broadcastPacket(new AutoAttackStop(((L2PcInstance)actor).getPet().getObjectId()));
                            }
                            actor.getAI().setAutoAttacking(false);
                            AttackStanceTaskManager.this._attackStanceTasks.remove(actor);
                        }
                    }
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Error in FightModeScheduler: " + e.getMessage(), e);
                }
            }
        }
    }
}

