/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.util;

import com.ziclix.python.sql.util.QueueClosedException;
import java.util.LinkedList;

public class Queue {
    protected boolean closed = false;
    protected LinkedList queue;
    protected int capacity;
    protected int threshold;

    public Queue() {
        this(0);
    }

    public Queue(int n) {
        this.capacity = n;
        this.queue = new LinkedList();
        this.threshold = (int)((float)this.capacity * 0.75f);
    }

    public synchronized void enqueue(Object object) throws InterruptedException {
        if (this.closed) {
            throw new QueueClosedException();
        }
        this.queue.addLast(object);
        this.notify();
        while (this.capacity > 0 && this.queue.size() >= this.capacity) {
            this.wait();
            if (!this.closed) continue;
            throw new QueueClosedException();
        }
    }

    public synchronized Object dequeue() throws InterruptedException {
        while (this.queue.size() <= 0) {
            this.wait();
            if (!this.closed) continue;
            throw new QueueClosedException();
        }
        Object e = this.queue.removeFirst();
        if (this.queue.size() < this.threshold) {
            this.notify();
        }
        return e;
    }

    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }
}

