/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.PledgeInfo;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestPledgeInfo
extends L2GameClientPacket {
    private static final String _C__66_REQUESTPLEDGEINFO = "[C] 66 RequestPledgeInfo";
    private static Logger _log = Logger.getLogger(RequestPledgeInfo.class.getName());
    private int _clanId;

    @Override
    protected void readImpl() {
        this._clanId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar;
        if (Config.DEBUG) {
            _log.log(Level.FINE, "Info for clan " + this._clanId + " requested");
        }
        if ((activeChar = ((L2GameClient)this.getClient()).getActiveChar()) == null) {
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClan(this._clanId);
        if (clan == null) {
            if (Config.DEBUG) {
                _log.warning("Clan data for clanId " + this._clanId + " is missing for player " + activeChar.getName());
            }
            return;
        }
        PledgeInfo pc = new PledgeInfo(clan);
        activeChar.sendPacket(pc);
    }

    @Override
    public String getType() {
        return _C__66_REQUESTPLEDGEINFO;
    }
}

