/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.cache.CrestCache;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestSetAllyCrest
extends L2GameClientPacket {
    private static final String _C__87_REQUESTSETALLYCREST = "[C] 87 RequestSetAllyCrest";
    static Logger _log = Logger.getLogger(RequestSetAllyCrest.class.getName());
    private int _length;
    private byte[] _data;

    @Override
    protected void readImpl() {
        this._length = this.readD();
        if (this._length > 192) {
            return;
        }
        this._data = new byte[this._length];
        this.readB(this._data);
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._length < 0) {
            activeChar.sendMessage("File transfer error.");
            return;
        }
        if (this._length > 192) {
            activeChar.sendMessage("The ally crest file size was too big (max 192 bytes).");
            return;
        }
        if (activeChar.getAllyId() != 0) {
            L2Clan leaderclan = ClanTable.getInstance().getClan(activeChar.getAllyId());
            if (activeChar.getClanId() != leaderclan.getClanId() || !activeChar.isClanLeader()) {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER));
                return;
            }
            boolean remove = false;
            if (this._length == 0 || this._data.length == 0) {
                remove = true;
            }
            int newId = 0;
            if (!remove) {
                newId = IdFactory.getInstance().getNextId();
            }
            if (!remove && !CrestCache.getInstance().saveAllyCrest(newId, this._data)) {
                _log.log(Level.INFO, "Error saving crest for ally " + leaderclan.getAllyName() + " [" + leaderclan.getAllyId() + "]");
                return;
            }
            leaderclan.changeAllyCrest(newId, false);
        }
    }

    @Override
    public String getType() {
        return _C__87_REQUESTSETALLYCREST;
    }
}

