/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.actor.instance.L2MinionInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;

public class MinionList {
    private static Logger _log = Logger.getLogger(L2MonsterInstance.class.getName());
    private final List<L2MinionInstance> minionReferences;
    protected FastMap<Long, Integer> _respawnTasks = new FastMap().shared();
    private final L2MonsterInstance master;

    public MinionList(L2MonsterInstance pMaster) {
        this.minionReferences = new FastList();
        this.master = pMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countSpawnedMinions() {
        List<L2MinionInstance> list = this.minionReferences;
        synchronized (list) {
            return this.minionReferences.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countSpawnedMinionsById(int minionId) {
        int count = 0;
        List<L2MinionInstance> list = this.minionReferences;
        synchronized (list) {
            for (L2MinionInstance minion : this.getSpawnedMinions()) {
                if (minion.getNpcId() != minionId) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean hasMinions() {
        return !this.getSpawnedMinions().isEmpty();
    }

    public List<L2MinionInstance> getSpawnedMinions() {
        return this.minionReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpawnedMinion(L2MinionInstance minion) {
        List<L2MinionInstance> list = this.minionReferences;
        synchronized (list) {
            this.minionReferences.add(minion);
        }
    }

    public int lazyCountSpawnedMinionsGroups() {
        FastSet seenGroups = new FastSet();
        for (L2MinionInstance minion : this.getSpawnedMinions()) {
            if (minion == null) continue;
            seenGroups.add(minion.getNpcId());
        }
        return seenGroups.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpawnedMinion(L2MinionInstance minion) {
        List<L2MinionInstance> list = this.minionReferences;
        synchronized (list) {
            this.minionReferences.remove(minion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveMinionToRespawnList(L2MinionInstance minion) {
        Long current = System.currentTimeMillis();
        List<L2MinionInstance> list = this.minionReferences;
        synchronized (list) {
            this.minionReferences.remove(minion);
            if (this._respawnTasks.get((Object)current) == null) {
                this._respawnTasks.put((Object)current, (Object)minion.getNpcId());
            } else {
                for (int i = 1; i < 30; ++i) {
                    if (this._respawnTasks.get((Object)(current + (long)i)) != null) continue;
                    this._respawnTasks.put((Object)(current + (long)i), (Object)minion.getNpcId());
                    break;
                }
            }
        }
    }

    public void clearRespawnList() {
        this._respawnTasks.clear();
    }

    public void maintainMinions() {
        if (this.master == null || this.master.isAlikeDead()) {
            return;
        }
        Long current = System.currentTimeMillis();
        if (this._respawnTasks != null) {
            Iterator i$ = this._respawnTasks.keySet().iterator();
            while (i$.hasNext()) {
                long deathTime = (Long)i$.next();
                double delay = Config.RAID_MINION_RESPAWN_TIMER;
                if (!((double)(current - deathTime) > delay)) continue;
                this.spawnSingleMinion((Integer)this._respawnTasks.get((Object)deathTime), this.master.getInstanceId());
                this._respawnTasks.remove((Object)deathTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spawnMinions() {
        if (this.master == null || this.master.isAlikeDead()) {
            return;
        }
        List<L2MinionData> minions = this.master.getTemplate().getMinionData();
        if (minions == null) {
            return;
        }
        List<L2MinionInstance> list = this.minionReferences;
        synchronized (list) {
            for (L2MinionData minion : minions) {
                int minionCount = minion.getAmount();
                int minionId = minion.getMinionId();
                int minionsToSpawn = minionCount - this.countSpawnedMinionsById(minionId);
                for (int i = 0; i < minionsToSpawn; ++i) {
                    this.spawnSingleMinion(minionId, this.master.getInstanceId());
                }
            }
        }
    }

    public void spawnSingleMinion(int minionId, int instanceId) {
        L2NpcTemplate minionTemplate = NpcTable.getInstance().getTemplate(minionId);
        L2MinionInstance monster = new L2MinionInstance(IdFactory.getInstance().getNextId(), minionTemplate);
        monster.setCurrentHpMp(monster.getMaxHp(), monster.getMaxMp());
        monster.setHeading(this.master.getHeading());
        monster.setLeader(this.master);
        monster.setInstanceId(instanceId);
        int offset = 200;
        int minRadius = 30;
        int newX = Rnd.get(60, 400);
        int newY = Rnd.get(newX, 400);
        newY = (int)Math.sqrt(newY * newY - newX * newX);
        newX = newX > 230 ? this.master.getX() + newX - 200 : this.master.getX() - newX + 30;
        newY = newY > 230 ? this.master.getY() + newY - 200 : this.master.getY() - newY + 30;
        monster.spawnMe(newX, newY, this.master.getZ());
        if (Config.DEBUG) {
            _log.fine("Spawned minion template " + minionTemplate.npcId + " with objid: " + monster.getObjectId() + " to boss " + this.master.getObjectId() + " ,at: " + monster.getX() + " x, " + monster.getY() + " y, " + monster.getZ() + " z");
        }
    }
}

