/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.ai.L2VehicleAI;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ExMoveToLocationAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExStopMoveAirShip;

public class L2AirShipAI
extends L2VehicleAI {
    public L2AirShipAI(L2Vehicle.AIAccessor accessor) {
        super(accessor);
    }

    @Override
    protected void moveTo(int x, int y, int z) {
        if (!this._actor.isMovementDisabled()) {
            this._clientMoving = true;
            this._accessor.moveTo(x, y, z);
            this._actor.broadcastPacket(new ExMoveToLocationAirShip(this.getActor()));
        }
    }

    @Override
    protected void clientStopMoving(L2CharPosition pos) {
        if (this._actor.isMoving()) {
            this._accessor.stopMove(pos);
        }
        if (this._clientMoving || pos != null) {
            this._clientMoving = false;
            this._actor.broadcastPacket(new ExStopMoveAirShip(this.getActor()));
        }
    }

    @Override
    public void describeStateToPlayer(L2PcInstance player) {
        if (this._clientMoving) {
            player.sendPacket(new ExMoveToLocationAirShip(this.getActor()));
        }
    }

    @Override
    public L2AirShipInstance getActor() {
        return (L2AirShipInstance)this._actor;
    }
}

