/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.IChatHandler;
import gnu.trove.TIntObjectHashMap;
import java.util.logging.Logger;

public class ChatHandler {
    private static Logger _log = Logger.getLogger(ChatHandler.class.getName());
    private TIntObjectHashMap<IChatHandler> _datatable = new TIntObjectHashMap();

    public static ChatHandler getInstance() {
        return SingletonHolder._instance;
    }

    private ChatHandler() {
    }

    public void registerChatHandler(IChatHandler handler) {
        int[] ids = handler.getChatTypeList();
        for (int i = 0; i < ids.length; ++i) {
            if (Config.DEBUG) {
                _log.fine("Adding handler for chat type " + ids[i]);
            }
            this._datatable.put(ids[i], (Object)handler);
        }
    }

    public IChatHandler getChatHandler(int chatType) {
        return (IChatHandler)this._datatable.get(chatType);
    }

    public int size() {
        return this._datatable.size();
    }

    private static class SingletonHolder {
        protected static final ChatHandler _instance = new ChatHandler();

        private SingletonHolder() {
        }
    }
}

