/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.VehiclePathPoint;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import java.util.Collection;
import java.util.Map;
import javolution.util.FastMap;

public class BoatManager {
    private Map<Integer, L2BoatInstance> _boats = new FastMap();
    private boolean[] _docksBusy = new boolean[3];
    public static final int TALKING_ISLAND = 1;
    public static final int GLUDIN_HARBOR = 2;
    public static final int RUNE_HARBOR = 3;

    public static final BoatManager getInstance() {
        return SingletonHolder._instance;
    }

    private BoatManager() {
        for (int i = 0; i < this._docksBusy.length; ++i) {
            this._docksBusy[i] = false;
        }
    }

    public L2BoatInstance getNewBoat(int boatId, int x, int y, int z, int heading) {
        if (!Config.ALLOW_BOAT) {
            return null;
        }
        StatsSet npcDat = new StatsSet();
        npcDat.set("npcId", boatId);
        npcDat.set("level", 0);
        npcDat.set("jClass", "boat");
        npcDat.set("baseSTR", 0);
        npcDat.set("baseCON", 0);
        npcDat.set("baseDEX", 0);
        npcDat.set("baseINT", 0);
        npcDat.set("baseWIT", 0);
        npcDat.set("baseMEN", 0);
        npcDat.set("baseShldDef", 0);
        npcDat.set("baseShldRate", 0);
        npcDat.set("baseAccCombat", 38);
        npcDat.set("baseEvasRate", 38);
        npcDat.set("baseCritRate", 38);
        npcDat.set("collision_radius", 0);
        npcDat.set("collision_height", 0);
        npcDat.set("sex", "male");
        npcDat.set("type", "");
        npcDat.set("baseAtkRange", 0);
        npcDat.set("baseMpMax", 0);
        npcDat.set("baseCpMax", 0);
        npcDat.set("rewardExp", 0);
        npcDat.set("rewardSp", 0);
        npcDat.set("basePAtk", 0);
        npcDat.set("baseMAtk", 0);
        npcDat.set("basePAtkSpd", 0);
        npcDat.set("aggroRange", 0);
        npcDat.set("baseMAtkSpd", 0);
        npcDat.set("rhand", 0);
        npcDat.set("lhand", 0);
        npcDat.set("armor", 0);
        npcDat.set("baseWalkSpd", 0);
        npcDat.set("baseRunSpd", 0);
        npcDat.set("baseHpMax", 50000);
        npcDat.set("baseHpReg", 0.003f);
        npcDat.set("baseMpReg", 0.003f);
        npcDat.set("basePDef", 100);
        npcDat.set("baseMDef", 100);
        L2CharTemplate template = new L2CharTemplate(npcDat);
        L2BoatInstance boat = new L2BoatInstance(IdFactory.getInstance().getNextId(), template);
        this._boats.put(boat.getObjectId(), boat);
        boat.setHeading(heading);
        boat.setXYZInvisible(x, y, z);
        boat.spawnMe();
        return boat;
    }

    public L2BoatInstance getBoat(int boatId) {
        return this._boats.get(boatId);
    }

    public void dockShip(int h, boolean value) {
        try {
            this._docksBusy[h] = value;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean dockBusy(int h) {
        try {
            return this._docksBusy[h];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public void broadcastPacket(VehiclePathPoint point1, VehiclePathPoint point2, L2GameServerPacket packet) {
        Collection<L2PcInstance> players = L2World.getInstance().getAllPlayers().values();
        for (L2PcInstance player : players) {
            double dy;
            if (player == null) continue;
            double dx = (double)player.getX() - (double)point1.x;
            if (Math.sqrt(dx * dx + (dy = (double)player.getY() - (double)point1.y) * dy) < (double)Config.BOAT_BROADCAST_RADIUS) {
                player.sendPacket(packet);
                continue;
            }
            dx = (double)player.getX() - (double)point2.x;
            if (!(Math.sqrt(dx * dx + (dy = (double)player.getY() - (double)point2.y) * dy) < (double)Config.BOAT_BROADCAST_RADIUS)) continue;
            player.sendPacket(packet);
        }
    }

    public void broadcastPackets(VehiclePathPoint point1, VehiclePathPoint point2, L2GameServerPacket ... packets) {
        Collection<L2PcInstance> players = L2World.getInstance().getAllPlayers().values();
        for (L2PcInstance player : players) {
            double dy;
            if (player == null) continue;
            double dx = (double)player.getX() - (double)point1.x;
            if (Math.sqrt(dx * dx + (dy = (double)player.getY() - (double)point1.y) * dy) < (double)Config.BOAT_BROADCAST_RADIUS) {
                for (L2GameServerPacket p : packets) {
                    player.sendPacket(p);
                }
                continue;
            }
            dx = (double)player.getX() - (double)point2.x;
            if (!(Math.sqrt(dx * dx + (dy = (double)player.getY() - (double)point2.y) * dy) < (double)Config.BOAT_BROADCAST_RADIUS)) continue;
            for (L2GameServerPacket p : packets) {
                player.sendPacket(p);
            }
        }
    }

    private static class SingletonHolder {
        protected static final BoatManager _instance = new BoatManager();

        private SingletonHolder() {
        }
    }
}

