/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.skills.effects.EffectFusion;
import com.l2jserver.gameserver.util.Util;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public final class FusionSkill {
    protected static final Logger _log = Logger.getLogger(FusionSkill.class.getName());
    protected int _skillCastRange;
    protected int _fusionId;
    protected int _fusionLevel;
    protected L2Character _caster;
    protected L2Character _target;
    protected Future<?> _geoCheckTask;

    public L2Character getCaster() {
        return this._caster;
    }

    public L2Character getTarget() {
        return this._target;
    }

    public FusionSkill(L2Character caster, L2Character target, L2Skill skill) {
        this._skillCastRange = skill.getCastRange();
        this._caster = caster;
        this._target = target;
        this._fusionId = skill.getTriggeredId();
        this._fusionLevel = skill.getTriggeredLevel();
        L2Effect effect = this._target.getFirstEffect(this._fusionId);
        if (effect != null) {
            ((EffectFusion)effect).increaseEffect();
        } else {
            L2Skill force = SkillTable.getInstance().getInfo(this._fusionId, this._fusionLevel);
            if (force != null) {
                force.getEffects(this._caster, this._target, null);
            } else {
                _log.warning("Triggered skill [" + this._fusionId + ";" + this._fusionLevel + "] not found!");
            }
        }
        this._geoCheckTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new GeoCheckTask(), 1000L, 1000L);
    }

    public void onCastAbort() {
        this._caster.setFusionSkill(null);
        L2Effect effect = this._target.getFirstEffect(this._fusionId);
        if (effect != null) {
            ((EffectFusion)effect).decreaseForce();
        }
        this._geoCheckTask.cancel(true);
    }

    public class GeoCheckTask
    implements Runnable {
        @Override
        public void run() {
            try {
                if (!Util.checkIfInRange(FusionSkill.this._skillCastRange, FusionSkill.this._caster, FusionSkill.this._target, true)) {
                    FusionSkill.this._caster.abortCast();
                }
                if (!GeoData.getInstance().canSeeTarget((L2Object)FusionSkill.this._caster, FusionSkill.this._target)) {
                    FusionSkill.this._caster.abortCast();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

