/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbnormalStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadSpelledInfo;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.PartySpelled;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.skills.funcs.Lambda;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class L2Effect {
    static final Logger _log = Logger.getLogger(L2Effect.class.getName());
    private static final Func[] _emptyFunctionSet = new Func[0];
    private final L2Character _effector;
    private final L2Character _effected;
    private final L2Skill _skill;
    private final Lambda _lambda;
    private EffectState _state;
    private final int _period;
    private int _periodStartTicks;
    private int _periodfirsttime;
    private EffectTemplate _template;
    private final FuncTemplate[] _funcTemplates;
    private int _totalCount;
    private int _count;
    private AbnormalEffect _abnormalEffect;
    private AbnormalEffect _specialEffect;
    private AbnormalEffect _eventEffect;
    private boolean _icon;
    public boolean preventExitUpdate;
    private ScheduledFuture<?> _currentFuture;
    private EffectTask _currentTask;
    private final String _stackType;
    private final float _stackOrder;
    private boolean _inUse = false;
    private boolean _startConditionsCorrect = true;
    private double _effectPower;
    private L2SkillType _effectSkillType;

    protected L2Effect(Env env, EffectTemplate template) {
        this._state = EffectState.CREATED;
        this._skill = env.skill;
        this._template = template;
        this._effected = env.target;
        this._effector = env.player;
        this._lambda = template.lambda;
        this._funcTemplates = template.funcTemplates;
        this._totalCount = this._count = template.counter;
        int temp = template.period;
        if ((this._skill.getId() > 2277 && this._skill.getId() < 2286 || this._skill.getId() >= 2512 && this._skill.getId() <= 2514) && (this._effected instanceof L2SummonInstance || this._effected instanceof L2PcInstance && ((L2PcInstance)this._effected).getPet() instanceof L2SummonInstance)) {
            temp /= 2;
        }
        if (env.skillMastery) {
            temp *= 2;
        }
        this._period = temp;
        this._abnormalEffect = template.abnormalEffect;
        this._specialEffect = template.specialEffect;
        this._eventEffect = template.eventEffect;
        this._stackType = template.stackType;
        this._stackOrder = template.stackOrder;
        this._periodStartTicks = GameTimeController.getGameTicks();
        this._periodfirsttime = 0;
        this._icon = template.icon;
        this._effectPower = template.effectPower;
        this._effectSkillType = template.effectType;
    }

    protected L2Effect(Env env, L2Effect effect) {
        this._template = effect._template;
        this._state = EffectState.CREATED;
        this._skill = env.skill;
        this._effected = env.target;
        this._effector = env.player;
        this._lambda = this._template.lambda;
        this._funcTemplates = this._template.funcTemplates;
        this._count = effect.getCount();
        this._totalCount = this._template.counter;
        this._period = this._template.period - effect.getTime();
        this._abnormalEffect = this._template.abnormalEffect;
        this._specialEffect = this._template.specialEffect;
        this._eventEffect = this._template.eventEffect;
        this._stackType = this._template.stackType;
        this._stackOrder = this._template.stackOrder;
        this._periodStartTicks = effect.getPeriodStartTicks();
        this._periodfirsttime = effect.getPeriodfirsttime();
        this._icon = this._template.icon;
    }

    public int getCount() {
        return this._count;
    }

    public int getTotalCount() {
        return this._totalCount;
    }

    public void setCount(int newcount) {
        this._count = newcount;
    }

    public void setFirstTime(int newfirsttime) {
        if (this._currentFuture != null) {
            if (newfirsttime > this._period) {
                newfirsttime = this._period;
            }
            this._periodStartTicks = GameTimeController.getGameTicks() - newfirsttime * 10;
            this._currentFuture.cancel(false);
            this._currentFuture = null;
            this._currentTask = null;
            this._periodfirsttime = newfirsttime;
            int duration = this._period - this._periodfirsttime;
            this._currentTask = new EffectTask(duration * 1000, -1);
            this._currentFuture = this._count > 1 ? ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(this._currentTask, 5L, duration * 1000) : ThreadPoolManager.getInstance().scheduleEffect(this._currentTask, duration * 1000);
        }
    }

    public boolean getShowIcon() {
        return this._icon;
    }

    public int getPeriod() {
        return this._period;
    }

    public int getTime() {
        return (GameTimeController.getGameTicks() - this._periodStartTicks) / 10;
    }

    public int getTaskTime() {
        if (this._count == this._totalCount) {
            return 0;
        }
        return Math.abs(this._count - this._totalCount + 1) * this._period + this.getTime() + 1;
    }

    public boolean getInUse() {
        return this._inUse;
    }

    public boolean setInUse(boolean inUse) {
        this._inUse = inUse;
        if (this._inUse) {
            this._startConditionsCorrect = this.onStart();
        } else {
            this.onExit();
        }
        return this._startConditionsCorrect;
    }

    public String getStackType() {
        return this._stackType;
    }

    public float getStackOrder() {
        return this._stackOrder;
    }

    public final L2Skill getSkill() {
        return this._skill;
    }

    public final L2Character getEffector() {
        return this._effector;
    }

    public final L2Character getEffected() {
        return this._effected;
    }

    public boolean isSelfEffect() {
        return this._skill._effectTemplatesSelf != null;
    }

    public boolean isHerbEffect() {
        return this.getSkill().getName().contains("\u30cf\u30fc\u30d6") || this.getSkill().getName().contains("Herb");
    }

    public final double calc() {
        Env env = new Env();
        env.player = this._effector;
        env.target = this._effected;
        env.skill = this._skill;
        return this._lambda.calc(env);
    }

    private synchronized void startEffectTask(int duration) {
        if (duration >= 0) {
            this.stopEffectTask();
            this._currentTask = new EffectTask(duration, -1);
            this._currentFuture = ThreadPoolManager.getInstance().scheduleEffect(this._currentTask, duration);
        }
        if (this._state == EffectState.ACTING) {
            this._effected.addEffect(this);
        }
    }

    private synchronized void startEffectTaskAtFixedRate(int delay, int rate) {
        this.stopEffectTask();
        this._currentTask = new EffectTask(delay, rate);
        this._currentFuture = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(this._currentTask, delay, rate);
        if (this._state == EffectState.ACTING) {
            this._effected.addEffect(this);
        }
    }

    public final void exit() {
        this.exit(false);
    }

    public final void exit(boolean preventUpdate) {
        this.preventExitUpdate = preventUpdate;
        this._state = EffectState.FINISHING;
        this.scheduleEffect();
    }

    public synchronized void stopEffectTask() {
        if (this._currentFuture != null) {
            this._currentFuture.cancel(false);
            ThreadPoolManager.getInstance().removeEffect(this._currentTask);
            this._currentFuture = null;
            this._currentTask = null;
            if (this.getEffected() != null) {
                this.getEffected().removeEffect(this);
            }
        }
    }

    public abstract L2EffectType getEffectType();

    public boolean onStart() {
        if (this._abnormalEffect != AbnormalEffect.NULL) {
            this.getEffected().startAbnormalEffect(this._abnormalEffect);
        }
        if (this._specialEffect != AbnormalEffect.NULL) {
            this.getEffected().startSpecialEffect(this._specialEffect);
        }
        if (this._eventEffect != AbnormalEffect.NULL && this.getEffected().getInstanceType() == L2Object.InstanceType.L2PcInstance) {
            this.getEffected().getActingPlayer().startEventEffect(this._eventEffect);
        }
        return true;
    }

    public void onExit() {
        if (this._abnormalEffect != AbnormalEffect.NULL) {
            this.getEffected().stopAbnormalEffect(this._abnormalEffect);
        }
        if (this._specialEffect != AbnormalEffect.NULL) {
            this.getEffected().stopSpecialEffect(this._specialEffect);
        }
        if (this._eventEffect != AbnormalEffect.NULL && this.getEffected().getInstanceType() == L2Object.InstanceType.L2PcInstance) {
            this.getEffected().getActingPlayer().stopEventEffect(this._eventEffect);
        }
    }

    public abstract boolean onActionTime();

    public final void rescheduleEffect() {
        if (this._state != EffectState.ACTING) {
            this.scheduleEffect();
        } else {
            if (this._count > 1) {
                this.startEffectTaskAtFixedRate(5, this._period * 1000);
                return;
            }
            if (this._period > 0) {
                this.startEffectTask(this._period * 1000);
                return;
            }
        }
    }

    public final void scheduleEffect() {
        if (this._state == EffectState.CREATED) {
            this._state = EffectState.ACTING;
            if (this._skill.isPvpSkill() && this._icon && this.getEffected() instanceof L2PcInstance) {
                SystemMessage smsg = new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
                smsg.addSkillName(this._skill);
                this.getEffected().sendPacket(smsg);
            }
            if (this._count > 1) {
                this.startEffectTaskAtFixedRate(5, this._period * 1000);
                return;
            }
            if (this._period > 0 || this._period == -1) {
                this.startEffectTask(this._period * 1000);
                return;
            }
            this._startConditionsCorrect = this.onStart();
        }
        if (this._state == EffectState.ACTING) {
            if (this._count-- > 0 && (this.getInUse() ? this.onActionTime() && this._startConditionsCorrect : this._count > 0)) {
                return;
            }
            this._state = EffectState.FINISHING;
        }
        if (this._state == EffectState.FINISHING) {
            L2Skill skill;
            if ((this.getInUse() || this._count <= 1 && this._period <= 0) && this._startConditionsCorrect) {
                this.onExit();
            }
            if (this._count == 0 && this._icon && this.getEffected() instanceof L2PcInstance) {
                SystemMessage smsg3 = new SystemMessage(SystemMessageId.S1_HAS_WORN_OFF);
                smsg3.addSkillName(this._skill);
                this.getEffected().sendPacket(smsg3);
            }
            if (this._currentFuture == null && this.getEffected() != null) {
                this.getEffected().removeEffect(this);
            }
            this.stopEffectTask();
            if (this._skill.getAfterEffectId() > 0 && (skill = SkillTable.getInstance().getInfo(this._skill.getAfterEffectId(), this._skill.getAfterEffectLvl())) != null) {
                this.getEffected().broadcastPacket(new MagicSkillUse(this._effected, skill.getId(), skill.getLevel(), 0, 0));
                this.getEffected().broadcastPacket(new MagicSkillLaunched(this._effected, skill.getId(), skill.getLevel()));
                skill.getEffects(this.getEffected(), this.getEffected());
            }
        }
    }

    public Func[] getStatFuncs() {
        if (this._funcTemplates == null) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.length);
        Env env = new Env();
        env.player = this.getEffector();
        env.target = this.getEffected();
        env.skill = this.getSkill();
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        if (funcs.isEmpty()) {
            return _emptyFunctionSet;
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public final void addIcon(AbnormalStatusUpdate mi) {
        EffectTask task = this._currentTask;
        ScheduledFuture<?> future = this._currentFuture;
        if (this._state == EffectState.FINISHING || this._state == EffectState.CREATED) {
            return;
        }
        L2Skill sk = this.getSkill();
        if (task != null && task._rate > 0) {
            if (sk.isPotion()) {
                mi.addEffect(sk.getId(), this.getLevel(), sk.getBuffDuration() - this.getTaskTime() * 1000);
            } else {
                mi.addEffect(sk.getId(), this.getLevel(), -1);
            }
        } else if (future != null) {
            mi.addEffect(sk.getId(), this.getLevel(), (int)future.getDelay(TimeUnit.MILLISECONDS));
        } else if (this._period == -1) {
            mi.addEffect(sk.getId(), this.getLevel(), this._period);
        }
    }

    public final void addPartySpelledIcon(PartySpelled ps) {
        ScheduledFuture<?> future = this._currentFuture;
        if (this._state == EffectState.FINISHING || this._state == EffectState.CREATED) {
            return;
        }
        L2Skill sk = this.getSkill();
        if (future != null) {
            ps.addPartySpelledEffect(sk.getId(), this.getLevel(), (int)future.getDelay(TimeUnit.MILLISECONDS));
        } else if (this._period == -1) {
            ps.addPartySpelledEffect(sk.getId(), this.getLevel(), this._period);
        }
    }

    public final void addOlympiadSpelledIcon(ExOlympiadSpelledInfo os) {
        ScheduledFuture<?> future = this._currentFuture;
        if (this._state == EffectState.FINISHING || this._state == EffectState.CREATED) {
            return;
        }
        L2Skill sk = this.getSkill();
        if (future != null) {
            os.addEffect(sk.getId(), this.getLevel(), (int)future.getDelay(TimeUnit.MILLISECONDS));
        } else if (this._period == -1) {
            os.addEffect(sk.getId(), this.getLevel(), this._period);
        }
    }

    public int getLevel() {
        return this.getSkill().getLevel();
    }

    public int getPeriodfirsttime() {
        return this._periodfirsttime;
    }

    public void setPeriodfirsttime(int periodfirsttime) {
        this._periodfirsttime = periodfirsttime;
    }

    public int getPeriodStartTicks() {
        return this._periodStartTicks;
    }

    public void setPeriodStartTicks(int periodStartTicks) {
        this._periodStartTicks = periodStartTicks;
    }

    public EffectTemplate getEffectTemplate() {
        return this._template;
    }

    public double getEffectPower() {
        return this._effectPower;
    }

    public L2SkillType getSkillType() {
        return this._effectSkillType;
    }

    public final class EffectTask
    implements Runnable {
        protected final int _delay;
        protected final int _rate;

        EffectTask(int pDelay, int pRate) {
            this._delay = pDelay;
            this._rate = pRate;
        }

        @Override
        public void run() {
            try {
                if (L2Effect.this.getPeriodfirsttime() == 0) {
                    L2Effect.this.setPeriodStartTicks(GameTimeController.getGameTicks());
                } else {
                    L2Effect.this.setPeriodfirsttime(0);
                }
                L2Effect.this.scheduleEffect();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public static enum EffectState {
        CREATED,
        ACTING,
        FINISHING;

    }
}

