/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExMoveToLocationInAirShip;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.util.Point3D;

public class MoveToLocationInAirShip
extends L2GameClientPacket {
    private static final String _C__D0_20_MOVETOLOCATIONINAIRSHIP = "[C] D0:20 MoveToLocationInAirShip";
    private int _shipId;
    private final Point3D _pos = new Point3D(0, 0, 0);
    private final Point3D _origin_pos = new Point3D(0, 0, 0);

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        this._shipId = this.readD();
        int _x = this.readD();
        int _y = this.readD();
        int _z = this.readD();
        this._pos.setXYZ(_x, _y, _z);
        _x = this.readD();
        _y = this.readD();
        _z = this.readD();
        this._origin_pos.setXYZ(_x, _y, _z);
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isAttackingNow() && activeChar.getActiveWeaponItem() != null && activeChar.getActiveWeaponItem().getItemType() == L2WeaponType.BOW) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isSitting() || activeChar.isMovementDisabled()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!activeChar.isInAirShip()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2AirShipInstance airShip = activeChar.getAirShip();
        if (airShip.getObjectId() != this._shipId) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        activeChar.setVehicle(airShip);
        activeChar.setInVehiclePosition(this._pos);
        activeChar.broadcastPacket(new ExMoveToLocationInAirShip(activeChar));
    }

    @Override
    public String getType() {
        return _C__D0_20_MOVETOLOCATIONINAIRSHIP;
    }
}

