/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExChangePostState;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestRejectPostAttachment
extends L2GameClientPacket {
    private static final String _C__D0_6B_REQUESTREJECTPOSTATTACHMENT = "[C] D0:6B RequestRejectPostAttachment";
    private int _msgId;

    @Override
    protected void readImpl() {
        this._msgId = this.readD();
    }

    @Override
    public void runImpl() {
        if (!Config.ALLOW_MAIL || !Config.ALLOW_ATTACHMENTS) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!activeChar.getFloodProtectors().getTransaction().tryPerformAction("rejectattach")) {
            return;
        }
        if (!activeChar.isInsideZone((byte)1)) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANT_USE_MAIL_OUTSIDE_PEACE_ZONE));
            return;
        }
        Message msg = MailManager.getInstance().getMessage(this._msgId);
        if (msg == null) {
            return;
        }
        if (msg.getReceiverId() != activeChar.getObjectId()) {
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to reject not own attachment!", Config.DEFAULT_PUNISH);
            return;
        }
        if (!msg.hasAttachments() || msg.isFourStars()) {
            return;
        }
        MailManager.getInstance().sendMessage(new Message(msg));
        activeChar.sendPacket(new SystemMessage(SystemMessageId.MAIL_SUCCESSFULLY_RETURNED));
        activeChar.sendPacket(new ExChangePostState(true, this._msgId, 2));
        L2PcInstance sender = L2World.getInstance().getPlayer(msg.getSenderId());
        if (sender != null) {
            SystemMessage sm = new SystemMessage(SystemMessageId.S1_RETURNED_MAIL);
            sm.addCharName(activeChar);
            sender.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _C__D0_6B_REQUESTREJECTPOSTATTACHMENT;
    }
}

