/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.TradeController;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2MercManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.util.Util;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestWearItem
extends L2GameClientPacket {
    private static final String _C__C6_REQUESTWEARITEM = "[C] C6 RequestWearItem";
    protected static final Logger _log = Logger.getLogger(RequestWearItem.class.getName());
    protected Future<?> _removeWearItemsTask;
    private int _unknow;
    private int _listId;
    private int _count;
    private int[] _items;
    protected L2PcInstance _activeChar;

    @Override
    protected void readImpl() {
        this._activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        this._unknow = this.readD();
        this._listId = this.readD();
        this._count = this.readD();
        if (this._count < 0) {
            this._count = 0;
        }
        if (this._count > 100) {
            this._count = 0;
        }
        this._items = new int[this._count];
        for (int i = 0; i < this._count; ++i) {
            int itemId;
            this._items[i] = itemId = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && player.getKarma() > 0) {
            return;
        }
        L2Object target = player.getTarget();
        if (!(player.isGM() || target != null && (target instanceof L2MerchantInstance || target instanceof L2MercManagerInstance) && player.isInsideRadius(target, 150, false, false))) {
            return;
        }
        L2TradeList list = null;
        L2MerchantInstance merchant = target instanceof L2MerchantInstance ? (L2MerchantInstance)target : null;
        List<L2TradeList> lists = TradeController.getInstance().getBuyListByNpcId(merchant.getNpcId());
        if (lists == null) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
            return;
        }
        for (L2TradeList tradeList : lists) {
            if (tradeList.getListId() != this._listId) continue;
            list = tradeList;
        }
        if (list == null) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
            return;
        }
        this._listId = list.getListId();
        if (this._count < 1 || this._listId >= 1000000) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        long totalPrice = 0L;
        int slots = 0;
        int weight = 0;
        for (int i = 0; i < this._count; ++i) {
            int itemId = this._items[i];
            if (!list.containsItemId(itemId)) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId + " and item_id " + itemId, Config.DEFAULT_PUNISH);
                return;
            }
            L2Item template = ItemTable.getInstance().getTemplate(itemId);
            weight += template.getWeight();
            ++slots;
            if ((totalPrice += (long)Config.WEAR_PRICE) <= 99900000000L) continue;
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + 99900000000L + " adena worth of goods.", Config.DEFAULT_PUNISH);
            return;
        }
        if (!player.getInventory().validateWeight(weight)) {
            this.sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            return;
        }
        if (!player.getInventory().validateCapacity(slots)) {
            this.sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
            return;
        }
        if (totalPrice < 0L || !player.reduceAdena("Wear", totalPrice, player.getLastFolkNPC(), false)) {
            this.sendPacket(new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
            return;
        }
        InventoryUpdate playerIU = new InventoryUpdate();
        for (int i = 0; i < this._count; ++i) {
            int itemId = this._items[i];
            if (!list.containsItemId(itemId)) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId + " and item_id " + itemId, Config.DEFAULT_PUNISH);
                return;
            }
            L2ItemInstance item = player.getInventory().addWearItem("Wear", itemId, player, merchant);
            player.getInventory().equipItemAndRecord(item);
            playerIU.addItem(item);
        }
        player.sendPacket(playerIU);
        StatusUpdate su = new StatusUpdate(player.getObjectId());
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        player.broadcastUserInfo();
        if (this._removeWearItemsTask == null) {
            this._removeWearItemsTask = ThreadPoolManager.getInstance().scheduleGeneral(new RemoveWearItemsTask(), Config.WEAR_DELAY * 1000);
        }
    }

    @Override
    public String getType() {
        return _C__C6_REQUESTWEARITEM;
    }

    class RemoveWearItemsTask
    implements Runnable {
        RemoveWearItemsTask() {
        }

        @Override
        public void run() {
            try {
                RequestWearItem.this._activeChar.destroyWearedItems("Wear", null, true);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }
}

