/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.ChanceCondition;
import com.l2jserver.gameserver.model.IChanceSkillTrigger;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectChanceSkillTrigger
extends L2Effect
implements IChanceSkillTrigger {
    private final int _triggeredId;
    private final int _triggeredLevel;
    private final ChanceCondition _chanceCondition;

    public EffectChanceSkillTrigger(Env env, EffectTemplate template) {
        super(env, template);
        this._triggeredId = template.triggeredId;
        this._triggeredLevel = template.triggeredLevel;
        this._chanceCondition = template.chanceCondition;
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.CHANCE_SKILL_TRIGGER;
    }

    @Override
    public boolean onStart() {
        this.getEffected().addChanceTrigger(this);
        this.getEffected().onStartChanceEffect(this.getSkill().getElement());
        return super.onStart();
    }

    @Override
    public boolean onActionTime() {
        this.getEffected().onActionTimeChanceEffect(this.getSkill().getElement());
        return false;
    }

    @Override
    public void onExit() {
        if (this.getInUse() && this.getCount() == 0) {
            this.getEffected().onExitChanceEffect(this.getSkill().getElement());
        }
        this.getEffected().removeChanceEffect(this);
        super.onExit();
    }

    @Override
    public int getTriggeredChanceId() {
        return this._triggeredId;
    }

    @Override
    public int getTriggeredChanceLevel() {
        return this._triggeredLevel;
    }

    @Override
    public boolean triggersChanceSkill() {
        return this._triggeredId > 1;
    }

    @Override
    public ChanceCondition getTriggeredChanceCondition() {
        return this._chanceCondition;
    }
}

