/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class IllegalPlayerAction
implements Runnable {
    private static Logger _logAudit = Logger.getLogger("audit");
    private String _message;
    private int _punishment;
    private L2PcInstance _actor;
    public static final int PUNISH_BROADCAST = 1;
    public static final int PUNISH_KICK = 2;
    public static final int PUNISH_KICKBAN = 3;
    public static final int PUNISH_JAIL = 4;

    public IllegalPlayerAction(L2PcInstance actor, String message, int punishment) {
        this._message = message;
        this._punishment = punishment;
        this._actor = actor;
        switch (punishment) {
            case 2: {
                this._actor.sendMessage("You will be kicked for illegal action, GM informed.");
                break;
            }
            case 3: {
                this._actor.setAccessLevel(-100);
                this._actor.setAccountAccesslevel(-100);
                this._actor.sendMessage("You are banned for illegal action, GM informed.");
                break;
            }
            case 4: {
                this._actor.sendMessage("Illegal action performed!");
                this._actor.sendMessage("You will be teleported to GM Consultation Service area and jailed.");
            }
        }
    }

    @Override
    public void run() {
        LogRecord record = new LogRecord(Level.INFO, "AUDIT:" + this._message);
        record.setLoggerName("audit");
        record.setParameters(new Object[]{this._actor, this._punishment});
        _logAudit.log(record);
        GmListTable.broadcastMessageToGMs(this._message);
        switch (this._punishment) {
            case 1: {
                return;
            }
            case 2: {
                this._actor.logout(false);
                break;
            }
            case 3: {
                this._actor.logout();
                break;
            }
            case 4: {
                this._actor.setPunishLevel(L2PcInstance.PunishLevel.JAIL, Config.DEFAULT_PUNISH_PARAM);
            }
        }
    }
}

