/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.SessionKey;
import com.l2jserver.loginserver.serverpackets.L2LoginServerPacket;
import com.l2jserver.loginserver.serverpackets.LoginFail;
import com.l2jserver.loginserver.serverpackets.PlayFail;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.Util;
import com.l2jserver.util.crypt.LoginCrypt;
import com.l2jserver.util.crypt.ScrambledKeyPair;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.interfaces.RSAPrivateKey;
import java.util.logging.Logger;
import org.mmocore.network.MMOClient;
import org.mmocore.network.MMOConnection;
import org.mmocore.network.SendablePacket;

public final class L2LoginClient
extends MMOClient<MMOConnection<L2LoginClient>> {
    private static Logger _log = Logger.getLogger(L2LoginClient.class.getName());
    private LoginClientState _state = LoginClientState.CONNECTED;
    private LoginCrypt _loginCrypt;
    private ScrambledKeyPair _scrambledPair;
    private byte[] _blowfishKey;
    private String _account;
    private int _accessLevel;
    private int _lastServer;
    private boolean _usesInternalIP;
    private SessionKey _sessionKey;
    private int _sessionId;
    private boolean _joinedGS;
    private long _connectionStartTime;

    public L2LoginClient(MMOConnection<L2LoginClient> con) {
        super(con);
        String ip = this.getConnection().getInetAddress().getHostAddress();
        if (Util.isInternalIP(ip) && !Config.ROUTER_HOSTNAME.equalsIgnoreCase(ip)) {
            this._usesInternalIP = true;
        }
        this._scrambledPair = LoginController.getInstance().getScrambledRSAKeyPair();
        this._blowfishKey = LoginController.getInstance().getBlowfishKey();
        this._sessionId = Rnd.nextInt();
        this._connectionStartTime = System.currentTimeMillis();
        this._loginCrypt = new LoginCrypt();
        this._loginCrypt.setKey(this._blowfishKey);
    }

    public boolean usesInternalIP() {
        return this._usesInternalIP;
    }

    public boolean decrypt(ByteBuffer buf, int size) {
        boolean ret = false;
        try {
            ret = this._loginCrypt.decrypt(buf.array(), buf.position(), size);
        }
        catch (IOException e) {
            e.printStackTrace();
            super.getConnection().close(null);
            return false;
        }
        if (!ret) {
            byte[] dump = new byte[size];
            System.arraycopy(buf.array(), buf.position(), dump, 0, size);
            _log.warning("Wrong checksum from client: " + this.toString());
            super.getConnection().close(null);
        }
        return ret;
    }

    public boolean encrypt(ByteBuffer buf, int size) {
        int offset = buf.position();
        try {
            size = this._loginCrypt.encrypt(buf.array(), offset, size);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        buf.position(offset + size);
        return true;
    }

    public LoginClientState getState() {
        return this._state;
    }

    public void setState(LoginClientState state) {
        this._state = state;
    }

    public byte[] getBlowfishKey() {
        return this._blowfishKey;
    }

    public byte[] getScrambledModulus() {
        return this._scrambledPair._scrambledModulus;
    }

    public RSAPrivateKey getRSAPrivateKey() {
        return (RSAPrivateKey)this._scrambledPair._pair.getPrivate();
    }

    public String getAccount() {
        return this._account;
    }

    public void setAccount(String account) {
        this._account = account;
    }

    public void setAccessLevel(int accessLevel) {
        this._accessLevel = accessLevel;
    }

    public int getAccessLevel() {
        return this._accessLevel;
    }

    public void setLastServer(int lastServer) {
        this._lastServer = lastServer;
    }

    public int getLastServer() {
        return this._lastServer;
    }

    public int getSessionId() {
        return this._sessionId;
    }

    public boolean hasJoinedGS() {
        return this._joinedGS;
    }

    public void setJoinedGS(boolean val) {
        this._joinedGS = val;
    }

    public void setSessionKey(SessionKey sessionKey) {
        this._sessionKey = sessionKey;
    }

    public SessionKey getSessionKey() {
        return this._sessionKey;
    }

    public long getConnectionStartTime() {
        return this._connectionStartTime;
    }

    public void sendPacket(L2LoginServerPacket lsp) {
        this.getConnection().sendPacket((SendablePacket)lsp);
    }

    public void close(LoginFail.LoginFailReason reason) {
        this.getConnection().close((SendablePacket)new LoginFail(reason));
    }

    public void close(PlayFail.PlayFailReason reason) {
        this.getConnection().close((SendablePacket)new PlayFail(reason));
    }

    public void close(L2LoginServerPacket lsp) {
        this.getConnection().close((SendablePacket)lsp);
    }

    public void onDisconnection() {
        if (Config.DEBUG) {
            _log.info("DISCONNECTED: " + this.toString());
        }
        if (!this.hasJoinedGS() || this.getConnectionStartTime() + 60000L < System.currentTimeMillis()) {
            LoginController.getInstance().removeAuthedLoginClient(this.getAccount());
        }
    }

    public String toString() {
        InetAddress address = this.getConnection().getInetAddress();
        if (this.getState() == LoginClientState.AUTHED_LOGIN) {
            return "[" + this.getAccount() + " (" + (address == null ? "disconnected" : address.getHostAddress()) + ")]";
        }
        return "[" + (address == null ? "disconnected" : address.getHostAddress()) + "]";
    }

    protected void onForcedDisconnection() {
    }

    public static enum LoginClientState {
        CONNECTED,
        AUTHED_GG,
        AUTHED_LOGIN;

    }
}

