/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ExtractableItem;
import com.l2jserver.gameserver.model.L2ExtractableProductItem;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.Scanner;
import java.util.logging.Logger;
import javolution.util.FastList;

public class ExtractableItemsData {
    protected static final Logger _log = Logger.getLogger(ExtractableItemsData.class.getName());
    private TIntObjectHashMap<L2ExtractableItem> _items = new TIntObjectHashMap();

    public static ExtractableItemsData getInstance() {
        return SingletonHolder._instance;
    }

    public ExtractableItemsData() {
        Scanner s;
        try {
            s = new Scanner(new File(Config.DATAPACK_ROOT + "/data/extractable_items.csv"));
        }
        catch (Exception e) {
            _log.warning("Extractable items data: Can not find '" + Config.DATAPACK_ROOT + "/data/extractable_items.csv'");
            return;
        }
        int lineCount = 0;
        while (s.hasNextLine()) {
            ++lineCount;
            String line = s.nextLine();
            if (line.startsWith("#") || line.equals("")) continue;
            String[] lineSplit = line.split(";");
            boolean ok = true;
            int itemID = 0;
            try {
                itemID = Integer.parseInt(lineSplit[0]);
            }
            catch (Exception e) {
                _log.warning("Extractable items data: Error in line " + lineCount + " -> invalid item id or wrong seperator after item id!");
                _log.warning("\t\t" + line);
                ok = false;
            }
            if (!ok) continue;
            FastList product_temp = new FastList();
            for (int i = 1; i < lineSplit.length; ++i) {
                ok = true;
                String[] lineSplit2 = lineSplit[i].split(",");
                if (lineSplit2.length < 3) {
                    _log.warning("Extractable items data: Error in line " + lineCount + " -> wrong seperator!");
                    _log.warning("\t\t" + line);
                    ok = false;
                }
                if (!ok) continue;
                int[] production = null;
                int[] amount = null;
                int chance = 0;
                try {
                    int size = (lineSplit2.length - 1) / 2;
                    production = new int[size];
                    amount = new int[size];
                    int j = 0;
                    for (int k = 0; k < size; ++k) {
                        production[k] = Integer.parseInt(lineSplit2[j++]);
                        amount[k] = Integer.parseInt(lineSplit2[j++]);
                    }
                    chance = Integer.parseInt(lineSplit2[j++]);
                }
                catch (Exception e) {
                    _log.warning("Extractable items data: Error in line " + lineCount + " -> incomplete/invalid production data or wrong seperator!");
                    _log.warning("\t\t" + line);
                    ok = false;
                }
                if (!ok) continue;
                L2ExtractableProductItem product = new L2ExtractableProductItem(production, amount, chance);
                product_temp.add((Object)product);
            }
            int fullChances = 0;
            for (L2ExtractableProductItem Pi : product_temp) {
                fullChances += Pi.getChance();
            }
            if (fullChances > 100) {
                _log.warning("Extractable items data: Error in line " + lineCount + " -> all chances together are more then 100!");
                _log.warning("\t\t" + line);
                continue;
            }
            L2ExtractableItem product = new L2ExtractableItem(itemID, (FastList<L2ExtractableProductItem>)product_temp);
            this._items.put(itemID, (Object)product);
        }
        s.close();
        _log.info("Extractable items data: Loaded " + this._items.size() + " extractable items!");
    }

    public L2ExtractableItem getExtractableItem(int itemID) {
        return (L2ExtractableItem)this._items.get(itemID);
    }

    private static class SingletonHolder {
        protected static final ExtractableItemsData _instance = new ExtractableItemsData();

        private SingletonHolder() {
        }
    }
}

