/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import java.util.Map;
import javolution.util.FastMap;

public class AntiFeedManager {
    private Map<Integer, Long> _lastDeathTimes = new FastMap().shared();

    public static final AntiFeedManager getInstance() {
        return SingletonHolder._instance;
    }

    private AntiFeedManager() {
    }

    public final void setLastDeathTime(int objectId) {
        this._lastDeathTimes.put(objectId, System.currentTimeMillis());
    }

    public final boolean check(L2Character attacker, L2Character target) {
        if (!Config.L2JMOD_ANTIFEED_ENABLE) {
            return true;
        }
        if (target == null) {
            return false;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null) {
            return false;
        }
        if (Config.L2JMOD_ANTIFEED_INTERVAL > 0 && this._lastDeathTimes.containsKey(targetPlayer.getObjectId())) {
            return System.currentTimeMillis() - this._lastDeathTimes.get(targetPlayer.getObjectId()) > (long)Config.L2JMOD_ANTIFEED_INTERVAL;
        }
        if (Config.L2JMOD_ANTIFEED_DUALBOX && attacker != null) {
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (attackerPlayer == null) {
                return false;
            }
            L2GameClient targetClient = targetPlayer.getClient();
            L2GameClient attackerClient = attackerPlayer.getClient();
            if (targetClient == null || attackerClient == null || targetClient.isDetached() || attackerClient.isDetached()) {
                return !Config.L2JMOD_ANTIFEED_DISCONNECTED_AS_DUALBOX;
            }
            return !targetClient.getConnection().getInetAddress().equals(attackerClient.getConnection().getInetAddress());
        }
        return true;
    }

    public final void clear() {
        this._lastDeathTimes.clear();
    }

    private static class SingletonHolder {
        protected static final AntiFeedManager _instance = new AntiFeedManager();

        private SingletonHolder() {
        }
    }
}

