/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExNoticePostArrived;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class MailManager {
    private static Logger _log = Logger.getLogger(MailManager.class.getName());
    private Map<Integer, Message> _messages = new FastMap().shared();

    public static MailManager getInstance() {
        return SingletonHolder._instance;
    }

    private MailManager() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        int readed = 0;
        Connection con = null;
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            stmt1 = con.prepareStatement("SELECT * FROM messages ORDER BY expiration");
            stmt2 = con.prepareStatement("SELECT * FROM attachments WHERE messageId = ?");
            ResultSet rset1 = stmt1.executeQuery();
            while (rset1.next()) {
                Message msg = new Message(rset1);
                int msgId = msg.getId();
                this._messages.put(msgId, msg);
                ++readed;
                long expiration = msg.getExpiration();
                if (expiration < System.currentTimeMillis()) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msgId), 10000L);
                    continue;
                }
                ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msgId), expiration - System.currentTimeMillis());
            }
            stmt1.close();
            stmt2.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Mail Manager: Error loading from database:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.info("Mail Manager: Successfully loaded " + readed + " messages.");
    }

    public final Message getMessage(int msgId) {
        return this._messages.get(msgId);
    }

    public final boolean hasUnreadPost(L2PcInstance player) {
        int objectId = player.getObjectId();
        for (Message msg : this._messages.values()) {
            if (msg == null || msg.getReceiverId() != objectId || !msg.isUnread()) continue;
            return true;
        }
        return false;
    }

    public final int getInboxSize(int objectId) {
        int size = 0;
        for (Message msg : this._messages.values()) {
            if (msg == null || msg.getReceiverId() != objectId || msg.isDeletedByReceiver()) continue;
            ++size;
        }
        return size;
    }

    public final int getOutboxSize(int objectId) {
        int size = 0;
        for (Message msg : this._messages.values()) {
            if (msg == null || msg.getSenderId() != objectId || msg.isDeletedBySender()) continue;
            ++size;
        }
        return size;
    }

    public final List<Message> getInbox(int objectId) {
        FastList inbox = FastList.newInstance();
        for (Message msg : this._messages.values()) {
            if (msg == null || msg.getReceiverId() != objectId || msg.isDeletedByReceiver()) continue;
            inbox.add(msg);
        }
        return inbox;
    }

    public final List<Message> getOutbox(int objectId) {
        FastList outbox = FastList.newInstance();
        for (Message msg : this._messages.values()) {
            if (msg == null || msg.getSenderId() != objectId || msg.isDeletedBySender()) continue;
            outbox.add(msg);
        }
        return outbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message msg) {
        this._messages.put(msg.getId(), msg);
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            stmt = Message.getStatement(msg, con);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Mail Manager: Error saving message:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        L2PcInstance receiver = L2World.getInstance().getPlayer(msg.getReceiverId());
        if (receiver != null) {
            receiver.sendPacket(ExNoticePostArrived.valueOf(true));
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msg.getId()), msg.getExpiration() - System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markAsReadInDb(int msgId) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            stmt = con.prepareStatement("UPDATE messages SET isUnread = 'false' WHERE messageId = ?");
            stmt.setInt(1, msgId);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Mail Manager: Error marking as read message:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markAsDeletedBySenderInDb(int msgId) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            stmt = con.prepareStatement("UPDATE messages SET isDeletedBySender = 'true' WHERE messageId = ?");
            stmt.setInt(1, msgId);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Mail Manager: Error marking as deleted by sender message:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markAsDeletedByReceiverInDb(int msgId) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            stmt = con.prepareStatement("UPDATE messages SET isDeletedByReceiver = 'true' WHERE messageId = ?");
            stmt.setInt(1, msgId);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Mail Manager: Error marking as deleted by receiver message:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAttachmentsInDb(int msgId) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            stmt = con.prepareStatement("UPDATE messages SET hasAttachments = 'false' WHERE messageId = ?");
            stmt.setInt(1, msgId);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Mail Manager: Error removing attachments in message:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteMessageInDb(int msgId) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            stmt = con.prepareStatement("DELETE FROM messages WHERE messageId = ?");
            stmt.setInt(1, msgId);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Mail Manager: Error deleting message:" + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this._messages.remove(msgId);
        IdFactory.getInstance().releaseId(msgId);
    }

    private static class SingletonHolder {
        protected static final MailManager _instance = new MailManager();

        private SingletonHolder() {
        }
    }

    class MessageDeletionTask
    implements Runnable {
        final int _msgId;

        public MessageDeletionTask(int msgId) {
            this._msgId = msgId;
        }

        @Override
        public void run() {
            Message msg = MailManager.this.getMessage(this._msgId);
            if (msg == null) {
                return;
            }
            if (msg.hasAttachments()) {
                try {
                    L2PcInstance sender = L2World.getInstance().getPlayer(msg.getSenderId());
                    if (sender != null) {
                        msg.getAttachments().returnToWh(sender.getWarehouse());
                        sender.sendPacket(new SystemMessage(SystemMessageId.MAIL_RETURNED));
                    } else {
                        msg.getAttachments().returnToWh(null);
                    }
                    msg.getAttachments().deleteMe();
                    msg.removeAttachments();
                    L2PcInstance receiver = L2World.getInstance().getPlayer(msg.getReceiverId());
                    if (receiver != null) {
                        SystemMessage sm = new SystemMessage(SystemMessageId.MAIL_RETURNED);
                        sm.addString(msg.getReceiverName());
                        receiver.sendPacket(sm);
                    }
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Mail Manager: Error returning items:" + e.getMessage(), e);
                }
            }
            MailManager.this.deleteMessageInDb(msg.getId());
        }
    }
}

