/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.funcs.FuncAdd;
import com.l2jserver.gameserver.skills.funcs.LambdaConst;

public final class Elementals {
    private ElementalStatBoni _boni = null;
    public static final byte NONE = -1;
    public static final byte FIRE = 0;
    public static final byte WATER = 1;
    public static final byte WIND = 2;
    public static final byte EARTH = 3;
    public static final byte HOLY = 4;
    public static final byte DARK = 5;
    public static final int ENCHANT_CHANCE = Config.ENCHANT_CHANCE_ELEMENT;
    public static final int FIRST_WEAPON_BONUS = 20;
    public static final int NEXT_WEAPON_BONUS = 5;
    public static final int ARMOR_BONUS = 6;
    public static final int[] WEAPON_VALUES = new int[]{0, 25, 75, 150, 175, 225, 300, 325, 375, 450, 475, 525, 600, Integer.MAX_VALUE};
    public static final int[] ARMOR_VALUES = new int[]{0, 12, 30, 60, 72, 90, 120, 132, 150, 180, 192, 210, 240, Integer.MAX_VALUE};
    public static final int[] STONES = new int[]{9546, 9547, 9549, 9548, 9551, 9550};
    public static final int[] CRYSTALS = new int[]{9552, 9553, 9555, 9554, 9557, 9556};
    public static final int[] JEWELS = new int[]{9558, 9559, 9561, 9560, 9563, 9562};
    public static final int[] ENERGIES = new int[]{9564, 9565, 9567, 9566, 9569, 9568};
    public static final int[] ROUGHORES = new int[]{10521, 10522, 10524, 10523, 10526, 10525};
    private byte _element = (byte)-1;
    private int _value = 0;

    public byte getElement() {
        return this._element;
    }

    public void setElement(byte type) {
        this._element = type;
        this._boni.setElement(type);
    }

    public int getValue() {
        return this._value;
    }

    public void setValue(int val) {
        this._value = val;
        this._boni.setValue(val);
    }

    public static String getElementName(byte element) {
        switch (element) {
            case 0: {
                return "\u706b";
            }
            case 1: {
                return "\u6c34";
            }
            case 2: {
                return "\u98a8";
            }
            case 3: {
                return "\u5730";
            }
            case 5: {
                return "\u95c7";
            }
            case 4: {
                return "\u8056";
            }
        }
        return "None";
    }

    public static byte getElementId(String name) {
        String tmp = name.toLowerCase();
        if (tmp.equals("fire") || tmp.equals("\u706b")) {
            return 0;
        }
        if (tmp.equals("water") || tmp.equals("\u6c34")) {
            return 1;
        }
        if (tmp.equals("wind") || tmp.equals("\u98a8")) {
            return 2;
        }
        if (tmp.equals("earth") || tmp.equals("\u5730")) {
            return 3;
        }
        if (tmp.equals("dark") || tmp.equals("\u95c7")) {
            return 5;
        }
        if (tmp.equals("holy") || tmp.equals("\u8056")) {
            return 4;
        }
        return -1;
    }

    public static byte getOppositeElement(byte element) {
        return (byte)(element % 2 == 0 ? element + 1 : element - 1);
    }

    public String toString() {
        return Elementals.getElementName(this._element) + " +" + this._value;
    }

    public Elementals(byte type, int value) {
        this._element = type;
        this._value = value;
        this._boni = new ElementalStatBoni(this._element, this._value);
    }

    public void applyBonus(L2PcInstance player, boolean isArmor) {
        this._boni.applyBonus(player, isArmor);
    }

    public void removeBonus(L2PcInstance player) {
        this._boni.removeBonus(player);
    }

    public void updateBonus(L2PcInstance player, boolean isArmor) {
        this._boni.removeBonus(player);
        this._boni.applyBonus(player, isArmor);
    }

    public class ElementalStatBoni {
        private byte _elementalType;
        private int _elementalValue;
        private boolean _active;

        public ElementalStatBoni(byte type, int value) {
            this._elementalType = type;
            this._elementalValue = value;
            this._active = false;
        }

        public void applyBonus(L2PcInstance player, boolean isArmor) {
            if (this._active) {
                return;
            }
            switch (this._elementalType) {
                case 0: {
                    player.addStatFunc(new FuncAdd(isArmor ? Stats.FIRE_RES : Stats.FIRE_POWER, 64, this, new LambdaConst(this._elementalValue)));
                    break;
                }
                case 1: {
                    player.addStatFunc(new FuncAdd(isArmor ? Stats.WATER_RES : Stats.WATER_POWER, 64, this, new LambdaConst(this._elementalValue)));
                    break;
                }
                case 2: {
                    player.addStatFunc(new FuncAdd(isArmor ? Stats.WIND_RES : Stats.WIND_POWER, 64, this, new LambdaConst(this._elementalValue)));
                    break;
                }
                case 3: {
                    player.addStatFunc(new FuncAdd(isArmor ? Stats.EARTH_RES : Stats.EARTH_POWER, 64, this, new LambdaConst(this._elementalValue)));
                    break;
                }
                case 5: {
                    player.addStatFunc(new FuncAdd(isArmor ? Stats.DARK_RES : Stats.DARK_POWER, 64, this, new LambdaConst(this._elementalValue)));
                    break;
                }
                case 4: {
                    player.addStatFunc(new FuncAdd(isArmor ? Stats.HOLY_RES : Stats.HOLY_POWER, 64, this, new LambdaConst(this._elementalValue)));
                }
            }
            this._active = true;
        }

        public void removeBonus(L2PcInstance player) {
            if (!this._active) {
                return;
            }
            player.removeStatsOwner(this);
            this._active = false;
        }

        public void setValue(int val) {
            this._elementalValue = val;
        }

        public void setElement(byte type) {
            this._elementalType = type;
        }
    }
}

