/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.AugmentationData;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.funcs.FuncAdd;
import com.l2jserver.gameserver.skills.funcs.LambdaConst;
import javolution.util.FastList;

public final class L2Augmentation {
    private int _effectsId = 0;
    private AugmentationStatBoni _boni = null;
    private L2Skill _skill = null;

    public L2Augmentation(int effects, L2Skill skill) {
        this._effectsId = effects;
        this._boni = new AugmentationStatBoni(this._effectsId);
        this._skill = skill;
    }

    public L2Augmentation(int effects, int skill, int skillLevel) {
        this(effects, SkillTable.getInstance().getInfo(skill, skillLevel));
    }

    public int getAttributes() {
        return this._effectsId;
    }

    public int getAugmentationId() {
        return this._effectsId;
    }

    public L2Skill getSkill() {
        return this._skill;
    }

    public void applyBonus(L2PcInstance player) {
        boolean updateTimeStamp = false;
        this._boni.applyBonus(player);
        if (this._skill != null) {
            long delay;
            player.addSkill(this._skill);
            if (this._skill.isActive() && !player.getReuseTimeStamp().isEmpty() && player.getReuseTimeStamp().containsKey((Object)this._skill.getId()) && (delay = ((L2PcInstance.TimeStamp)player.getReuseTimeStamp().get((Object)this._skill.getId())).getRemaining()) > 0L) {
                player.disableSkill(this._skill, delay);
                updateTimeStamp = true;
            }
            player.sendSkillList();
            if (updateTimeStamp) {
                player.sendPacket(new SkillCoolTime(player));
            }
        }
    }

    public void removeBonus(L2PcInstance player) {
        this._boni.removeBonus(player);
        if (this._skill != null) {
            if (this._skill.isPassive()) {
                player.removeSkill(this._skill, false, true);
            } else {
                player.removeSkill(this._skill, false, false);
            }
            player.sendSkillList();
        }
    }

    public class AugmentationStatBoni {
        private Stats[] _stats;
        private float[] _values;
        private boolean _active = false;

        public AugmentationStatBoni(int augmentationId) {
            FastList<AugmentationData.AugStat> as = AugmentationData.getInstance().getAugStatsById(augmentationId);
            this._stats = new Stats[as.size()];
            this._values = new float[as.size()];
            int i = 0;
            for (AugmentationData.AugStat aStat : as) {
                this._stats[i] = aStat.getStat();
                this._values[i] = aStat.getValue();
                ++i;
            }
        }

        public void applyBonus(L2PcInstance player) {
            if (this._active) {
                return;
            }
            for (int i = 0; i < this._stats.length; ++i) {
                player.addStatFunc(new FuncAdd(this._stats[i], 64, this, new LambdaConst(this._values[i])));
            }
            this._active = true;
        }

        public void removeBonus(L2PcInstance player) {
            if (!this._active) {
                return;
            }
            player.removeStatsOwner(this);
            this._active = false;
        }
    }
}

