/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.type.L2DerbyTrackZone;
import com.l2jserver.gameserver.model.zone.type.L2PeaceZone;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class L2WorldRegion {
    private static Logger _log = Logger.getLogger(L2WorldRegion.class.getName());
    private Map<Integer, L2Playable> _allPlayable = new FastMap().shared();
    private Map<Integer, L2Object> _visibleObjects = new FastMap().shared();
    private List<L2WorldRegion> _surroundingRegions = new ArrayList<L2WorldRegion>();
    private int _tileX;
    private int _tileY;
    private boolean _active = false;
    private ScheduledFuture<?> _neighborsTask = null;
    private final FastList<L2ZoneType> _zones;

    public L2WorldRegion(int pTileX, int pTileY) {
        this._tileX = pTileX;
        this._tileY = pTileY;
        this._active = Config.GRIDS_ALWAYS_ON;
        this._zones = new FastList();
    }

    public FastList<L2ZoneType> getZones() {
        return this._zones;
    }

    public void addZone(L2ZoneType zone) {
        this._zones.add((Object)zone);
    }

    public void removeZone(L2ZoneType zone) {
        this._zones.remove((Object)zone);
    }

    public void revalidateZones(L2Character character) {
        if (character.isTeleporting()) {
            return;
        }
        for (L2ZoneType z : this.getZones()) {
            if (z == null) continue;
            z.revalidateInZone(character);
        }
    }

    public void removeFromZones(L2Character character) {
        for (L2ZoneType z : this.getZones()) {
            if (z == null) continue;
            z.removeCharacter(character);
        }
    }

    public boolean containsZone(int zoneId) {
        for (L2ZoneType z : this.getZones()) {
            if (z.getId() != zoneId) continue;
            return true;
        }
        return false;
    }

    public boolean checkEffectRangeInsidePeaceZone(L2Skill skill, int x, int y, int z) {
        int range = skill.getEffectRange();
        int up = y + range;
        int down = y - range;
        int left = x + range;
        int right = x - range;
        for (L2ZoneType e : this.getZones()) {
            if ((!(e instanceof L2TownZone) || !((L2TownZone)e).isPeaceZone()) && !(e instanceof L2DerbyTrackZone) && !(e instanceof L2PeaceZone)) continue;
            if (e.isInsideZone(x, up, z)) {
                return false;
            }
            if (e.isInsideZone(x, down, z)) {
                return false;
            }
            if (e.isInsideZone(left, y, z)) {
                return false;
            }
            if (e.isInsideZone(right, y, z)) {
                return false;
            }
            if (!e.isInsideZone(x, y, z)) continue;
            return false;
        }
        return true;
    }

    public void onDeath(L2Character character) {
        for (L2ZoneType z : this.getZones()) {
            if (z == null) continue;
            z.onDieInside(character);
        }
    }

    public void onRevive(L2Character character) {
        for (L2ZoneType z : this.getZones()) {
            if (z == null) continue;
            z.onReviveInside(character);
        }
    }

    private void switchAI(Boolean isOn) {
        int c = 0;
        if (!isOn.booleanValue()) {
            Collection<L2Object> vObj = this._visibleObjects.values();
            for (L2Object o : vObj) {
                if (o instanceof L2Attackable) {
                    ++c;
                    L2Attackable mob = (L2Attackable)o;
                    mob.setTarget(null);
                    mob.stopMove(null);
                    mob.stopAllEffects();
                    mob.clearAggroList();
                    mob.getAttackByList().clear();
                    mob.getKnownList().removeAllKnownObjects();
                    if (!mob.hasAI()) continue;
                    mob.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    mob.getAI().stopAITask();
                    continue;
                }
                if (!(o instanceof L2Vehicle)) continue;
                ++c;
                ((L2Vehicle)o).getKnownList().removeAllKnownObjects();
            }
            _log.fine(c + " mobs were turned off");
        } else {
            Collection<L2Object> vObj = this._visibleObjects.values();
            for (L2Object o : vObj) {
                if (o instanceof L2Attackable) {
                    ++c;
                    ((L2Attackable)o).getStatus().startHpMpRegeneration();
                    continue;
                }
                if (!(o instanceof L2Npc)) continue;
                ((L2Npc)o).startRandomAnimationTimer();
            }
            _log.fine(c + " mobs were turned on");
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public boolean areNeighborsEmpty() {
        if (this.isActive() && !this._allPlayable.isEmpty()) {
            return false;
        }
        for (L2WorldRegion neighbor : this._surroundingRegions) {
            if (!neighbor.isActive() || neighbor._allPlayable.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setActive(boolean value) {
        if (this._active == value) {
            return;
        }
        this._active = value;
        this.switchAI(value);
        if (value) {
            _log.fine("Starting Grid " + this._tileX + "," + this._tileY);
        } else {
            _log.fine("Stoping Grid " + this._tileX + "," + this._tileY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startActivation() {
        this.setActive(true);
        L2WorldRegion l2WorldRegion = this;
        synchronized (l2WorldRegion) {
            if (this._neighborsTask != null) {
                this._neighborsTask.cancel(true);
                this._neighborsTask = null;
            }
            this._neighborsTask = ThreadPoolManager.getInstance().scheduleGeneral(new NeighborsTask(true), 1000 * Config.GRID_NEIGHBOR_TURNON_TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDeactivation() {
        L2WorldRegion l2WorldRegion = this;
        synchronized (l2WorldRegion) {
            if (this._neighborsTask != null) {
                this._neighborsTask.cancel(true);
                this._neighborsTask = null;
            }
            this._neighborsTask = ThreadPoolManager.getInstance().scheduleGeneral(new NeighborsTask(false), 1000 * Config.GRID_NEIGHBOR_TURNOFF_TIME);
        }
    }

    public void addVisibleObject(L2Object object) {
        assert (object == null || object.getWorldRegion() == this);
        if (object == null) {
            return;
        }
        this._visibleObjects.put(object.getObjectId(), object);
        if (object instanceof L2Playable) {
            this._allPlayable.put(object.getObjectId(), (L2Playable)object);
            if (this._allPlayable.size() == 1 && !Config.GRIDS_ALWAYS_ON) {
                this.startActivation();
            }
        }
    }

    public void removeVisibleObject(L2Object object) {
        assert (object == null || object.getWorldRegion() == this || object.getWorldRegion() == null);
        if (object == null) {
            return;
        }
        this._visibleObjects.remove(object.getObjectId());
        if (object instanceof L2Playable) {
            this._allPlayable.remove(object.getObjectId());
            if (this._allPlayable.isEmpty() && !Config.GRIDS_ALWAYS_ON) {
                this.startDeactivation();
            }
        }
    }

    public void addSurroundingRegion(L2WorldRegion region) {
        this._surroundingRegions.add(region);
    }

    public List<L2WorldRegion> getSurroundingRegions() {
        return this._surroundingRegions;
    }

    public Map<Integer, L2Playable> getVisiblePlayable() {
        return this._allPlayable;
    }

    public Map<Integer, L2Object> getVisibleObjects() {
        return this._visibleObjects;
    }

    public String getName() {
        return "(" + this._tileX + ", " + this._tileY + ")";
    }

    public void deleteVisibleNpcSpawns() {
        _log.fine("Deleting all visible NPC's in Region: " + this.getName());
        Collection<L2Object> vNPC = this._visibleObjects.values();
        for (L2Object obj : vNPC) {
            if (!(obj instanceof L2Npc)) continue;
            L2Npc target = (L2Npc)obj;
            target.deleteMe();
            L2Spawn spawn = target.getSpawn();
            if (spawn != null) {
                spawn.stopRespawn();
                SpawnTable.getInstance().deleteSpawn(spawn, false);
            }
            _log.finest("Removed NPC " + target.getObjectId());
        }
        _log.info("All visible NPC's deleted in Region: " + this.getName());
    }

    public class NeighborsTask
    implements Runnable {
        private boolean _isActivating;

        public NeighborsTask(boolean isActivating) {
            this._isActivating = isActivating;
        }

        @Override
        public void run() {
            if (this._isActivating) {
                for (L2WorldRegion neighbor : L2WorldRegion.this.getSurroundingRegions()) {
                    neighbor.setActive(true);
                }
            } else {
                if (L2WorldRegion.this.areNeighborsEmpty()) {
                    L2WorldRegion.this.setActive(false);
                }
                for (L2WorldRegion neighbor : L2WorldRegion.this.getSurroundingRegions()) {
                    if (!neighbor.areNeighborsEmpty()) continue;
                    neighbor.setActive(false);
                }
            }
        }
    }
}

