/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2XmassTreeInstance;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Collection;

public class L2KotatsuInstance
extends L2XmassTreeInstance {
    public L2KotatsuInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this._aiTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new KotatsuAI(this), 3000L, 3000L);
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        return 90;
    }

    private class KotatsuAI
    extends L2XmassTreeInstance.XmassAI
    implements Runnable {
        protected KotatsuAI(L2KotatsuInstance caster) {
            super(L2KotatsuInstance.this, caster);
        }

        @Override
        public void run() {
            Collection<L2PcInstance> plrs = L2KotatsuInstance.this.getKnownList().getKnownPlayersInRadius(L2KotatsuInstance.this.getDistanceToWatchObject(null));
            for (L2PcInstance player : plrs) {
                if (player.isMovementDisabled() || player.getPkKills() > 5) continue;
                if (player.getCurrentHp() < (double)(player.getMaxHp() * 9 / 10)) {
                    player.setCurrentHp(player.getCurrentHp() + (double)(player.getMaxHp() / player.getLevel()));
                }
                if (player.getCurrentCp() < (double)(player.getMaxCp() * 9 / 10)) {
                    player.setCurrentCp(player.getCurrentHp() + (double)(player.getMaxCp() / player.getLevel()));
                }
                if (!(player.getCurrentMp() < (double)(player.getMaxMp() * 9 / 10))) continue;
                player.setCurrentMp(player.getCurrentMp() + (double)(player.getMaxMp() / player.getLevel()));
            }
        }
    }
}

