/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;

public class L2PenaltyMonsterInstance
extends L2MonsterInstance {
    private L2PcInstance _ptk;

    public L2PenaltyMonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2PenaltyMonsterInstance);
    }

    @Override
    public L2Character getMostHated() {
        if (this._ptk != null) {
            return this._ptk;
        }
        return super.getMostHated();
    }

    public void setPlayerToKill(L2PcInstance ptk) {
        if (Rnd.get(100) <= 80) {
            CreatureSay cs = new CreatureSay(this.getObjectId(), 0, this.getName(), "mmm your bait was delicious");
            this.broadcastPacket(cs);
        }
        this._ptk = ptk;
        this.addDamageHate(ptk, 0, 10);
        this.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, ptk);
        this.addAttackerToAttackByList(ptk);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (Rnd.get(100) <= 75) {
            CreatureSay cs = new CreatureSay(this.getObjectId(), 0, this.getName(), "I will tell fishes not to take your bait");
            this.broadcastPacket(cs);
        }
        return true;
    }
}

