/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.OlympiadGame;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMatchEnd;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadUserInfo;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

class OlympiadGameTask
implements Runnable {
    protected static final Logger _log = Logger.getLogger(OlympiadGameTask.class.getName());
    public OlympiadGame _game = null;
    protected static final long BATTLE_PERIOD = Config.ALT_OLY_BATTLE;
    private boolean _terminated = false;
    private boolean _started = false;

    public boolean isTerminated() {
        return this._terminated || this._game._aborted;
    }

    public boolean isStarted() {
        return this._started;
    }

    public OlympiadGameTask(OlympiadGame game) {
        this._game = game;
    }

    protected boolean checkBattleStatus() {
        boolean _pTwoCrash;
        boolean _pOneCrash = this._game._playerOne == null || this._game._playerOneDisconnected;
        boolean bl = _pTwoCrash = this._game._playerTwo == null || this._game._playerTwoDisconnected;
        return !_pOneCrash && !_pTwoCrash && !this._game._aborted;
    }

    protected boolean checkDefaulted() {
        this._game._playerOne = L2World.getInstance().getPlayer(this._game._playerOneID);
        this._game._players.set(0, this._game._playerOne);
        this._game._playerTwo = L2World.getInstance().getPlayer(this._game._playerTwoID);
        this._game._players.set(1, this._game._playerTwo);
        for (int i = 0; i < 2; ++i) {
            boolean defaulted = false;
            L2PcInstance player = (L2PcInstance)this._game._players.get(i);
            if (player != null) {
                player.setOlympiadGameId(this._game._stadiumID);
            }
            L2PcInstance otherPlayer = (L2PcInstance)this._game._players.get(i ^ 1);
            SystemMessage sm = null;
            if (player == null) {
                defaulted = true;
            } else if (player.isDead()) {
                sm = new SystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_OLYMPIAD_WHILE_DEAD);
                sm.addPcName(player);
                defaulted = true;
            } else if (player.isSubClassActive()) {
                sm = new SystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_WHILE_CHANGED_TO_SUB_CLASS);
                sm.addPcName(player);
                defaulted = true;
            } else if (player.isCursedWeaponEquipped()) {
                sm = new SystemMessage(SystemMessageId.C1_CANNOT_JOIN_OLYMPIAD_POSSESSING_S2);
                sm.addPcName(player);
                sm.addItemName(player.getCursedWeaponEquippedId());
                defaulted = true;
            } else if ((double)player.getInventoryLimit() * 0.8 <= (double)player.getInventory().getSize()) {
                sm = new SystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_INVENTORY_SLOT_EXCEEDS_80_PERCENT);
                sm.addPcName(player);
                defaulted = true;
            }
            if (!defaulted) continue;
            if (player != null) {
                player.sendPacket(sm);
            }
            if (otherPlayer != null) {
                otherPlayer.sendPacket(new SystemMessage(SystemMessageId.THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_DOES_NOT_MEET_THE_REQUIREMENTS_FOR_JOINING_THE_GAME));
            }
            if (i == 0) {
                this._game._playerOneDefaulted = true;
                continue;
            }
            this._game._playerTwoDefaulted = true;
        }
        return this._game._playerOneDefaulted || this._game._playerTwoDefaulted;
    }

    @Override
    public void run() {
        this._started = true;
        if (this._game != null) {
            if (this._game._playerOne == null || this._game._playerTwo == null) {
                return;
            }
            if (this.teleportCountdown()) {
                this.runGame();
            }
            this._terminated = true;
            this._game.validateWinner();
            this._game.PlayersStatusBack();
            this._game.cleanEffects();
            if (this._game._gamestarted) {
                this._game._gamestarted = false;
                OlympiadManager.STADIUMS[this._game._stadiumID].closeDoors();
                try {
                    this._game.portPlayersBack();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Exception on portPlayersBack(): " + e.getMessage(), e);
                }
            }
            if (OlympiadManager.STADIUMS[this._game._stadiumID].getSpectators() != null) {
                for (L2PcInstance spec : OlympiadManager.STADIUMS[this._game._stadiumID].getSpectators()) {
                    if (spec == null) continue;
                    spec.sendPacket(new ExOlympiadMatchEnd());
                }
            }
            if (this._game._spawnOne != null) {
                this._game._spawnOne.getLastSpawn().deleteMe();
                this._game._spawnOne = null;
            }
            if (this._game._spawnTwo != null) {
                this._game._spawnTwo.getLastSpawn().deleteMe();
                this._game._spawnTwo = null;
            }
            this._game.clearPlayers();
            OlympiadManager.getInstance().removeGame(this._game);
            this._game = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runGame() {
        if (this.checkDefaulted()) {
            return false;
        }
        OlympiadManager.STADIUMS[this._game._stadiumID].closeDoors();
        this._game.portPlayersToArena();
        this._game.removals();
        if (Config.ALT_OLY_ANNOUNCE_GAMES) {
            this._game.announceGame();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        OlympiadGameTask e = this;
        synchronized (e) {
            if (!OlympiadGame._battleStarted) {
                OlympiadGame._battleStarted = true;
            }
        }
        int step = 10;
        int i = 60;
        while (i > 0) {
            SystemMessage sm = new SystemMessage(SystemMessageId.THE_GAME_WILL_START_IN_S1_SECOND_S);
            sm.addNumber(i);
            this._game.broadcastMessage(sm, true);
            switch (i) {
                case 10: {
                    this._game._damageP1 = 0;
                    this._game._damageP2 = 0;
                    OlympiadManager.STADIUMS[this._game._stadiumID].openDoors();
                    step = 5;
                    break;
                }
                case 5: {
                    step = 1;
                }
            }
            try {
                Thread.sleep(step * 1000);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            i = (byte)(i - step);
        }
        if (!this.checkBattleStatus()) {
            return false;
        }
        this._game._spawnOne.getLastSpawn().deleteMe();
        this._game._spawnTwo.getLastSpawn().deleteMe();
        this._game._spawnOne = null;
        this._game._spawnTwo = null;
        if (!this._game.makeCompetitionStart()) {
            return false;
        }
        this._game._playerOne.sendPacket(new ExOlympiadUserInfo(this._game._playerOne));
        this._game._playerOne.sendPacket(new ExOlympiadUserInfo(this._game._playerTwo));
        this._game._playerTwo.sendPacket(new ExOlympiadUserInfo(this._game._playerTwo));
        this._game._playerTwo.sendPacket(new ExOlympiadUserInfo(this._game._playerOne));
        if (OlympiadManager.STADIUMS[this._game._stadiumID].getSpectators() != null) {
            for (L2PcInstance spec : OlympiadManager.STADIUMS[this._game._stadiumID].getSpectators()) {
                if (spec == null) continue;
                spec.sendPacket(new ExOlympiadUserInfo(this._game._playerOne));
                spec.sendPacket(new ExOlympiadUserInfo(this._game._playerTwo));
            }
        }
        i = 0;
        while ((long)i < BATTLE_PERIOD) {
            try {
                Thread.sleep(10000L);
                if (this._game.haveWinner()) {
                    break;
                }
            }
            catch (InterruptedException e3) {
                // empty catch block
            }
            i += 10000;
        }
        return this.checkBattleStatus();
    }

    private boolean teleportCountdown() {
        int step = 60;
        byte i = Config.ALT_OLY_WAIT_TIME;
        while (i > 0) {
            SystemMessage sm = new SystemMessage(SystemMessageId.YOU_WILL_ENTER_THE_OLYMPIAD_STADIUM_IN_S1_SECOND_S);
            sm.addNumber(i);
            this._game.broadcastMessage(sm, false);
            switch (i) {
                case 60: {
                    step = 30;
                    break;
                }
                case 30: {
                    step = 15;
                    break;
                }
                case 15: {
                    step = 5;
                    break;
                }
                case 5: {
                    step = 1;
                }
            }
            try {
                Thread.sleep(step * 1000);
            }
            catch (InterruptedException e) {
                return false;
            }
            i = (byte)(i - step);
        }
        return true;
    }
}

