/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.BlowFishKeygen;
import com.l2jserver.gameserver.network.GameCrypt;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import com.l2jserver.gameserver.util.FloodProtectors;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.EventData;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.util.FastList;
import org.mmocore.network.MMOClient;
import org.mmocore.network.MMOConnection;
import org.mmocore.network.SendablePacket;

public final class L2GameClient
extends MMOClient<MMOConnection<L2GameClient>> {
    protected static final Logger _log = Logger.getLogger(L2GameClient.class.getName());
    protected static final Logger _logAccounting = Logger.getLogger("accounting");
    public GameClientState state;
    private String _accountName;
    private LoginServerThread.SessionKey _sessionId;
    private L2PcInstance _activeChar;
    private ReentrantLock _activeCharLock = new ReentrantLock();
    private boolean _isAuthedGG;
    private long _connectionStartTime;
    private List<Integer> _charSlotMapping = new FastList();
    private final FloodProtectors _floodProtectors = new FloodProtectors(this);
    protected final ScheduledFuture<?> _autoSaveInDB;
    protected ScheduledFuture<?> _cleanupTask = null;
    private GameCrypt _crypt;
    public byte packetsSentInSec = 0;
    public int packetsSentStartTick = 0;
    public byte underflowReadsInMin = 0;
    public int underflowReadStartTick = 0;
    private boolean _isDetached = false;
    private boolean _protocol;
    private int[][] trace;

    public L2GameClient(MMOConnection<L2GameClient> con) {
        super(con);
        this.state = GameClientState.CONNECTED;
        this._connectionStartTime = System.currentTimeMillis();
        this._crypt = new GameCrypt();
        this._autoSaveInDB = Config.CHAR_STORE_INTERVAL > 0 ? ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new AutoSaveTask(), 300000L, (long)Config.CHAR_STORE_INTERVAL * 60000L) : null;
    }

    public byte[] enableCrypt() {
        byte[] key = BlowFishKeygen.getRandomKey();
        this._crypt.setKey(key);
        return key;
    }

    public GameClientState getState() {
        return this.state;
    }

    public void setState(GameClientState pState) {
        this.state = pState;
    }

    public long getConnectionStartTime() {
        return this._connectionStartTime;
    }

    public boolean decrypt(ByteBuffer buf, int size) {
        this._crypt.decrypt(buf.array(), buf.position(), size);
        return true;
    }

    public boolean encrypt(ByteBuffer buf, int size) {
        this._crypt.encrypt(buf.array(), buf.position(), size);
        buf.position(buf.position() + size);
        return true;
    }

    public L2PcInstance getActiveChar() {
        return this._activeChar;
    }

    public void setActiveChar(L2PcInstance pActiveChar) {
        this._activeChar = pActiveChar;
        if (this._activeChar != null) {
            L2World.getInstance().storeObject(this.getActiveChar());
        }
    }

    public ReentrantLock getActiveCharLock() {
        return this._activeCharLock;
    }

    public FloodProtectors getFloodProtectors() {
        return this._floodProtectors;
    }

    public void setGameGuardOk(boolean val) {
        this._isAuthedGG = val;
    }

    public boolean isAuthedGG() {
        return this._isAuthedGG;
    }

    public void setAccountName(String pAccountName) {
        this._accountName = pAccountName;
    }

    public String getAccountName() {
        return this._accountName;
    }

    public void setSessionId(LoginServerThread.SessionKey sk) {
        this._sessionId = sk;
    }

    public LoginServerThread.SessionKey getSessionId() {
        return this._sessionId;
    }

    public void sendPacket(L2GameServerPacket gsp) {
        if (this._isDetached) {
            return;
        }
        if (gsp.isInvisible() && this.getActiveChar() != null && !this.getActiveChar().isGM()) {
            return;
        }
        this.getConnection().sendPacket((SendablePacket)gsp);
        gsp.runImpl();
    }

    public boolean isDetached() {
        return this._isDetached;
    }

    public void setDetached(boolean b) {
        this._isDetached = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte markToDeleteChar(int charslot) {
        int objid = this.getObjectIdForSlot(charslot);
        if (objid < 0) {
            return -1;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clanId FROM characters WHERE charId=?");
            statement.setInt(1, objid);
            ResultSet rs = statement.executeQuery();
            rs.next();
            int clanId = rs.getInt(1);
            byte answer = 0;
            if (clanId != 0) {
                L2Clan clan = ClanTable.getInstance().getClan(clanId);
                answer = clan == null ? (byte)0 : (clan.getLeaderId() == objid ? (byte)2 : 1);
            }
            rs.close();
            statement.close();
            if (answer == 0) {
                if (Config.DELETE_DAYS == 0) {
                    L2GameClient.deleteCharByObjId(objid);
                } else {
                    statement = con.prepareStatement("UPDATE characters SET deletetime=? WHERE charId=?");
                    statement.setLong(1, System.currentTimeMillis() + (long)Config.DELETE_DAYS * 86400000L);
                    statement.setInt(2, objid);
                    statement.execute();
                    statement.close();
                }
                LogRecord record = new LogRecord(Level.WARNING, "Delete");
                record.setParameters(new Object[]{objid, this});
                _logAccounting.log(record);
            }
            byte by = answer;
            return by;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error updating delete time of character.", e);
            byte by = -1;
            return by;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public static void saveCharToDisk(L2PcInstance cha, boolean storeItems) {
        try {
            cha.store();
            if (Config.UPDATE_ITEMS_ON_CHAR_STORE && storeItems) {
                cha.getInventory().updateDatabase();
                cha.getWarehouse().updateDatabase();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error saving character..", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRestoredChar(int charslot) throws Exception {
        int objid = this.getObjectIdForSlot(charslot);
        if (objid < 0) {
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE characters SET deletetime=0 WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring character.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        LogRecord record = new LogRecord(Level.WARNING, "Restore");
        record.setParameters(new Object[]{objid, this});
        _logAccounting.log(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCharByObjId(int objid) {
        if (objid < 0) {
            return;
        }
        CharNameTable.getInstance().removeName(objid);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_friends WHERE charId=? OR friendId=?");
            statement.setInt(1, objid);
            statement.setInt(2, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_hennas WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_macroses WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_quests WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_quest_global_data WHERE charId=?");
            statement.setInt(1, objid);
            statement.executeUpdate();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_recipebook WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_shortcuts WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_skills WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_skills_save WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_subclasses WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM heroes WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM olympiad_nobles WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM seven_signs WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id IN (SELECT object_id FROM items WHERE items.owner_id=?)");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM item_attributes WHERE itemId IN (SELECT object_id FROM items WHERE items.owner_id=?)");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM items WHERE owner_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM merchant_lease WHERE player_id=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_raid_points WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_recommends WHERE charId=? OR target_id=?");
            statement.setInt(1, objid);
            statement.setInt(2, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_instance_time WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM characters WHERE charId=?");
            statement.setInt(1, objid);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error deleting character.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public L2PcInstance loadCharFromDisk(int charslot) {
        L2PcInstance character = L2PcInstance.load(this.getObjectIdForSlot(charslot));
        if (character != null) {
            character.setRunning();
            character.standUp();
            character.refreshOverloaded();
            character.refreshExpertisePenalty();
            character.setOnlineStatus(true);
        } else {
            _log.severe("could not restore in slot: " + charslot);
        }
        return character;
    }

    public void setCharSelection(CharSelectInfoPackage[] chars) {
        this._charSlotMapping.clear();
        for (int i = 0; i < chars.length; ++i) {
            int objectId = chars[i].getObjectId();
            this._charSlotMapping.add(objectId);
        }
    }

    public void close(L2GameServerPacket gsp) {
        this.getConnection().close((SendablePacket)gsp);
    }

    private int getObjectIdForSlot(int charslot) {
        if (charslot < 0 || charslot >= this._charSlotMapping.size()) {
            _log.warning(this.toString() + " tried to delete Character in slot " + charslot + " but no characters exits at that slot.");
            return -1;
        }
        Integer objectId = this._charSlotMapping.get(charslot);
        return objectId;
    }

    protected void onForcedDisconnection() {
        LogRecord record = new LogRecord(Level.WARNING, "Disconnected abnormally");
        record.setParameters(new Object[]{this});
        _logAccounting.log(record);
    }

    protected void onDisconnection() {
        try {
            ThreadPoolManager.getInstance().executeTask(new DisconnectTask());
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void closeNow() {
        super.getConnection().close((SendablePacket)ServerClose.STATIC_PACKET);
        this.cleanMe(true);
    }

    public String toString() {
        try {
            InetAddress address = this.getConnection().getInetAddress();
            switch (this.getState()) {
                case CONNECTED: {
                    return "[IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
                }
                case AUTHED: {
                    return "[Account: " + this.getAccountName() + " - IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
                }
                case IN_GAME: {
                    return "[Character: " + (this.getActiveChar() == null ? "disconnected" : this.getActiveChar().getName() + "[" + this.getActiveChar().getObjectId() + "]") + " - Account: " + this.getAccountName() + " - IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
                }
            }
            throw new IllegalStateException("Missing state on switch");
        }
        catch (NullPointerException e) {
            return "[Character read failed due to disconnect]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanMe(boolean fast) {
        try {
            L2GameClient l2GameClient = this;
            synchronized (l2GameClient) {
                if (this._cleanupTask == null) {
                    this._cleanupTask = ThreadPoolManager.getInstance().scheduleGeneral(new CleanupTask(), fast ? 5L : 15000L);
                }
            }
        }
        catch (Exception e1) {
            _log.log(Level.WARNING, "Error during cleanup.", e1);
        }
    }

    public boolean isProtocolOk() {
        return this._protocol;
    }

    public void setProtocolOk(boolean b) {
        this._protocol = b;
    }

    public boolean handleCheat(String punishment) {
        if (this._activeChar != null) {
            Util.handleIllegalPlayerAction(this._activeChar, this.toString() + ": " + punishment, Config.DEFAULT_PUNISH);
            return true;
        }
        Logger _logAudit = Logger.getLogger("audit");
        _logAudit.log(Level.INFO, "AUDIT: Client " + this.toString() + " kicked for reason: " + punishment);
        this.closeNow();
        return false;
    }

    public void setClientTracert(int[][] tracert) {
        this.trace = tracert;
    }

    public int[][] getTrace() {
        return this.trace;
    }

    class AutoSaveTask
    implements Runnable {
        AutoSaveTask() {
        }

        @Override
        public void run() {
            try {
                L2PcInstance player = L2GameClient.this.getActiveChar();
                if (player != null && player.isOnline() > 0) {
                    L2GameClient.saveCharToDisk(player, true);
                    if (player.getPet() != null) {
                        player.getPet().store();
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error on AutoSaveTask.", e);
            }
        }
    }

    class CleanupTask
    implements Runnable {
        CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                L2PcInstance player;
                if (L2GameClient.this._autoSaveInDB != null) {
                    L2GameClient.this._autoSaveInDB.cancel(true);
                    ThreadPoolManager.getInstance().removeGeneral((Runnable)((Object)L2GameClient.this._autoSaveInDB));
                }
                if ((player = L2GameClient.this.getActiveChar()) != null) {
                    if (player.isLocked()) {
                        _log.log(Level.WARNING, "Player " + player.getName() + " still performing subclass actions during disconnect.");
                    }
                    if (player.atEvent) {
                        EventData data = new EventData(player.eventX, player.eventY, player.eventZ, player.eventkarma, player.eventpvpkills, player.eventpkkills, player.eventTitle, player.kills, player.eventSitForced);
                        L2Event.connectionLossData.put(player.getName(), data);
                    }
                    L2GameClient.this.setDetached(false);
                    player.setClient(null);
                    if (player.isOnline() > 0) {
                        player.logout();
                    }
                }
                L2GameClient.this.setActiveChar(null);
            }
            catch (Exception e1) {
                _log.log(Level.WARNING, "Error while cleanup client.", e1);
            }
            finally {
                LoginServerThread.getInstance().sendLogout(L2GameClient.this.getAccountName());
            }
        }
    }

    class DisconnectTask
    implements Runnable {
        DisconnectTask() {
        }

        @Override
        public void run() {
            boolean fast = true;
            try {
                L2PcInstance player = L2GameClient.this.getActiveChar();
                if (player != null && !L2GameClient.this.isDetached()) {
                    L2GameClient.this.setDetached(true);
                    if (!player.isInOlympiadMode() && !player.isFestivalParticipant() && !TvTEvent.isPlayerParticipant(player.getObjectId()) && !player.isInJail() && player.getVehicle() == null && (player.isInStoreMode() && Config.OFFLINE_TRADE_ENABLE || player.isInCraftMode() && Config.OFFLINE_CRAFT_ENABLE)) {
                        player.leaveParty();
                        if (Config.OFFLINE_SET_NAME_COLOR) {
                            player.getAppearance().setNameColor(Config.OFFLINE_NAME_COLOR);
                            player.broadcastUserInfo();
                        }
                        if (player.getOfflineStartTime() == 0L) {
                            player.setOfflineStartTime(System.currentTimeMillis());
                        }
                        LogRecord record = new LogRecord(Level.INFO, "Entering offline mode");
                        record.setParameters(new Object[]{L2GameClient.this});
                        _logAccounting.log(record);
                        return;
                    }
                    if (player.isInCombat() || player.isLocked()) {
                        fast = false;
                    }
                }
                L2GameClient.this.cleanMe(fast);
            }
            catch (Exception e1) {
                _log.log(Level.WARNING, "Error while disconnecting client.", e1);
            }
        }
    }

    public static enum GameClientState {
        CONNECTED,
        AUTHED,
        IN_GAME;

    }
}

