/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.AbstractEnchantPacket;
import com.l2jserver.gameserver.network.serverpackets.EnchantResult;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class RequestEnchantItem
extends AbstractEnchantPacket {
    protected static final Logger _log = Logger.getLogger(RequestEnchantItem.class.getName());
    protected static final Logger _logEnchant = Logger.getLogger("enchant");
    private static final String _C__58_REQUESTENCHANTITEM = "[C] 58 RequestEnchantItem";
    private int _objectId = 0;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || this._objectId == 0) {
            return;
        }
        if (activeChar.isOnline() == 0 || ((L2GameClient)this.getClient()).isDetached()) {
            activeChar.setActiveEnchantItem(null);
            return;
        }
        if (activeChar.isProcessingTransaction() || activeChar.isInStoreMode()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_ENCHANT_WHILE_STORE));
            activeChar.setActiveEnchantItem(null);
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
        L2ItemInstance scroll = activeChar.getActiveEnchantItem();
        L2ItemInstance support = activeChar.getActiveEnchantSupportItem();
        if (item == null || scroll == null) {
            activeChar.setActiveEnchantItem(null);
            return;
        }
        AbstractEnchantPacket.EnchantScroll scrollTemplate = RequestEnchantItem.getEnchantScroll(scroll);
        if (scrollTemplate == null) {
            return;
        }
        AbstractEnchantPacket.EnchantItem supportTemplate = null;
        if (support != null) {
            supportTemplate = RequestEnchantItem.getSupportItem(support);
        }
        if (!scrollTemplate.isValid(item, supportTemplate) || !RequestEnchantItem.isEnchantable(item)) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION));
            activeChar.setActiveEnchantItem(null);
            activeChar.sendPacket(new EnchantResult(2, 0, 0));
            return;
        }
        if (item.getItem().getType2() == 0 && item.getItemType() == L2WeaponType.ROD) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION));
            return;
        }
        if (activeChar.getActiveEnchantTimestamp() == 0L || System.currentTimeMillis() - activeChar.getActiveEnchantTimestamp() < 2000L) {
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " use autoenchant program ", Config.DEFAULT_PUNISH);
            activeChar.setActiveEnchantItem(null);
            activeChar.sendPacket(new EnchantResult(2, 0, 0));
            return;
        }
        scroll = activeChar.getInventory().destroyItem("Enchant", scroll.getObjectId(), 1L, activeChar, (L2Object)item);
        if (scroll == null) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_ITEMS));
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to enchant with a scroll he doesn't have", Config.DEFAULT_PUNISH);
            activeChar.setActiveEnchantItem(null);
            activeChar.sendPacket(new EnchantResult(2, 0, 0));
            return;
        }
        activeChar.sendPacket(new SystemMessage(SystemMessageId.S1_DISAPPEARED).addItemName(scroll));
        if (support != null && (support = activeChar.getInventory().destroyItem("Enchant", support.getObjectId(), 1L, activeChar, (L2Object)item)) == null) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_ITEMS));
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to enchant with a support item he doesn't have", Config.DEFAULT_PUNISH);
            activeChar.setActiveEnchantItem(null);
            activeChar.sendPacket(new EnchantResult(2, 0, 0));
            return;
        }
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            int chance = scrollTemplate.getChance(item, supportTemplate);
            L2Skill enchant4Skill = null;
            L2Item it = item.getItem();
            if (item.getOwnerId() != activeChar.getObjectId() || !RequestEnchantItem.isEnchantable(item) || chance < 0) {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION));
                activeChar.setActiveEnchantItem(null);
                activeChar.sendPacket(new EnchantResult(2, 0, 0));
                return;
            }
            if (Rnd.get(100) < chance) {
                int maxEnchantAnnounce;
                item.setEnchantLevel(item.getEnchantLevel() + 1);
                item.updateDatabase();
                activeChar.sendPacket(new EnchantResult(0, 0, 0));
                if (Config.LOG_ITEM_ENCHANTS) {
                    LogRecord record = new LogRecord(Level.INFO, "Success");
                    record.setParameters(new Object[]{activeChar, item, scroll, support, chance});
                    record.setLoggerName("item");
                    _logEnchant.log(record);
                }
                int minEnchantAnnounce = item.isArmor() ? 6 : 7;
                int n = maxEnchantAnnounce = item.isArmor() ? 0 : 15;
                if (item.getEnchantLevel() == minEnchantAnnounce || item.getEnchantLevel() == maxEnchantAnnounce) {
                    SystemMessage sm = new SystemMessage(SystemMessageId.C1_SUCCESSFULY_ENCHANTED_A_S2_S3);
                    sm.addCharName(activeChar);
                    sm.addNumber(item.getEnchantLevel());
                    sm.addItemName(item);
                    activeChar.broadcastPacket(sm);
                    L2Skill skill = SkillTable.FrequentSkill.FIREWORK.getSkill();
                    if (skill != null) {
                        activeChar.broadcastPacket(new MagicSkillUse(activeChar, activeChar, skill.getId(), skill.getLevel(), skill.getHitTime(), skill.getReuseDelay()));
                    }
                }
                if (it instanceof L2Armor && item.getEnchantLevel() == 4 && activeChar.getInventory().getItemByObjectId(item.getObjectId()).isEquipped() && (enchant4Skill = ((L2Armor)it).getEnchant4Skill()) != null) {
                    activeChar.addSkill(enchant4Skill, false);
                    activeChar.sendSkillList();
                }
            } else if (scrollTemplate.isSafe()) {
                activeChar.sendPacket(new EnchantResult(5, 0, 0));
                if (Config.LOG_ITEM_ENCHANTS) {
                    LogRecord record = new LogRecord(Level.INFO, "Safe Fail");
                    record.setParameters(new Object[]{activeChar, item, scroll, support, chance});
                    record.setLoggerName("item");
                    _logEnchant.log(record);
                }
            } else {
                if (item.isEquipped()) {
                    SystemMessage sm;
                    if (item.getEnchantLevel() > 0) {
                        sm = new SystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                        sm.addNumber(item.getEnchantLevel());
                        sm.addItemName(item);
                        activeChar.sendPacket(sm);
                    } else {
                        sm = new SystemMessage(SystemMessageId.S1_DISARMED);
                        sm.addItemName(item);
                        activeChar.sendPacket(sm);
                    }
                    L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(item.getLocationSlot());
                    InventoryUpdate iu = new InventoryUpdate();
                    for (L2ItemInstance itm : unequiped) {
                        iu.addModifiedItem(itm);
                    }
                    activeChar.sendPacket(iu);
                    activeChar.broadcastUserInfo();
                }
                if (scrollTemplate.isBlessed()) {
                    activeChar.sendPacket(new SystemMessage(SystemMessageId.BLESSED_ENCHANT_FAILED));
                    item.setEnchantLevel(0);
                    item.updateDatabase();
                    activeChar.sendPacket(new EnchantResult(3, 0, 0));
                    if (Config.LOG_ITEM_ENCHANTS) {
                        LogRecord record = new LogRecord(Level.INFO, "Blessed Fail");
                        record.setParameters(new Object[]{activeChar, item, scroll, support, chance});
                        record.setLoggerName("item");
                        _logEnchant.log(record);
                    }
                } else {
                    L2ItemInstance destroyItem;
                    int crystalId = item.getItem().getCrystalItemId();
                    int count = item.getCrystalCount() - (item.getItem().getCrystalCount() + 1) / 2;
                    if (count < 1) {
                        count = 1;
                    }
                    if ((destroyItem = activeChar.getInventory().destroyItem("Enchant", item, activeChar, null)) == null) {
                        Util.handleIllegalPlayerAction(activeChar, "Unable to delete item on enchant failure from player " + activeChar.getName() + ", possible cheater !", Config.DEFAULT_PUNISH);
                        activeChar.setActiveEnchantItem(null);
                        activeChar.sendPacket(new EnchantResult(2, 0, 0));
                        if (Config.LOG_ITEM_ENCHANTS) {
                            LogRecord record = new LogRecord(Level.INFO, "Unable to destroy");
                            record.setParameters(new Object[]{activeChar, item, scroll, support, chance});
                            record.setLoggerName("item");
                            _logEnchant.log(record);
                        }
                        return;
                    }
                    L2ItemInstance crystals = null;
                    if (crystalId != 0) {
                        crystals = activeChar.getInventory().addItem("Enchant", crystalId, count, activeChar, destroyItem);
                        SystemMessage sm = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
                        sm.addItemName(crystals);
                        sm.addItemNumber(count);
                        activeChar.sendPacket(sm);
                    }
                    if (!Config.FORCE_INVENTORY_UPDATE) {
                        InventoryUpdate iu = new InventoryUpdate();
                        if (destroyItem.getCount() == 0L) {
                            iu.addRemovedItem(destroyItem);
                        } else {
                            iu.addModifiedItem(destroyItem);
                        }
                        if (crystals != null) {
                            iu.addItem(crystals);
                        }
                        activeChar.sendPacket(iu);
                    } else {
                        activeChar.sendPacket(new ItemList(activeChar, true));
                    }
                    L2World world = L2World.getInstance();
                    world.removeObject(destroyItem);
                    if (crystalId == 0) {
                        activeChar.sendPacket(new EnchantResult(4, 0, 0));
                    } else {
                        activeChar.sendPacket(new EnchantResult(1, crystalId, count));
                    }
                    if (Config.LOG_ITEM_ENCHANTS) {
                        LogRecord record = new LogRecord(Level.INFO, "Fail");
                        record.setParameters(new Object[]{activeChar, item, scroll, support, chance});
                        record.setLoggerName("item");
                        _logEnchant.log(record);
                    }
                }
            }
            StatusUpdate su = new StatusUpdate(activeChar);
            su.addAttribute(14, activeChar.getCurrentLoad());
            activeChar.sendPacket(su);
            activeChar.sendPacket(new ItemList(activeChar, false));
            activeChar.broadcastUserInfo();
            activeChar.setActiveEnchantItem(null);
        }
    }

    @Override
    public String getType() {
        return _C__58_REQUESTENCHANTITEM;
    }
}

