/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AskJoinParty;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestJoinParty
extends L2GameClientPacket {
    private static final String _C__29_REQUESTJOINPARTY = "[C] 29 RequestJoinParty";
    private static Logger _log = Logger.getLogger(RequestJoinParty.class.getName());
    private String _name;
    private int _itemDistribution;

    @Override
    protected void readImpl() {
        this._name = this.readS();
        this._itemDistribution = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance requestor = ((L2GameClient)this.getClient()).getActiveChar();
        L2PcInstance target = L2World.getInstance().getPlayer(this._name);
        if (requestor == null) {
            return;
        }
        if (target == null) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.FIRST_SELECT_USER_TO_INVITE_TO_PARTY));
            return;
        }
        if (target.getAppearance().getInvisible()) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
            return;
        }
        if (target.isInParty()) {
            SystemMessage msg = new SystemMessage(SystemMessageId.C1_IS_ALREADY_IN_PARTY);
            msg.addString(target.getName());
            requestor.sendPacket(msg);
            return;
        }
        if (BlockList.isBlocked(target, requestor)) {
            SystemMessage sm = new SystemMessage(SystemMessageId.S1_HAS_ADDED_YOU_TO_IGNORE_LIST);
            sm.addCharName(target);
            requestor.sendPacket(sm);
            return;
        }
        if (target == requestor) {
            if (requestor.isGM()) {
                requestor.setParty(new L2Party(requestor, this._itemDistribution));
                requestor.sendPacket(new SystemMessage(SystemMessageId.YOU_JOINED_S1_PARTY).addString(requestor.getName()));
                return;
            }
            requestor.sendPacket(new SystemMessage(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET));
            return;
        }
        if (target.isCursedWeaponEquipped() || requestor.isCursedWeaponEquipped()) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.INCORRECT_TARGET));
            return;
        }
        if (target.isInJail() || requestor.isInJail()) {
            requestor.sendMessage("\u76f8\u624b\u306fGM\u76f8\u8ac7\u6240\u306b\u5c45\u307e\u3059\u3002");
            return;
        }
        if (target.getClient().isDetached()) {
            requestor.sendMessage("\u76f8\u624b\u306f\u30aa\u30d5\u30e9\u30a4\u30f3\u9732\u5e97\u4e2d\u3067\u3059\u3002");
            return;
        }
        if (target.isInOlympiadMode() || requestor.isInOlympiadMode()) {
            return;
        }
        SystemMessage info = new SystemMessage(SystemMessageId.C1_INVITED_TO_PARTY);
        info.addCharName(target);
        requestor.sendPacket(info);
        if (!requestor.isInParty()) {
            this.createNewParty(target, requestor);
        } else if (requestor.getParty().isInDimensionalRift()) {
            requestor.sendMessage("\u6b21\u5143\u306e\u72ed\u9593\u3067\u306f\u62db\u5f85\u3067\u304d\u307e\u305b\u3093\u3002");
        } else {
            this.addTargetToParty(target, requestor);
        }
    }

    private void addTargetToParty(L2PcInstance target, L2PcInstance requestor) {
        SystemMessage msg;
        L2Party party = requestor.getParty();
        if (!party.isLeader(requestor)) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.ONLY_LEADER_CAN_INVITE));
            return;
        }
        if (party.getMemberCount() >= 9) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.PARTY_FULL));
            return;
        }
        if (party.getPendingInvitation() && !party.isInvitationRequestExpired()) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.WAITING_FOR_ANOTHER_REPLY));
            return;
        }
        if (!target.isProcessingRequest()) {
            requestor.onTransactionRequest(target);
            target.sendPacket(new AskJoinParty(requestor.getName(), party.getLootDistribution()));
            party.setPendingInvitation(true);
            if (Config.DEBUG) {
                _log.fine("sent out a party invitation to:" + target.getName());
            }
        } else {
            msg = new SystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            msg.addString(target.getName());
            requestor.sendPacket(msg);
            if (Config.DEBUG) {
                _log.warning(requestor.getName() + " already received a party invitation");
            }
        }
        msg = null;
    }

    private void createNewParty(L2PcInstance target, L2PcInstance requestor) {
        if (!target.isProcessingRequest()) {
            requestor.setParty(new L2Party(requestor, this._itemDistribution));
            requestor.onTransactionRequest(target);
            target.sendPacket(new AskJoinParty(requestor.getName(), this._itemDistribution));
            requestor.getParty().setPendingInvitation(true);
            if (Config.DEBUG) {
                _log.fine("sent out a party invitation to:" + target.getName());
            }
        } else {
            requestor.sendPacket(new SystemMessage(SystemMessageId.WAITING_FOR_ANOTHER_REPLY));
            if (Config.DEBUG) {
                _log.warning(requestor.getName() + " already received a party invitation");
            }
        }
    }

    @Override
    public String getType() {
        return _C__29_REQUESTJOINPARTY;
    }
}

