/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.clientpackets.RequestSurrenderPledgeWar;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestSurrenderPersonally
extends L2GameClientPacket {
    private static final String _C__69_REQUESTSURRENDERPERSONALLY = "[C] 69 RequestSurrenderPersonally";
    private static Logger _log = Logger.getLogger(RequestSurrenderPledgeWar.class.getName());
    private String _pledgeName;
    private L2Clan _clan;
    private L2PcInstance _activeChar;

    @Override
    protected void readImpl() {
        this._pledgeName = this.readS();
    }

    @Override
    protected void runImpl() {
        this._activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (this._activeChar == null) {
            return;
        }
        _log.info("RequestSurrenderPersonally by " + ((L2GameClient)this.getClient()).getActiveChar().getName() + " with " + this._pledgeName);
        this._clan = ((L2GameClient)this.getClient()).getActiveChar().getClan();
        L2Clan clan = ClanTable.getInstance().getClanByName(this._pledgeName);
        if (this._clan == null) {
            return;
        }
        if (clan == null) {
            this._activeChar.sendMessage("No such clan.");
            this._activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!this._clan.isAtWarWith(clan.getClanId()) || this._activeChar.getWantsPeace() == 1) {
            this._activeChar.sendMessage("You aren't at war with this clan.");
            this._activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        this._activeChar.setWantsPeace(1);
        this._activeChar.deathPenalty(false, false, false);
        SystemMessage msg = new SystemMessage(SystemMessageId.YOU_HAVE_PERSONALLY_SURRENDERED_TO_THE_S1_CLAN);
        msg.addString(this._pledgeName);
        this._activeChar.sendPacket(msg);
        msg = null;
        ClanTable.getInstance().checkSurrender(this._clan, clan);
    }

    @Override
    public String getType() {
        return _C__69_REQUESTSURRENDERPERSONALLY;
    }
}

