/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Collection;
import java.util.List;

public final class BuyList
extends L2GameServerPacket {
    private static final String _S__1D_BUYLIST = "[S] 07 BuyList";
    private int _listId;
    private Collection<L2TradeList.L2TradeItem> _list;
    private long _money;
    private double _taxRate = 0.0;

    public BuyList(L2TradeList list, long currentMoney) {
        this._listId = list.getListId();
        this._list = list.getItems();
        this._money = currentMoney;
    }

    public BuyList(L2TradeList list, long currentMoney, double taxRate) {
        this._listId = list.getListId();
        this._list = list.getItems();
        this._money = currentMoney;
        this._taxRate = taxRate;
    }

    public BuyList(List<L2TradeList.L2TradeItem> lst, int listId, long currentMoney) {
        this._listId = listId;
        this._list = lst;
        this._money = currentMoney;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(7);
        this.writeQ(this._money);
        this.writeD(this._listId);
        this.writeH(this._list.size());
        for (L2TradeList.L2TradeItem item : this._list) {
            long item_getCurrentCount = item.getCurrentCount();
            if (item_getCurrentCount <= 0L && item.hasLimitedStock()) continue;
            this.writeH(item.getTemplate().getType1());
            this.writeD(0);
            this.writeD(item.getItemId());
            this.writeQ(item_getCurrentCount < 0L ? 0L : item_getCurrentCount);
            this.writeH(item.getTemplate().getType2());
            this.writeH(0);
            if (item.getTemplate().getType1() != 4) {
                this.writeD(item.getTemplate().getBodyPart());
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
            } else {
                this.writeD(0);
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
            }
            int item_getItemId = item.getItemId();
            if (item_getItemId >= 3960 && item_getItemId <= 4026 || item_getItemId >= 5205 && item_getItemId <= 5219 || item_getItemId >= 6038 && item_getItemId <= 6306 || item_getItemId >= 6779 && item_getItemId <= 6833 || item_getItemId >= 7918 && item_getItemId <= 8029) {
                this.writeQ((long)((double)((float)item.getPrice() * Config.RATE_SIEGE_GUARDS_PRICE) * (1.0 + this._taxRate)));
            } else {
                this.writeQ((long)((double)item.getPrice() * (1.0 + this._taxRate)));
            }
            for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                this.writeH(0);
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__1D_BUYLIST;
    }
}

