/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.gameserver.Item;
import com.l2jserver.gameserver.skills.DocumentBase;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import java.io.File;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class DocumentItem
extends DocumentBase {
    private Item _currentItem = null;
    private List<L2Item> _itemsInFile = new FastList();
    private Map<Integer, Item> _itemData = new FastMap();

    public DocumentItem(Map<Integer, Item> pItemData, File file) {
        super(file);
        this._itemData = pItemData;
    }

    private void setCurrentItem(Item item) {
        this._currentItem = item;
    }

    @Override
    protected StatsSet getStatsSet() {
        return this._currentItem.set;
    }

    @Override
    protected String getTableValue(String name) {
        return ((String[])this._tables.get(name))[this._currentItem.currentLevel];
    }

    @Override
    protected String getTableValue(String name, int idx) {
        return ((String[])this._tables.get(name))[idx - 1];
    }

    @Override
    protected void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("list".equalsIgnoreCase(n.getNodeName())) {
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                    this.setCurrentItem(new Item());
                    this.parseItem(d);
                    this._itemsInFile.add(this._currentItem.item);
                    this.resetTable();
                }
                continue;
            }
            if (!"item".equalsIgnoreCase(n.getNodeName())) continue;
            this.setCurrentItem(new Item());
            this.parseItem(n);
            this._itemsInFile.add(this._currentItem.item);
        }
    }

    protected void parseItem(Node n) {
        Node first;
        int itemId = Integer.parseInt(n.getAttributes().getNamedItem("id").getNodeValue());
        String itemName = n.getAttributes().getNamedItem("name").getNodeValue();
        this._currentItem.id = itemId;
        this._currentItem.name = itemName;
        Item item = this._itemData.get(this._currentItem.id);
        if (item == null) {
            throw new IllegalStateException("No SQL data for Item ID: " + itemId + " - name: " + itemName);
        }
        this._currentItem.set = item.set;
        this._currentItem.type = item.type;
        for (n = first = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"table".equalsIgnoreCase(n.getNodeName())) continue;
            this.parseTable(n);
        }
        for (n = first; n != null; n = n.getNextSibling()) {
            if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
            this.parseBeanSet(n, this._itemData.get((Object)Integer.valueOf((int)this._currentItem.id)).set, 1);
        }
        for (n = first; n != null; n = n.getNextSibling()) {
            if (!"for".equalsIgnoreCase(n.getNodeName())) continue;
            this.makeItem();
            this.parseTemplate(n, this._currentItem.item);
        }
        for (n = first; n != null; n = n.getNextSibling()) {
            if (!"cond".equalsIgnoreCase(n.getNodeName())) continue;
            Condition condition = this.parseCondition(n.getFirstChild(), this._currentItem.item);
            Node msg = n.getAttributes().getNamedItem("msg");
            Node msgId = n.getAttributes().getNamedItem("msgId");
            if (condition != null && msg != null) {
                condition.setMessage(msg.getNodeValue());
            } else if (condition != null && msgId != null) {
                condition.setMessageId(Integer.decode(this.getValue(msgId.getNodeValue(), null)));
                Node addName = n.getAttributes().getNamedItem("addName");
                if (addName != null && Integer.decode(this.getValue(msgId.getNodeValue(), null)) > 0) {
                    condition.addName();
                }
            }
            this._currentItem.item.attach(condition);
        }
        for (n = first; n != null; n = n.getNextSibling()) {
            if (!"skill".equalsIgnoreCase(n.getNodeName())) continue;
            this.attachSkill(n, this._currentItem.item, null);
        }
    }

    private void makeItem() {
        if (this._currentItem.item != null) {
            return;
        }
        if (this._currentItem.type instanceof L2ArmorType) {
            this._currentItem.item = new L2Armor((L2ArmorType)this._currentItem.type, this._currentItem.set);
        } else if (this._currentItem.type instanceof L2WeaponType) {
            this._currentItem.item = new L2Weapon((L2WeaponType)this._currentItem.type, this._currentItem.set);
        } else if (this._currentItem.type instanceof L2EtcItemType) {
            this._currentItem.item = new L2EtcItem((L2EtcItemType)this._currentItem.type, this._currentItem.set);
        } else {
            throw new Error("Unknown item type " + this._currentItem.type);
        }
    }

    public List<L2Item> getItemList() {
        return this._itemsInFile;
    }
}

