/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectBetray
extends L2Effect {
    public EffectBetray(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.BETRAY;
    }

    @Override
    public boolean onStart() {
        if (this.getEffector() instanceof L2PcInstance && this.getEffected() instanceof L2Summon) {
            L2PcInstance targetOwner = this.getEffected().getActingPlayer();
            this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, targetOwner);
            this.getEffected().setIsBetrayed(true);
            if (targetOwner != null) {
                targetOwner.setIsBetrayed(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onExit() {
        this.getEffected().setIsBetrayed(false);
        this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        L2PcInstance targetOwner = this.getEffected().getActingPlayer();
        if (targetOwner != null) {
            targetOwner.setIsBetrayed(false);
        }
    }

    @Override
    public boolean onActionTime() {
        return false;
    }
}

