/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;

public class EffectSilentMove
extends L2Effect {
    public EffectSilentMove(Env env, EffectTemplate template) {
        super(env, template);
    }

    public EffectSilentMove(Env env, L2Effect effect) {
        super(env, effect);
    }

    @Override
    public boolean onStart() {
        super.onStart();
        L2Character effected = this.getEffected();
        if (effected instanceof L2Playable) {
            ((L2Playable)effected).setSilentMoving(true);
        }
        return true;
    }

    @Override
    public void onExit() {
        super.onExit();
        L2Character effected = this.getEffected();
        if (effected instanceof L2Playable) {
            ((L2Playable)effected).setSilentMoving(false);
        }
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.SILENT_MOVE;
    }

    @Override
    public boolean onActionTime() {
        if (this.getSkill().getSkillType() != L2SkillType.CONT) {
            return false;
        }
        if (this.getEffected().isDead()) {
            return false;
        }
        double manaDam = this.calc();
        if (manaDam > this.getEffected().getCurrentMp()) {
            this.getEffected().sendPacket(new SystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP));
            return false;
        }
        this.getEffected().reduceCurrentMp(manaDam);
        return true;
    }
}

