/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.util.ExtensionFunction;
import com.l2jserver.gameserver.util.JarClassLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicExtension {
    private static Logger _log = Logger.getLogger(DynamicExtension.class.getCanonicalName());
    private JarClassLoader _classLoader;
    private Properties _prop;
    private ConcurrentHashMap<String, Object> _loadedExtensions;
    private ConcurrentHashMap<String, ExtensionFunction> _getters = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ExtensionFunction> _setters = new ConcurrentHashMap();

    private DynamicExtension() {
        this.initExtensions();
    }

    public static DynamicExtension getInstance() {
        return SingletonHolder._instance;
    }

    public Object getExtension(String className) {
        return this._loadedExtensions.get(className);
    }

    public String initExtensions() {
        this._prop = new Properties();
        String res = "";
        this._loadedExtensions = new ConcurrentHashMap();
        try {
            this._prop.load(new FileInputStream("./config/extensions.properties"));
        }
        catch (FileNotFoundException ex) {
            _log.info(ex.getMessage() + ": no extensions to load");
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, "could not load properties", ex);
        }
        this._classLoader = new JarClassLoader();
        for (Object o : this._prop.keySet()) {
            String k = (String)o;
            if (!k.endsWith("Class")) continue;
            res = res + this.initExtension(this._prop.getProperty(k)) + "\n";
        }
        return res;
    }

    public String initExtension(String name) {
        String className = name;
        String[] p = name.split("@");
        String res = name + " loaded";
        if (p.length > 1) {
            this._classLoader.addJarFile(p[1]);
            className = p[0];
        }
        if (this._loadedExtensions.containsKey(className)) {
            return "already loaded";
        }
        try {
            Class<?> extension = Class.forName(className, true, this._classLoader);
            Object obj = extension.newInstance();
            extension.getMethod("init", new Class[0]).invoke(obj, new Object[0]);
            _log.info("Extension " + className + " loaded.");
            this._loadedExtensions.put(className, obj);
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, name, ex);
            res = ex.toString();
        }
        return res;
    }

    protected void clearCache() {
        this._classLoader = new JarClassLoader();
    }

    public String unloadExtensions() {
        String res = "";
        for (String e : this._loadedExtensions.keySet()) {
            res = res + this.unloadExtension(e) + "\n";
        }
        return res;
    }

    public String[] getExtensions() {
        String[] l = new String[this._loadedExtensions.size()];
        this._loadedExtensions.keySet().toArray(l);
        return l;
    }

    public String unloadExtension(String name) {
        String className = name;
        String[] p = name.split("@");
        if (p.length > 1) {
            this._classLoader.addJarFile(p[1]);
            className = p[0];
        }
        String res = className + " unloaded";
        try {
            Object obj = this._loadedExtensions.get(className);
            Class<?> extension = obj.getClass();
            this._loadedExtensions.remove(className);
            extension.getMethod("unload", new Class[0]).invoke(obj, new Object[0]);
            _log.info("Extension " + className + " unloaded.");
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, "could not unload " + className, ex);
            res = ex.toString();
        }
        return res;
    }

    public void reload() {
        this.unloadExtensions();
        this.clearCache();
        this.initExtensions();
    }

    public void reload(String name) {
        this.unloadExtension(name);
        this.clearCache();
        this.initExtension(name);
    }

    public void addGetter(String name, ExtensionFunction function) {
        this._getters.put(name, function);
    }

    public void removeGetter(String name) {
        this._getters.remove(name);
    }

    public Object get(String name, String arg) {
        ExtensionFunction func = this._getters.get(name);
        if (func != null) {
            return func.get(arg);
        }
        return "<none>";
    }

    public void addSetter(String name, ExtensionFunction function) {
        this._setters.put(name, function);
    }

    public void removeSetter(String name) {
        this._setters.remove(name);
    }

    public void set(String name, String arg, Object obj) {
        ExtensionFunction func = this._setters.get(name);
        if (func != null) {
            func.set(arg, obj);
        }
    }

    public JarClassLoader getClassLoader() {
        return this._classLoader;
    }

    private static class SingletonHolder {
        protected static final DynamicExtension _instance = new DynamicExtension();

        private SingletonHolder() {
        }
    }
}

