/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;

public class MultiSort {
    public static final int SORT_ASCENDING = 0;
    public static final int SORT_DESCENDING = 1;
    private List<?> _keyList;
    private List<Integer> _valueList;
    private boolean _isSortDescending;
    private boolean _isSorted;

    public MultiSort(int[] valueList) {
        this._valueList = this.getIntList(valueList);
    }

    public MultiSort(Collection<Integer> valueList) {
        this._valueList = this.getIntList(valueList);
    }

    public MultiSort(Object[] keyList, int[] valueList) {
        this._keyList = this.getList(keyList);
        this._valueList = this.getIntList(valueList);
    }

    public MultiSort(Map<?, Integer> valueMap) {
        this._keyList = this.getList(valueMap.keySet());
        this._valueList = this.getIntList(valueMap.values());
    }

    private final List<Integer> getIntList(Collection<Integer> valueList) {
        return Arrays.asList(valueList.toArray(new Integer[valueList.size()]));
    }

    private final List<Integer> getIntList(int[] valueList) {
        Integer[] tempIntList = new Integer[valueList.length];
        for (int i = 0; i < valueList.length; ++i) {
            tempIntList[i] = valueList[i];
        }
        return Arrays.asList(tempIntList);
    }

    private final List<?> getList(Collection<?> valueList) {
        return this.getList(valueList.toArray(new Object[valueList.size()]));
    }

    private final List<Object> getList(Object[] valueList) {
        return Arrays.asList(valueList);
    }

    public final int getCount() {
        return this.getValues().size();
    }

    public final int getHarmonicMean() {
        if (this.getValues().isEmpty()) {
            return -1;
        }
        int totalValue = 0;
        for (int currValue : this.getValues()) {
            totalValue += 1 / currValue;
        }
        return this.getCount() / totalValue;
    }

    public final List<?> getKeys() {
        if (this._keyList == null) {
            return new FastList();
        }
        return this._keyList;
    }

    public final int getFrequency(int checkValue) {
        return Collections.frequency(this.getValues(), checkValue);
    }

    public final int getMaxValue() {
        return Collections.max(this.getValues());
    }

    public final int getMinValue() {
        return Collections.min(this.getValues());
    }

    public final int getMean() {
        if (this.getValues().isEmpty()) {
            return -1;
        }
        return this.getTotalValue() / this.getCount();
    }

    public final double getStandardDeviation() {
        if (this.getValues().isEmpty()) {
            return -1.0;
        }
        FastList tempValList = new FastList();
        int meanValue = this.getMean();
        int numValues = this.getCount();
        for (int value : this.getValues()) {
            double adjValue = Math.pow(value - meanValue, 2.0);
            tempValList.add(adjValue);
        }
        double totalValue = 0.0;
        Iterator i$ = tempValList.iterator();
        while (i$.hasNext()) {
            double storedVal = (Double)i$.next();
            totalValue += storedVal;
        }
        return Math.sqrt(totalValue / (double)(numValues - 1));
    }

    public final int getTotalValue() {
        if (this.getValues().isEmpty()) {
            return 0;
        }
        int totalValue = 0;
        for (int currValue : this.getValues()) {
            totalValue += currValue;
        }
        return totalValue;
    }

    public final List<Integer> getValues() {
        if (this._valueList == null) {
            return new FastList();
        }
        return this._valueList;
    }

    public final boolean isSortDescending() {
        return this._isSortDescending;
    }

    public final boolean isSorted() {
        return this._isSorted;
    }

    public final void setSortDescending(boolean isDescending) {
        this._isSortDescending = isDescending;
    }

    public boolean sort() {
        try {
            FastList newKeyList = new FastList();
            FastList newValueList = new FastList();
            Collections.sort(this.getValues());
            int lastValue = 0;
            if (!this.isSortDescending()) {
                if (this.getKeys().isEmpty()) {
                    return true;
                }
                for (int i = this.getValues().size() - 1; i > -1; --i) {
                    int currValue = this.getValues().get(i);
                    if (currValue == lastValue) continue;
                    lastValue = currValue;
                    for (int j = 0; j < this.getKeys().size(); ++j) {
                        Object currKey = this.getKeys().get(j);
                        if (this.getValues().get(j) != currValue) continue;
                        newKeyList.add(currKey);
                        newValueList.add(currValue);
                    }
                }
            } else {
                if (this.getKeys().isEmpty()) {
                    Collections.reverse(this.getValues());
                    return true;
                }
                for (int i = 0; i < this.getValues().size(); ++i) {
                    int currValue = this.getValues().get(i);
                    if (currValue == lastValue) continue;
                    lastValue = currValue;
                    for (int j = 0; j < this.getKeys().size(); ++j) {
                        Object currKey = this.getKeys().get(j);
                        if (this.getValues().get(j) != currValue) continue;
                        newKeyList.add(currKey);
                        newValueList.add(currValue);
                    }
                }
            }
            this._keyList = newKeyList;
            this._valueList = newValueList;
            this._isSorted = true;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

