﻿## Active Perl 5.8.8

# L2J properties reflect tool

use utf8;
use strict;
use warnings;
use Encoding;

binmode STDOUT,':encoding(cp932)';
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $srcFilePath = 'properties_reflect.htm';
my $htmFilePath = 'server-properties.html';

my %properties;

&propertiesRead('gameserver/config/');

print 'load: ',$srcFilePath,"\n";
open FILE, '<:bytes', FS($srcFilePath)  or die "'$srcFilePath' $!";
read FILE, my $htm, -s FILE;
close FILE;
my $original = $htm;

#    <td>rate:</td><td>%rate%</td>
#--> <td>rate:</td><td>50</td>

for my($key,$val) (each(%properties)) {
	$htm =~ s/%$key%/$val/g;
}

if ($htm ne $original) {
	print 'save: ',$htmFilePath,"\n";
	open FILE, '>:bytes', FS($htmFilePath)  or die "'$htmFilePath' $!";
	print $htm;
	close FILE;
}
exit 0;

sub propertiesRead
{
	foreach my $subDir (@_) {
		next unless -d $subDir;
		opendir DIR, FS($subDir);
		my @files = readdir DIR; foreach (@files) {$_ = UTF8($_)}
		closedir DIR;

		foreach my $fileName (@files) {
			next if $fileName =~ m/^\./;
			next if $fileName =~ m/ /;
			my $filePath = $subDir.$fileName;
			if (-d FS($filePath)) {
				next;
			} elsif ($fileName =~ m/\.properties$/) {
				print "read: ",$filePath,"\n";
				open FILE, '<', FS($filePath)  or die "'$filePath' $!";
				my @A = <FILE>;
				close FILE;
				foreach $L (@A) {
					chomp $L;
					$L =~ s/#.+$//s;
					$L =~ s/\s+$//s;
					next if $L eq '';
					my @T = split /=/, $L;
					die if $#T != 1;
					my $key = $T[0];
					my $val = $T[1];
					$properties{$key} = $val;
				}
			}
		}
	}
}
