/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.model.L2Skill;
import gnu.trove.TIntIntHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SkillSpellbookTable {
    private static Logger _log = Logger.getLogger(SkillTreeTable.class.getName());
    private static TIntIntHashMap _skillSpellbooks;

    public static SkillSpellbookTable getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SkillSpellbookTable() {
        if (!Config.SP_BOOK_NEEDED) {
            return;
        }
        _skillSpellbooks = new TIntIntHashMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT skill_id, item_id FROM skill_spellbooks");
            ResultSet spbooks = statement.executeQuery();
            while (spbooks.next()) {
                _skillSpellbooks.put(spbooks.getInt("skill_id"), spbooks.getInt("item_id"));
            }
            spbooks.close();
            statement.close();
            _log.info("SkillSpellbookTable: Loaded " + _skillSpellbooks.size() + " Spellbooks.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while loading spellbook data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public int getBookForSkill(int skillId, int level) {
        if (skillId == 1405 && level != -1) {
            switch (level) {
                case 1: {
                    return 8618;
                }
                case 2: {
                    return 8619;
                }
                case 3: {
                    return 8620;
                }
                case 4: {
                    return 8621;
                }
            }
            return -1;
        }
        if (!Config.SP_BOOK_NEEDED) {
            return -1;
        }
        if (!_skillSpellbooks.containsKey(skillId)) {
            return -1;
        }
        return _skillSpellbooks.get(skillId);
    }

    public int getBookForSkill(L2Skill skill) {
        return this.getBookForSkill(skill.getId(), -1);
    }

    public int getBookForSkill(L2Skill skill, int level) {
        return this.getBookForSkill(skill.getId(), level);
    }

    private static class SingletonHolder {
        protected static final SkillSpellbookTable _instance = new SkillSpellbookTable();

        private SingletonHolder() {
        }
    }
}

